/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.gen.proto;

import org.jetbrains.annotations.Nullable;

public enum ResponseNote {
    SEQUENCE_FEED(1),
    ATOM_FEED(2),
    ORDER_BY_LIMIT_FEED(3),
    UNIONED_FEED(4),
    INCLUDES_STATES(5);

    public final int value;

    private ResponseNote(int value) {
        this.value = value;
    }

    public static ResponseNote fromValue(int value) {
        switch (value) {
            case 1: {
                return SEQUENCE_FEED;
            }
            case 2: {
                return ATOM_FEED;
            }
            case 3: {
                return ORDER_BY_LIMIT_FEED;
            }
            case 4: {
                return UNIONED_FEED;
            }
            case 5: {
                return INCLUDES_STATES;
            }
        }
        throw new IllegalArgumentException(String.format("%s is not a legal value for ResponseNote", value));
    }

    @Nullable
    public static ResponseNote maybeFromValue(int value) {
        try {
            return ResponseNote.fromValue(value);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public boolean isFeed() {
        switch (this) {
            case SEQUENCE_FEED: 
            case ATOM_FEED: 
            case ORDER_BY_LIMIT_FEED: 
            case UNIONED_FEED: {
                return true;
            }
        }
        return false;
    }
}

