/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.ast;

import com.fasterxml.jackson.core.type.TypeReference;
import com.rethinkdb.gen.ast.Binary;
import com.rethinkdb.gen.ast.Datum;
import com.rethinkdb.gen.proto.ResponseType;
import com.rethinkdb.gen.proto.TermType;
import com.rethinkdb.model.Arguments;
import com.rethinkdb.model.GroupedResult;
import com.rethinkdb.model.OptArgs;
import com.rethinkdb.net.Connection;
import com.rethinkdb.net.Result;
import com.rethinkdb.utils.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReqlAst {
    @NotNull
    protected final TermType termType;
    @Nullable
    protected final Arguments args;
    @Nullable
    protected final OptArgs optargs;

    protected ReqlAst(@NotNull TermType termType, @Nullable Arguments args, @Nullable OptArgs optargs) {
        this.termType = termType;
        this.args = args;
        this.optargs = optargs;
    }

    protected Object build() {
        ArrayList<Object> list = new ArrayList<Object>(3);
        list.add(this.termType.value);
        list.add(this.args == null || this.args.isEmpty() ? Collections.emptyList() : this.args.stream().map(ReqlAst::build).collect(Collectors.toList()));
        if (this.optargs != null && !this.optargs.isEmpty()) {
            list.add(ReqlAst.buildToMap(this.optargs));
        }
        return list;
    }

    public Result<Object> run(Connection conn) {
        return conn.run(this, new OptArgs(), null, null, null);
    }

    public Result<Object> run(Connection conn, OptArgs runOpts) {
        return conn.run(this, runOpts, null, null, null);
    }

    public Result<Object> run(Connection conn, Result.FetchMode fetchMode) {
        return conn.run(this, new OptArgs(), fetchMode, null, null);
    }

    public <T> Result<T> run(Connection conn, Class<T> typeRef) {
        return conn.run(this, new OptArgs(), null, null, Types.of(typeRef));
    }

    public <T> Result<T> run(Connection conn, TypeReference<T> typeRef) {
        return conn.run(this, new OptArgs(), null, null, typeRef);
    }

    public Result<Object> run(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode) {
        return conn.run(this, runOpts, fetchMode, null, null);
    }

    public <T> Result<T> run(Connection conn, OptArgs runOpts, Class<T> typeRef) {
        return conn.run(this, runOpts, null, null, Types.of(typeRef));
    }

    public <T> Result<T> run(Connection conn, OptArgs runOpts, TypeReference<T> typeRef) {
        return conn.run(this, runOpts, null, null, typeRef);
    }

    public <T> Result<T> run(Connection conn, Result.FetchMode fetchMode, Class<T> typeRef) {
        return conn.run(this, new OptArgs(), fetchMode, null, Types.of(typeRef));
    }

    public <T> Result<T> run(Connection conn, Result.FetchMode fetchMode, TypeReference<T> typeRef) {
        return conn.run(this, new OptArgs(), fetchMode, null, typeRef);
    }

    public <T> Result<T> run(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, Class<T> typeRef) {
        return conn.run(this, runOpts, fetchMode, null, Types.of(typeRef));
    }

    public <T> Result<T> run(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, TypeReference<T> typeRef) {
        return conn.run(this, runOpts, fetchMode, null, typeRef);
    }

    public CompletableFuture<Result<Object>> runAsync(Connection conn) {
        return conn.runAsync(this, new OptArgs(), null, null, null);
    }

    public CompletableFuture<Result<Object>> runAsync(Connection conn, OptArgs runOpts) {
        return conn.runAsync(this, runOpts, null, null, null);
    }

    public CompletableFuture<Result<Object>> runAsync(Connection conn, Result.FetchMode fetchMode) {
        return conn.runAsync(this, new OptArgs(), fetchMode, null, null);
    }

    public <T> CompletableFuture<Result<T>> runAsync(Connection conn, Class<T> typeRef) {
        return conn.runAsync(this, new OptArgs(), null, null, Types.of(typeRef));
    }

    public <T> CompletableFuture<Result<T>> runAsync(Connection conn, TypeReference<T> typeRef) {
        return conn.runAsync(this, new OptArgs(), null, null, typeRef);
    }

    public CompletableFuture<Result<Object>> runAsync(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode) {
        return conn.runAsync(this, runOpts, fetchMode, null, null);
    }

    public <T> CompletableFuture<Result<T>> runAsync(Connection conn, OptArgs runOpts, Class<T> typeRef) {
        return conn.runAsync(this, runOpts, null, null, Types.of(typeRef));
    }

    public <T> CompletableFuture<Result<T>> runAsync(Connection conn, OptArgs runOpts, TypeReference<T> typeRef) {
        return conn.runAsync(this, runOpts, null, null, typeRef);
    }

    public <T> CompletableFuture<Result<T>> runAsync(Connection conn, Result.FetchMode fetchMode, Class<T> typeRef) {
        return conn.runAsync(this, new OptArgs(), fetchMode, null, Types.of(typeRef));
    }

    public <T> CompletableFuture<Result<T>> runAsync(Connection conn, Result.FetchMode fetchMode, TypeReference<T> typeRef) {
        return conn.runAsync(this, new OptArgs(), fetchMode, null, typeRef);
    }

    public <T> CompletableFuture<Result<T>> runAsync(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, Class<T> typeRef) {
        return conn.runAsync(this, runOpts, fetchMode, null, Types.of(typeRef));
    }

    public <T> CompletableFuture<Result<T>> runAsync(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, TypeReference<T> typeRef) {
        return conn.runAsync(this, runOpts, fetchMode, null, typeRef);
    }

    public Object runAtom(Connection conn) {
        return ReqlAst.handleAtom(conn.run(this, new OptArgs(), null, false, null));
    }

    public Object runAtom(Connection conn, OptArgs runOpts) {
        return ReqlAst.handleAtom(conn.run(this, runOpts, null, false, null));
    }

    public Object runAtom(Connection conn, Result.FetchMode fetchMode) {
        return ReqlAst.handleAtom(conn.run(this, new OptArgs(), fetchMode, false, null));
    }

    public <T> T runAtom(Connection conn, Class<T> typeRef) {
        return ReqlAst.handleAtom(conn.run(this, new OptArgs(), null, false, Types.of(typeRef)));
    }

    public <T> T runAtom(Connection conn, TypeReference<T> typeRef) {
        return ReqlAst.handleAtom(conn.run(this, new OptArgs(), null, false, typeRef));
    }

    public Object runAtom(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode) {
        return ReqlAst.handleAtom(conn.run(this, runOpts, fetchMode, false, null));
    }

    public <T> T runAtom(Connection conn, OptArgs runOpts, Class<T> typeRef) {
        return ReqlAst.handleAtom(conn.run(this, runOpts, null, false, Types.of(typeRef)));
    }

    public <T> T runAtom(Connection conn, OptArgs runOpts, TypeReference<T> typeRef) {
        return ReqlAst.handleAtom(conn.run(this, runOpts, null, false, typeRef));
    }

    public <T> T runAtom(Connection conn, Result.FetchMode fetchMode, Class<T> typeRef) {
        return ReqlAst.handleAtom(conn.run(this, new OptArgs(), fetchMode, false, Types.of(typeRef)));
    }

    public <T> T runAtom(Connection conn, Result.FetchMode fetchMode, TypeReference<T> typeRef) {
        return ReqlAst.handleAtom(conn.run(this, new OptArgs(), fetchMode, false, typeRef));
    }

    public <T> T runAtom(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, Class<T> typeRef) {
        return ReqlAst.handleAtom(conn.run(this, runOpts, fetchMode, false, Types.of(typeRef)));
    }

    public <T> T runAtom(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, TypeReference<T> typeRef) {
        return ReqlAst.handleAtom(conn.run(this, runOpts, fetchMode, false, typeRef));
    }

    public CompletableFuture<Object> runAtomAsync(Connection conn) {
        return conn.runAsync(this, new OptArgs(), null, false, null).thenApply(ReqlAst::handleAtom);
    }

    public CompletableFuture<Object> runAtomAsync(Connection conn, OptArgs runOpts) {
        return conn.runAsync(this, runOpts, null, false, null).thenApply(ReqlAst::handleAtom);
    }

    public CompletableFuture<Object> runAtomAsync(Connection conn, Result.FetchMode fetchMode) {
        return conn.runAsync(this, new OptArgs(), fetchMode, false, null).thenApply(ReqlAst::handleAtom);
    }

    public <T> CompletableFuture<T> runAtomAsync(Connection conn, Class<T> typeRef) {
        return conn.runAsync(this, new OptArgs(), null, false, Types.of(typeRef)).thenApply(ReqlAst::handleAtom);
    }

    public <T> CompletableFuture<T> runAtomAsync(Connection conn, TypeReference<T> typeRef) {
        return conn.runAsync(this, new OptArgs(), null, false, typeRef).thenApply(ReqlAst::handleAtom);
    }

    public CompletableFuture<Object> runAtomAsync(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode) {
        return conn.runAsync(this, runOpts, fetchMode, false, null).thenApply(ReqlAst::handleAtom);
    }

    public <T> CompletableFuture<T> runAtomAsync(Connection conn, OptArgs runOpts, Class<T> typeRef) {
        return conn.runAsync(this, runOpts, null, false, Types.of(typeRef)).thenApply(ReqlAst::handleAtom);
    }

    public <T> CompletableFuture<T> runAtomAsync(Connection conn, OptArgs runOpts, TypeReference<T> typeRef) {
        return conn.runAsync(this, runOpts, null, false, typeRef).thenApply(ReqlAst::handleAtom);
    }

    public <T> CompletableFuture<T> runAtomAsync(Connection conn, Result.FetchMode fetchMode, Class<T> typeRef) {
        return conn.runAsync(this, new OptArgs(), fetchMode, false, Types.of(typeRef)).thenApply(ReqlAst::handleAtom);
    }

    public <T> CompletableFuture<T> runAtomAsync(Connection conn, Result.FetchMode fetchMode, TypeReference<T> typeRef) {
        return conn.runAsync(this, new OptArgs(), fetchMode, false, typeRef).thenApply(ReqlAst::handleAtom);
    }

    public <T> CompletableFuture<T> runAtomAsync(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, Class<T> typeRef) {
        return conn.runAsync(this, runOpts, fetchMode, false, Types.of(typeRef)).thenApply(ReqlAst::handleAtom);
    }

    public <T> CompletableFuture<T> runAtomAsync(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, TypeReference<T> typeRef) {
        return conn.runAsync(this, runOpts, fetchMode, false, typeRef).thenApply(ReqlAst::handleAtom);
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, Class<K> keyRef, Class<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, new OptArgs(), null, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, TypeReference<K> keyRef, Class<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, new OptArgs(), null, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, Class<K> keyRef, TypeReference<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, new OptArgs(), null, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, TypeReference<K> keyRef, TypeReference<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, new OptArgs(), null, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, TypeReference<GroupedResult<K, V>> typeRef) {
        return ReqlAst.handleGrouping(conn.run(this, new OptArgs(), null, true, typeRef));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, OptArgs runOpts, Class<K> keyRef, Class<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, runOpts, null, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, OptArgs runOpts, TypeReference<K> keyRef, Class<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, runOpts, null, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, OptArgs runOpts, Class<K> keyRef, TypeReference<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, runOpts, null, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, OptArgs runOpts, TypeReference<K> keyRef, TypeReference<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, runOpts, null, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, OptArgs runOpts, TypeReference<GroupedResult<K, V>> typeRef) {
        return ReqlAst.handleGrouping(conn.run(this, runOpts, null, true, typeRef));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, Result.FetchMode fetchMode, Class<K> keyRef, Class<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, new OptArgs(), fetchMode, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, Result.FetchMode fetchMode, TypeReference<K> keyRef, Class<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, new OptArgs(), fetchMode, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, Result.FetchMode fetchMode, Class<K> keyRef, TypeReference<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, new OptArgs(), fetchMode, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, Result.FetchMode fetchMode, TypeReference<K> keyRef, TypeReference<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, new OptArgs(), fetchMode, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, Result.FetchMode fetchMode, TypeReference<GroupedResult<K, V>> typeRef) {
        return ReqlAst.handleGrouping(conn.run(this, new OptArgs(), fetchMode, true, typeRef));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, Class<K> keyRef, Class<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, runOpts, fetchMode, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, TypeReference<K> keyRef, Class<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, runOpts, fetchMode, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, Class<K> keyRef, TypeReference<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, runOpts, fetchMode, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, TypeReference<K> keyRef, TypeReference<V> valueRef) {
        return ReqlAst.handleGrouping(conn.run(this, runOpts, fetchMode, true, Types.groupOf(keyRef, valueRef)));
    }

    public <K, V> Map<K, Set<V>> runGrouping(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, TypeReference<GroupedResult<K, V>> typeRef) {
        return ReqlAst.handleGrouping(conn.run(this, runOpts, fetchMode, true, typeRef));
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, Class<K> keyRef, Class<V> valueRef) {
        return conn.runAsync(this, new OptArgs(), null, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, TypeReference<K> keyRef, Class<V> valueRef) {
        return conn.runAsync(this, new OptArgs(), null, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, Class<K> keyRef, TypeReference<V> valueRef) {
        return conn.runAsync(this, new OptArgs(), null, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, TypeReference<K> keyRef, TypeReference<V> valueRef) {
        return conn.runAsync(this, new OptArgs(), null, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, TypeReference<GroupedResult<K, V>> typeRef) {
        return conn.runAsync(this, new OptArgs(), null, true, typeRef).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, OptArgs runOpts, Class<K> keyRef, Class<V> valueRef) {
        return conn.runAsync(this, runOpts, null, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, OptArgs runOpts, TypeReference<K> keyRef, Class<V> valueRef) {
        return conn.runAsync(this, runOpts, null, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, OptArgs runOpts, Class<K> keyRef, TypeReference<V> valueRef) {
        return conn.runAsync(this, runOpts, null, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, OptArgs runOpts, TypeReference<K> keyRef, TypeReference<V> valueRef) {
        return conn.runAsync(this, runOpts, null, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, OptArgs runOpts, TypeReference<GroupedResult<K, V>> typeRef) {
        return conn.runAsync(this, runOpts, null, true, typeRef).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, Result.FetchMode fetchMode, Class<K> keyRef, Class<V> valueRef) {
        return conn.runAsync(this, new OptArgs(), fetchMode, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, Result.FetchMode fetchMode, TypeReference<K> keyRef, Class<V> valueRef) {
        return conn.runAsync(this, new OptArgs(), fetchMode, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, Result.FetchMode fetchMode, Class<K> keyRef, TypeReference<V> valueRef) {
        return conn.runAsync(this, new OptArgs(), fetchMode, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, Result.FetchMode fetchMode, TypeReference<K> keyRef, TypeReference<V> valueRef) {
        return conn.runAsync(this, new OptArgs(), fetchMode, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, Result.FetchMode fetchMode, TypeReference<GroupedResult<K, V>> typeRef) {
        return conn.runAsync(this, new OptArgs(), fetchMode, true, typeRef).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, Class<K> keyRef, Class<V> valueRef) {
        return conn.runAsync(this, runOpts, fetchMode, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, TypeReference<K> keyRef, Class<V> valueRef) {
        return conn.runAsync(this, runOpts, fetchMode, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, Class<K> keyRef, TypeReference<V> valueRef) {
        return conn.runAsync(this, runOpts, fetchMode, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, TypeReference<K> keyRef, TypeReference<V> valueRef) {
        return conn.runAsync(this, runOpts, fetchMode, true, Types.groupOf(keyRef, valueRef)).thenApply(ReqlAst::handleGrouping);
    }

    public <K, V> CompletableFuture<Map<K, Set<V>>> runGroupingAsync(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, TypeReference<GroupedResult<K, V>> typeRef) {
        return conn.runAsync(this, runOpts, fetchMode, true, typeRef).thenApply(ReqlAst::handleGrouping);
    }

    public Result<Object> runUnwrapping(Connection conn) {
        return conn.run(this, new OptArgs(), null, true, null);
    }

    public Result<Object> runUnwrapping(Connection conn, OptArgs runOpts) {
        return conn.run(this, runOpts, null, true, null);
    }

    public Result<Object> runUnwrapping(Connection conn, Result.FetchMode fetchMode) {
        return conn.run(this, new OptArgs(), fetchMode, true, null);
    }

    public <T> Result<T> runUnwrapping(Connection conn, Class<T> typeRef) {
        return conn.run(this, new OptArgs(), null, true, Types.of(typeRef));
    }

    public <T> Result<T> runUnwrapping(Connection conn, TypeReference<T> typeRef) {
        return conn.run(this, new OptArgs(), null, true, typeRef);
    }

    public Result<Object> runUnwrapping(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode) {
        return conn.run(this, runOpts, fetchMode, true, null);
    }

    public <T> Result<T> runUnwrapping(Connection conn, OptArgs runOpts, Class<T> typeRef) {
        return conn.run(this, runOpts, null, true, Types.of(typeRef));
    }

    public <T> Result<T> runUnwrapping(Connection conn, OptArgs runOpts, TypeReference<T> typeRef) {
        return conn.run(this, runOpts, null, true, typeRef);
    }

    public <T> Result<T> runUnwrapping(Connection conn, Result.FetchMode fetchMode, Class<T> typeRef) {
        return conn.run(this, new OptArgs(), fetchMode, true, Types.of(typeRef));
    }

    public <T> Result<T> runUnwrapping(Connection conn, Result.FetchMode fetchMode, TypeReference<T> typeRef) {
        return conn.run(this, new OptArgs(), fetchMode, true, typeRef);
    }

    public <T> Result<T> runUnwrapping(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, Class<T> typeRef) {
        return conn.run(this, runOpts, fetchMode, true, Types.of(typeRef));
    }

    public <T> Result<T> runUnwrapping(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, TypeReference<T> typeRef) {
        return conn.run(this, runOpts, fetchMode, true, typeRef);
    }

    public CompletableFuture<Result<Object>> runUnwrappingAsync(Connection conn) {
        return conn.runAsync(this, new OptArgs(), null, true, null);
    }

    public CompletableFuture<Result<Object>> runUnwrappingAsync(Connection conn, OptArgs runOpts) {
        return conn.runAsync(this, runOpts, null, true, null);
    }

    public CompletableFuture<Result<Object>> runUnwrappingAsync(Connection conn, Result.FetchMode fetchMode) {
        return conn.runAsync(this, new OptArgs(), fetchMode, true, null);
    }

    public <T> CompletableFuture<Result<T>> runUnwrappingAsync(Connection conn, Class<T> typeRef) {
        return conn.runAsync(this, new OptArgs(), null, true, Types.of(typeRef));
    }

    public <T> CompletableFuture<Result<T>> runUnwrappingAsync(Connection conn, TypeReference<T> typeRef) {
        return conn.runAsync(this, new OptArgs(), null, true, typeRef);
    }

    public CompletableFuture<Result<Object>> runUnwrappingAsync(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode) {
        return conn.runAsync(this, runOpts, fetchMode, true, null);
    }

    public <T> CompletableFuture<Result<T>> runUnwrappingAsync(Connection conn, OptArgs runOpts, Class<T> typeRef) {
        return conn.runAsync(this, runOpts, null, true, Types.of(typeRef));
    }

    public <T> CompletableFuture<Result<T>> runUnwrappingAsync(Connection conn, OptArgs runOpts, TypeReference<T> typeRef) {
        return conn.runAsync(this, runOpts, null, true, typeRef);
    }

    public <T> CompletableFuture<Result<T>> runUnwrappingAsync(Connection conn, Result.FetchMode fetchMode, Class<T> typeRef) {
        return conn.runAsync(this, new OptArgs(), fetchMode, true, Types.of(typeRef));
    }

    public <T> CompletableFuture<Result<T>> runUnwrappingAsync(Connection conn, Result.FetchMode fetchMode, TypeReference<T> typeRef) {
        return conn.runAsync(this, new OptArgs(), fetchMode, true, typeRef);
    }

    public <T> CompletableFuture<Result<T>> runUnwrappingAsync(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, Class<T> typeRef) {
        return conn.runAsync(this, runOpts, fetchMode, true, Types.of(typeRef));
    }

    public <T> CompletableFuture<Result<T>> runUnwrappingAsync(Connection conn, OptArgs runOpts, Result.FetchMode fetchMode, TypeReference<T> typeRef) {
        return conn.runAsync(this, runOpts, fetchMode, true, typeRef);
    }

    public void runNoReply(Connection conn) {
        conn.runNoReply(this, new OptArgs());
    }

    public void runNoReply(Connection conn, OptArgs runOpts) {
        conn.runNoReply(this, runOpts);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<root>\n");
        this.astToString(builder, null, "", true);
        return builder.toString();
    }

    private void astToString(StringBuilder builder, String name, String indent, boolean tail) {
        builder.append(indent).append(tail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ");
        if (name != null) {
            builder.append(name).append("=");
        }
        builder.append(this.getClass().getSimpleName()).append(':');
        if (this instanceof Datum) {
            Object datum = ((Datum)this).datum;
            builder.append(' ').append(datum).append(" (").append(datum.getClass().getSimpleName()).append(")");
        } else if (this instanceof Binary) {
            builder.append(' ');
            byte[] binaryData = ((Binary)this).binaryData;
            int length = binaryData != null ? binaryData.length : 0;
            builder.append('(').append(length).append(length != 1 ? " bytes" : " byte").append(")");
        }
        builder.append('\n');
        if (this.args != null) {
            Iterator argsIterator = this.args.iterator();
            while (argsIterator.hasNext()) {
                ReqlAst arg = (ReqlAst)argsIterator.next();
                arg.astToString(builder, null, indent + (tail ? "    " : "\u2502   "), !argsIterator.hasNext() && (this.optargs == null || this.optargs.isEmpty()));
            }
        }
        if (this.optargs != null && !this.optargs.isEmpty()) {
            builder.append(indent).append(tail ? "    " : "\u2502   ").append("\u2514\u2500\u2500 ").append("<optArgs>: \n");
            Iterator optIterator = this.optargs.entrySet().iterator();
            while (optIterator.hasNext()) {
                Map.Entry entry = optIterator.next();
                ((ReqlAst)entry.getValue()).astToString(builder, (String)entry.getKey(), indent + (tail ? "    " : "\u2502   ") + "    ", !optIterator.hasNext());
            }
        }
    }

    static Map<String, Object> buildToMap(OptArgs opts) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(opts.size());
        opts.forEach((name, arg) -> result.put((String)name, arg.build()));
        return result;
    }

    private static <T> T handleAtom(Result<T> result) {
        if (!result.responseType().equals((Object)ResponseType.SUCCESS_ATOM)) {
            throw new IllegalStateException("result is not an atom.");
        }
        return result.single();
    }

    private static <K, V> Map<K, Set<V>> handleGrouping(Result<GroupedResult<K, V>> result) {
        return GroupedResult.toMap(result.toList());
    }
}

