/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.ast;

import com.rethinkdb.ast.ReqlAst;
import com.rethinkdb.gen.exc.ReqlRuntimeError;
import com.rethinkdb.gen.proto.QueryType;
import com.rethinkdb.model.OptArgs;
import com.rethinkdb.utils.Internals;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query {
    private static final Logger LOGGER = LoggerFactory.getLogger(Query.class);
    @NotNull
    public final QueryType type;
    public final long token;
    @Nullable
    public final ReqlAst term;
    @Nullable
    public final OptArgs globalOptions;

    public Query(@NotNull QueryType type, long token, @Nullable ReqlAst term, @Nullable OptArgs globalOptions) {
        this.type = type;
        this.token = token;
        this.term = term;
        this.globalOptions = globalOptions;
    }

    public Query(@NotNull QueryType type, long token) {
        this(type, token, null, null);
    }

    public ByteBuffer serialize() {
        try {
            ArrayList<Object> list = new ArrayList<Object>(3);
            list.add(this.type.value);
            if (this.term != null) {
                list.add(this.term.build());
            }
            if (this.globalOptions != null && !this.globalOptions.isEmpty()) {
                list.add(ReqlAst.buildToMap(this.globalOptions));
            }
            String json = Internals.getInternalMapper().writeValueAsString(list);
            byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
            ByteBuffer buffer = ByteBuffer.allocate(12 + bytes.length).order(ByteOrder.LITTLE_ENDIAN).putLong(this.token).putInt(bytes.length).put(bytes);
            LOGGER.trace("JSON Send: Token: {} {}", (Object)this.token, (Object)json);
            return buffer;
        }
        catch (IOException e) {
            throw new ReqlRuntimeError(e);
        }
    }

    public static Query createStart(long token, ReqlAst term, OptArgs globalOptions) {
        return new Query(QueryType.START, token, term, globalOptions);
    }

    public static Query createContinue(long token) {
        return new Query(QueryType.CONTINUE, token);
    }

    public static Query createStop(long token) {
        return new Query(QueryType.STOP, token);
    }

    public static Query createNoreplyWait(long token) {
        return new Query(QueryType.NOREPLY_WAIT, token);
    }

    public static Query createServerInfo(long token) {
        return new Query(QueryType.SERVER_INFO, token);
    }
}

