/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.Header;
import org.elasticsearch.transport.InboundMessage;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.TransportRequest;

public class InboundAggregator
implements Releasable {
    private final Supplier<CircuitBreaker> circuitBreaker;
    private final Predicate<String> requestCanTripBreaker;
    private ReleasableBytesReference firstContent;
    private ArrayList<ReleasableBytesReference> contentAggregation;
    private Header currentHeader;
    private Exception aggregationException;
    private boolean canTripBreaker = true;
    private boolean isClosed = false;

    public InboundAggregator(Supplier<CircuitBreaker> circuitBreaker, Function<String, RequestHandlerRegistry<TransportRequest>> registryFunction) {
        this(circuitBreaker, (String actionName) -> {
            RequestHandlerRegistry reg = (RequestHandlerRegistry)registryFunction.apply((String)actionName);
            if (reg == null) {
                throw new ActionNotFoundTransportException((String)actionName);
            }
            return reg.canTripCircuitBreaker();
        });
    }

    InboundAggregator(Supplier<CircuitBreaker> circuitBreaker, Predicate<String> requestCanTripBreaker) {
        this.circuitBreaker = circuitBreaker;
        this.requestCanTripBreaker = requestCanTripBreaker;
    }

    public void headerReceived(Header header) {
        this.ensureOpen();
        assert (!this.isAggregating());
        assert (this.firstContent == null && this.contentAggregation == null);
        this.currentHeader = header;
        if (this.currentHeader.isRequest() && !this.currentHeader.needsToReadVariableHeader()) {
            this.initializeRequestState();
        }
    }

    public void aggregate(ReleasableBytesReference content) {
        this.ensureOpen();
        assert (this.isAggregating());
        if (!this.isShortCircuited()) {
            if (this.isFirstContent()) {
                this.firstContent = content.retain();
            } else {
                if (this.contentAggregation == null) {
                    this.contentAggregation = new ArrayList(4);
                    assert (this.firstContent != null);
                    this.contentAggregation.add(this.firstContent);
                    this.firstContent = null;
                }
                this.contentAggregation.add(content.retain());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundMessage finishAggregation() throws IOException {
        ReleasableBytesReference releasableContent;
        this.ensureOpen();
        if (this.isFirstContent()) {
            releasableContent = ReleasableBytesReference.wrap(BytesArray.EMPTY);
        } else if (this.contentAggregation == null) {
            releasableContent = this.firstContent;
        } else {
            BytesReference[] references = this.contentAggregation.toArray(new ReleasableBytesReference[0]);
            BytesReference content = CompositeBytesReference.of(references);
            releasableContent = new ReleasableBytesReference(content, () -> InboundAggregator.lambda$finishAggregation$1((ReleasableBytesReference[])references));
        }
        BreakerControl breakerControl = new BreakerControl(this.circuitBreaker);
        InboundMessage aggregated = new InboundMessage(this.currentHeader, releasableContent, breakerControl);
        boolean success = false;
        try {
            if (aggregated.getHeader().needsToReadVariableHeader()) {
                aggregated.getHeader().finishParsingHeader(aggregated.openOrGetStreamInput());
                if (aggregated.getHeader().isRequest()) {
                    this.initializeRequestState();
                }
            }
            if (!this.isShortCircuited()) {
                this.checkBreaker(aggregated.getHeader(), aggregated.getContentLength(), breakerControl);
            }
            if (this.isShortCircuited()) {
                aggregated.close();
                success = true;
                InboundMessage inboundMessage = new InboundMessage(aggregated.getHeader(), this.aggregationException);
                return inboundMessage;
            }
            success = true;
            InboundMessage inboundMessage = aggregated;
            return inboundMessage;
        }
        finally {
            this.resetCurrentAggregation();
            if (!success) {
                aggregated.close();
            }
        }
    }

    public boolean isAggregating() {
        return this.currentHeader != null;
    }

    private void shortCircuit(Exception exception) {
        this.aggregationException = exception;
    }

    private boolean isShortCircuited() {
        return this.aggregationException != null;
    }

    private boolean isFirstContent() {
        return this.firstContent == null && this.contentAggregation == null;
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.closeCurrentAggregation();
    }

    private void closeCurrentAggregation() {
        this.releaseContent();
        this.resetCurrentAggregation();
    }

    private void releaseContent() {
        if (this.contentAggregation == null) {
            Releasables.close(this.firstContent);
        } else {
            Releasables.close(this.contentAggregation);
        }
    }

    private void resetCurrentAggregation() {
        this.firstContent = null;
        this.contentAggregation = null;
        this.currentHeader = null;
        this.aggregationException = null;
        this.canTripBreaker = true;
    }

    private void ensureOpen() {
        if (this.isClosed) {
            throw new IllegalStateException("Aggregator is already closed");
        }
    }

    private void initializeRequestState() {
        assert (!this.currentHeader.needsToReadVariableHeader());
        assert (this.currentHeader.isRequest());
        if (this.currentHeader.isHandshake()) {
            this.canTripBreaker = false;
            return;
        }
        String actionName = this.currentHeader.getActionName();
        try {
            this.canTripBreaker = this.requestCanTripBreaker.test(actionName);
        }
        catch (ActionNotFoundTransportException e) {
            this.shortCircuit(e);
        }
    }

    private void checkBreaker(Header header, int contentLength, BreakerControl breakerControl) {
        if (!header.isRequest()) {
            return;
        }
        assert (!header.needsToReadVariableHeader());
        if (this.canTripBreaker) {
            try {
                this.circuitBreaker.get().addEstimateBytesAndMaybeBreak(contentLength, header.getActionName());
                breakerControl.setReservedBytes(contentLength);
            }
            catch (CircuitBreakingException e) {
                this.shortCircuit(e);
            }
        } else {
            this.circuitBreaker.get().addWithoutBreaking(contentLength);
            breakerControl.setReservedBytes(contentLength);
        }
    }

    private static /* synthetic */ void lambda$finishAggregation$1(ReleasableBytesReference[] references) {
        Releasables.close(references);
    }

    private static class BreakerControl
    implements Releasable {
        private static final int CLOSED = -1;
        private final Supplier<CircuitBreaker> circuitBreaker;
        private final AtomicInteger bytesToRelease = new AtomicInteger(0);

        private BreakerControl(Supplier<CircuitBreaker> circuitBreaker) {
            this.circuitBreaker = circuitBreaker;
        }

        private void setReservedBytes(int reservedBytes) {
            boolean set = this.bytesToRelease.compareAndSet(0, reservedBytes);
            assert (set) : "Expected bytesToRelease to be 0, found " + this.bytesToRelease.get();
        }

        @Override
        public void close() {
            int toRelease = this.bytesToRelease.getAndSet(-1);
            assert (toRelease != -1);
            if (toRelease > 0) {
                this.circuitBreaker.get().addWithoutBreaking(-toRelease);
            }
        }
    }
}

