/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;

public class FetchScorePhase
implements FetchSubPhase {
    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        if (!context.trackScores() || hits.length == 0 || context.sort() == null) {
            return;
        }
        ContextIndexSearcher searcher = context.searcher();
        Weight weight = searcher.createWeight(searcher.rewrite(context.query()), ScoreMode.COMPLETE, 1.0f);
        Iterator leafContextIterator = searcher.getIndexReader().leaves().iterator();
        LeafReaderContext leafContext = null;
        Scorer scorer = null;
        for (SearchHit hit : hits) {
            if (leafContext == null || leafContext.docBase + leafContext.reader().maxDoc() <= hit.docId()) {
                while ((leafContext = (LeafReaderContext)leafContextIterator.next()) == null || leafContext.docBase + leafContext.reader().maxDoc() <= hit.docId()) {
                }
                ScorerSupplier scorerSupplier = weight.scorerSupplier(leafContext);
                if (scorerSupplier == null) {
                    throw new IllegalStateException("Can't compute score on document " + hit + " as it doesn't match the query");
                }
                scorer = scorerSupplier.get(1L);
            }
            int leafDocID = hit.docId() - leafContext.docBase;
            assert (leafDocID >= 0 && leafDocID < leafContext.reader().maxDoc());
            int advanced = scorer.iterator().advance(leafDocID);
            if (advanced != leafDocID) {
                throw new IllegalStateException("Can't compute score on document " + hit + " as it doesn't match the query");
            }
            hit.score(scorer.score());
        }
    }
}

