/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.document.FieldType;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.TypeParsers;

public abstract class ParametrizedFieldMapper
extends FieldMapper {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(ParametrizedFieldMapper.class));

    protected ParametrizedFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, new FieldType(), mappedFieldType, multiFields, copyTo);
    }

    public abstract Builder getMergeBuilder();

    @Override
    public final ParametrizedFieldMapper merge(Mapper mergeWith) {
        if (!(mergeWith instanceof FieldMapper)) {
            throw new IllegalArgumentException("mapper [" + this.name() + "] cannot be changed from type [" + this.contentType() + "] to [" + mergeWith.getClass().getSimpleName() + "]");
        }
        if (!Objects.equals(this.getClass(), mergeWith.getClass())) {
            throw new IllegalArgumentException("mapper [" + this.name() + "] cannot be changed from type [" + this.contentType() + "] to [" + ((FieldMapper)mergeWith).contentType() + "]");
        }
        Builder builder = this.getMergeBuilder();
        Conflicts conflicts = new Conflicts(this.name());
        builder.merge((FieldMapper)mergeWith, conflicts);
        conflicts.check();
        return builder.build(new Mapper.BuilderContext(Settings.EMPTY, ParametrizedFieldMapper.parentPath(this.name())));
    }

    private static ContentPath parentPath(String name) {
        int endPos = name.lastIndexOf(".");
        if (endPos == -1) {
            return new ContentPath(0);
        }
        return new ContentPath(name.substring(0, endPos));
    }

    @Override
    protected final void mergeOptions(FieldMapper other, List<String> conflicts) {
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.simpleName());
        builder.field("type", this.contentType());
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        this.getMergeBuilder().toXContent(builder, includeDefaults);
        this.multiFields.toXContent(builder, params);
        this.copyTo.toXContent(builder, params);
        return builder.endObject();
    }

    public static abstract class Builder
    extends Mapper.Builder<Builder> {
        protected final FieldMapper.MultiFields.Builder multiFieldsBuilder = new FieldMapper.MultiFields.Builder();
        protected final FieldMapper.CopyTo.Builder copyTo = new FieldMapper.CopyTo.Builder();
        private static final Set<String> DEPRECATED_PARAMS = new HashSet<String>(Arrays.asList("store", "meta", "index", "doc_values", "boost", "index_options", "similarity"));

        protected Builder(String name) {
            super(name);
        }

        public Builder init(FieldMapper initializer) {
            for (Parameter<?> param : this.getParameters()) {
                ((Parameter)param).init(initializer);
            }
            for (Mapper subField : initializer.multiFields) {
                this.multiFieldsBuilder.add(subField);
            }
            return this;
        }

        private void merge(FieldMapper in, Conflicts conflicts) {
            for (Parameter<?> param : this.getParameters()) {
                ((Parameter)param).merge(in, conflicts);
            }
            for (Mapper newSubField : in.multiFields) {
                this.multiFieldsBuilder.update(newSubField, ParametrizedFieldMapper.parentPath(newSubField.name()));
            }
            this.copyTo.reset(in.copyTo);
        }

        protected abstract List<Parameter<?>> getParameters();

        @Override
        public abstract ParametrizedFieldMapper build(Mapper.BuilderContext var1);

        protected String buildFullName(Mapper.BuilderContext context) {
            return context.path().pathAsText(this.name);
        }

        private void toXContent(XContentBuilder builder, boolean includeDefaults) throws IOException {
            for (Parameter<?> parameter : this.getParameters()) {
                ((Parameter)parameter).toXContent(builder, includeDefaults);
            }
        }

        public final void parse(String name, Mapper.TypeParser.ParserContext parserContext, Map<String, Object> fieldNode) {
            HashMap paramsMap = new HashMap();
            for (Parameter<?> param : this.getParameters()) {
                paramsMap.put(param.name, param);
            }
            String type = (String)fieldNode.remove("type");
            Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (Objects.equals("fields", propName)) {
                    TypeParsers.parseMultiField(this.multiFieldsBuilder::add, name, parserContext, propName, propNode);
                    iterator.remove();
                    continue;
                }
                if (Objects.equals("copy_to", propName)) {
                    TypeParsers.parseCopyFields(propNode).forEach(this.copyTo::add);
                    iterator.remove();
                    continue;
                }
                Parameter parameter = (Parameter)paramsMap.get(propName);
                if (parameter == null) {
                    if (Builder.isDeprecatedParameter(propName, parserContext.indexVersionCreated())) {
                        deprecationLogger.deprecatedAndMaybeLog(propName, "Parameter [{}] has no effect on type [{}] and will be removed in future", propName, type);
                        iterator.remove();
                        continue;
                    }
                    throw new MapperParsingException("unknown parameter [" + propName + "] on mapper [" + name + "] of type [" + type + "]");
                }
                if (propNode == null && !parameter.acceptsNull) {
                    throw new MapperParsingException("[" + propName + "] on mapper [" + name + "] of type [" + type + "] must not have a [null] value");
                }
                parameter.parse(name, propNode);
                iterator.remove();
            }
        }

        private static boolean isDeprecatedParameter(String propName, Version indexCreatedVersion) {
            return DEPRECATED_PARAMS.contains(propName);
        }
    }

    private static final class Conflicts {
        private final String mapperName;
        private final List<String> conflicts = new ArrayList<String>();

        Conflicts(String mapperName) {
            this.mapperName = mapperName;
        }

        void addConflict(String parameter, String existing, String toMerge) {
            this.conflicts.add("Cannot update parameter [" + parameter + "] from [" + existing + "] to [" + toMerge + "]");
        }

        void check() {
            if (this.conflicts.isEmpty()) {
                return;
            }
            String message = "Mapper for [" + this.mapperName + "] conflicts with existing mapper:\n\t" + String.join((CharSequence)"\n\t", this.conflicts);
            throw new IllegalArgumentException(message);
        }
    }

    public static final class Parameter<T> {
        public final String name;
        private final T defaultValue;
        private final BiFunction<String, Object, T> parser;
        private final Function<FieldMapper, T> initializer;
        private final boolean updateable;
        private boolean acceptsNull = false;
        private T value;

        public Parameter(String name, boolean updateable, T defaultValue, BiFunction<String, Object, T> parser, Function<FieldMapper, T> initializer) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.value = defaultValue;
            this.parser = parser;
            this.initializer = initializer;
            this.updateable = updateable;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public Parameter<T> acceptsNull() {
            this.acceptsNull = true;
            return this;
        }

        private void init(FieldMapper toInit) {
            this.value = this.initializer.apply(toInit);
        }

        private void parse(String field, Object in) {
            this.value = this.parser.apply(field, in);
        }

        private void merge(FieldMapper toMerge, Conflicts conflicts) {
            T value = this.initializer.apply(toMerge);
            if (!this.updateable && !Objects.equals(this.value, value)) {
                conflicts.addConflict(this.name, this.value.toString(), value.toString());
            } else {
                this.value = value;
            }
        }

        private void toXContent(XContentBuilder builder, boolean includeDefaults) throws IOException {
            if (includeDefaults || !Objects.equals(this.defaultValue, this.value)) {
                builder.field(this.name, this.value);
            }
        }

        public static Parameter<Boolean> boolParam(String name, boolean updateable, Function<FieldMapper, Boolean> initializer, boolean defaultValue) {
            return new Parameter<Boolean>(name, updateable, defaultValue, (n, o) -> XContentMapValues.nodeBooleanValue(o), initializer);
        }

        public static Parameter<Float> floatParam(String name, boolean updateable, Function<FieldMapper, Float> initializer, float defaultValue) {
            return new Parameter<Float>(name, updateable, Float.valueOf(defaultValue), (n, o) -> Float.valueOf(XContentMapValues.nodeFloatValue(o)), initializer);
        }

        public static Parameter<String> stringParam(String name, boolean updateable, Function<FieldMapper, String> initializer, String defaultValue) {
            return new Parameter<String>(name, updateable, defaultValue, (n, o) -> XContentMapValues.nodeStringValue(o), initializer);
        }
    }
}

