/*
 * Decompiled with CFR 0.152.
 */
package org.spin.report.util;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import org.adempiere.pipo.IDFinder;
import org.compiere.Adempiere;
import org.compiere.model.MClientInfo;
import org.compiere.model.MDiscountSchema;
import org.compiere.model.MTax;
import org.compiere.model.Query;
import org.compiere.model.X_C_Tax;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MADAttachmentReference;
import org.spin.util.AttachmentUtil;

public class TestScriptlet
extends JRDefaultScriptlet {
    public BigDecimal getDefaultTaxRate(int taxCategoryId) {
        Optional<MTax> optionalTax = Arrays.asList(MTax.getAll((Properties)Env.getCtx())).stream().filter(tax -> {
            if (!tax.isActive()) {
                return false;
            }
            if (tax.getC_TaxCategory_ID() != taxCategoryId) {
                return false;
            }
            if (!Util.isEmpty((String)tax.getSOPOType()) && tax.getSOPOType().equals("P")) {
                return false;
            }
            if (!Util.isEmpty((String)tax.getSOPOType()) && tax.getSOPOType().equals("S")) {
                return true;
            }
            if (!Util.isEmpty((String)tax.getSOPOType()) && tax.getSOPOType().equals("B")) {
                return true;
            }
            return tax.isSalesTax();
        }).sorted(Comparator.comparing(X_C_Tax::getValidFrom).reversed()).findFirst();
        if (optionalTax.isPresent()) {
            return optionalTax.get().getRate();
        }
        return Env.ZERO;
    }

    public BigDecimal getPriceWithDiscount(BigDecimal basePrice, BigDecimal discount, int precision) {
        basePrice = Optional.ofNullable(basePrice).orElse(Env.ZERO);
        discount = Optional.ofNullable(discount).orElse(Env.ZERO);
        BigDecimal multiplier = Env.ONE.subtract(discount.divide(Env.ONEHUNDRED, MathContext.DECIMAL128));
        BigDecimal finalPrice = basePrice.multiply(multiplier);
        finalPrice = finalPrice.setScale(precision, 4);
        return finalPrice;
    }

    public BigDecimal getDiscountFromPrice(BigDecimal basePrice, BigDecimal finalPrice) {
        finalPrice = Optional.ofNullable(finalPrice).orElse(Env.ZERO);
        basePrice = Optional.ofNullable(basePrice).orElse(Env.ZERO);
        BigDecimal discount = Env.ZERO;
        if (basePrice.compareTo(Env.ZERO) != 0) {
            discount = basePrice.subtract(finalPrice);
            discount = discount.divide(basePrice, MathContext.DECIMAL128);
            discount = discount.multiply(Env.ONEHUNDRED);
        }
        if (discount.scale() > 2) {
            discount = discount.setScale(2, 4);
        }
        return discount;
    }

    public BigDecimal calculatePriceWithDiscount(int discountSchemaId, int productId, int productCategoryId, BigDecimal price, BigDecimal quantity, BigDecimal businessPartnerFlatDiscount) {
        if (discountSchemaId <= 0) {
            return Env.ZERO;
        }
        MDiscountSchema discountSchema = MDiscountSchema.get((Properties)Env.getCtx(), (int)discountSchemaId);
        if (discountSchema == null || discountSchema.getM_DiscountSchema_ID() <= 0) {
            return Env.ZERO;
        }
        BigDecimal discountAmount = discountSchema.calculateDiscount(quantity, price, productId, productCategoryId, businessPartnerFlatDiscount);
        return discountAmount;
    }

    public String calculatePriceWithDiscountTest(Object discountSchemaId, Object productId, Object productCategoryId, Object price, Object quantity, Object businessPartnerFlatDiscount) {
        return "discountSchemaId: " + discountSchemaId.getClass() + " - productId: " + productId.getClass() + " - productCategoryId: " + productCategoryId.getClass() + " - price: " + price.getClass() + " - quantity: " + quantity.getClass() + " - businessPartnerFlatDiscount: " + businessPartnerFlatDiscount.getClass();
    }

    public String getDiscountName(int discountSchemaId) {
        if (discountSchemaId <= 0) {
            return null;
        }
        MDiscountSchema discountSchema = MDiscountSchema.get((Properties)Env.getCtx(), (int)discountSchemaId);
        if (discountSchema != null && discountSchema.getM_DiscountSchema_ID() > 0) {
            return discountSchema.getName();
        }
        return null;
    }

    private byte[] convertFile(File file) {
        try {
            FileInputStream fileImputStream = new FileInputStream(file);
            byte[] arr = new byte[(int)file.length()];
            fileImputStream.read(arr);
            fileImputStream.close();
            return arr;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getCompleteFileName(String fileName) {
        return System.getProperty("java.io.tmpdir") + File.separator + fileName;
    }

    private String getCompleteFileNameWithCompression(String fileName, float compressionPercentage, String preffix) {
        String extension = fileName.substring(fileName.lastIndexOf("."));
        String newName = fileName.replaceAll(extension, "") + preffix + String.valueOf(compressionPercentage).replace(".", "") + extension;
        return this.getCompleteFileName(newName);
    }

    public byte[] getResourceFromName(int clientId, String resourceName) throws Exception {
        if (!Util.isEmpty((String)resourceName)) {
            if (!AttachmentUtil.getInstance().isValidForClient(clientId)) {
                return null;
            }
            File file = new File(this.getCompleteFileName(resourceName));
            if (file.exists() && file.isFile()) {
                return this.convertFile(file);
            }
            MClientInfo clientInfo = MClientInfo.get((Properties)Env.getCtx(), (int)clientId);
            MADAttachmentReference reference = (MADAttachmentReference)new Query(Env.getCtx(), "AD_AttachmentReference", "(UUID || '-' || FileName) = ? AND FileHandler_ID = ?", null).setOrderBy("AD_Attachment_ID DESC").setParameters(new Object[]{resourceName, clientInfo.getFileHandler_ID()}).first();
            if (reference == null || reference.getAD_AttachmentReference_ID() <= 0) {
                return null;
            }
            String resourceUuid = reference.getUUID();
            if (Util.isEmpty((String)resourceUuid)) {
                return null;
            }
            int resourceId = IDFinder.getIdFromUUID((Properties)Env.getCtx(), (String)"AD_AttachmentReference", (String)resourceUuid, (int)clientId, null);
            if (resourceId <= 0) {
                return null;
            }
            byte[] resource = AttachmentUtil.getInstance().withClientId(clientId).withAttachmentReferenceId(resourceId).getAttachment();
            if (resource != null) {
                Path path = Paths.get(this.getCompleteFileName(resourceName), new String[0]);
                Files.write(path, resource, new OpenOption[0]);
                return resource;
            }
        }
        return null;
    }

    public byte[] getImageFromName(int clientId, String resourceName, float compressionPercentage) throws Exception {
        File file = new File(this.getCompleteFileNameWithCompression(resourceName, compressionPercentage, "_compress_"));
        if (file.exists() && file.isFile()) {
            return this.convertFile(file);
        }
        byte[] resource = this.getResourceFromName(clientId, resourceName);
        if (resource == null) {
            return resource;
        }
        return this.compressImage(resource, resourceName, compressionPercentage);
    }

    public byte[] getResizedImageFromName(int clientId, String resourceName, float compressionPercentage) throws Exception {
        File file = new File(this.getCompleteFileNameWithCompression(resourceName, compressionPercentage, "_resized_"));
        if (file.exists() && file.isFile()) {
            return this.convertFile(file);
        }
        byte[] resource = this.getResourceFromName(clientId, resourceName);
        if (resource == null) {
            return resource;
        }
        return this.resizeImage(resource, resourceName, compressionPercentage);
    }

    public byte[] compressImage(byte[] image, String imageName, float compressionPercentage) {
        if (Util.isEmpty((String)imageName)) {
            return null;
        }
        if (imageName.lastIndexOf(".") < 0) {
            return null;
        }
        String extension = imageName.substring(imageName.lastIndexOf("."));
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(image);
            BufferedImage imageToProcess = ImageIO.read(input);
            FileOutputStream os = new FileOutputStream(this.getCompleteFileNameWithCompression(imageName, compressionPercentage, "_compress_"));
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(extension.replace(".", ""));
            ImageWriter writer = writers.next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(os);
            writer.setOutput(ios);
            ImageWriteParam param = writer.getDefaultWriteParam();
            float compressionQuality = compressionPercentage / 100.0f;
            param.setCompressionMode(2);
            param.setCompressionQuality(compressionQuality);
            writer.write(null, new IIOImage(imageToProcess, null, null), param);
            ((OutputStream)os).close();
            ios.close();
            writer.dispose();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return image;
    }

    public byte[] resizeImage(byte[] image, String imageName, float compressionPercentage) {
        if (imageName.lastIndexOf(".") < 0) {
            return null;
        }
        String extension = imageName.substring(imageName.lastIndexOf("."));
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(image);
            BufferedImage imageToProcess = ImageIO.read(input);
            int targetHeight = (int)((float)imageToProcess.getHeight() * compressionPercentage / 100.0f);
            int targetWidth = (int)((float)imageToProcess.getWidth() * compressionPercentage / 100.0f);
            BufferedImage resizedImage = new BufferedImage(targetWidth, targetHeight, 1);
            Graphics2D graphics2D = resizedImage.createGraphics();
            graphics2D.drawImage(imageToProcess, 0, 0, targetWidth, targetHeight, null);
            graphics2D.dispose();
            File outputImage = new File(this.getCompleteFileNameWithCompression(imageName, compressionPercentage, "_resized_"));
            ImageIO.write((RenderedImage)resizedImage, extension.replace(".", ""), outputImage);
            return this.convertFile(outputImage);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getImageFromImageId(int clientId, int imageId, float compressionPercentage) throws Exception {
        if (imageId > 0) {
            if (!AttachmentUtil.getInstance().isValidForClient(clientId)) {
                return null;
            }
            AttachmentUtil attachmentInstance = AttachmentUtil.getInstance().withClientId(clientId).withImageId(imageId);
            byte[] image = attachmentInstance.getAttachment();
            String imageName = attachmentInstance.getFileName();
            return this.compressImage(image, imageName, compressionPercentage);
        }
        return null;
    }

    public byte[] getResizedImageFromImageId(int clientId, int imageId, float compressionPercentage) throws Exception {
        if (imageId > 0) {
            if (!AttachmentUtil.getInstance().isValidForClient(clientId)) {
                return null;
            }
            AttachmentUtil attachmentInstance = AttachmentUtil.getInstance().withClientId(clientId).withImageId(imageId);
            byte[] image = attachmentInstance.getAttachment();
            String imageName = attachmentInstance.getFileName();
            return this.resizeImage(image, imageName, compressionPercentage);
        }
        return null;
    }

    public static void main(String[] arg) {
        TestScriptlet REPORT_SCRIPLET = new TestScriptlet();
        try {
            Adempiere.startup((boolean)true);
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)1000000);
            System.out.println(REPORT_SCRIPLET.calculatePriceWithDiscount(1000013, 1000267, 1000016, new BigDecimal(37.5), Env.ZERO, Env.ZERO));
            System.out.println(REPORT_SCRIPLET.calculatePriceWithDiscount(1000012, 1000267, 1000016, new BigDecimal(192.0), new BigDecimal(1), new BigDecimal(0)));
            System.out.println(REPORT_SCRIPLET.calculatePriceWithDiscount(1000004, 1000267, 1000016, new BigDecimal(192.0), new BigDecimal(1), new BigDecimal(0)));
            System.out.println(REPORT_SCRIPLET.calculatePriceWithDiscount(1000011, 1000267, 1000016, new BigDecimal(192.0), new BigDecimal(1), new BigDecimal(0)));
            System.out.println(REPORT_SCRIPLET.calculatePriceWithDiscountTest(0.333, "Epale", new BigDecimal(1), System.currentTimeMillis(), new Timestamp(System.currentTimeMillis()), Float.valueOf(33.0f)));
            REPORT_SCRIPLET.getImageFromName(1000000, "2c770f39-0d6f-4aec-80fc-5b47c3fb31b8-FLOTANTE-DE-5-METROS-9A136-QWM15-5-1.jpg", 20.0f);
            REPORT_SCRIPLET.getResizedImageFromName(1000000, "2c770f39-0d6f-4aec-80fc-5b47c3fb31b8-FLOTANTE-DE-5-METROS-9A136-QWM15-5-1.jpg", 20.0f);
            System.err.println("Epale: " + ((Object)((Object)REPORT_SCRIPLET)).getClass());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

