/*
 * Decompiled with CFR 0.152.
 */
package org.spin.report.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class ConversionUtil {
    private static ConversionUtil conversionEngine = null;
    private static CCache<String, BigDecimal> conversionValues = new CCache("ConversionRate", 30);

    private ConversionUtil() {
    }

    public static synchronized ConversionUtil get() {
        if (conversionEngine == null) {
            conversionEngine = new ConversionUtil();
        }
        return conversionEngine;
    }

    public BigDecimal getConversionRate(Properties context, int conversionTypeId, int fromCurrencyId, int toCurrencyId, Timestamp conversionDate, int clientId, int organizationId) {
        if (conversionDate == null) {
            return Env.ZERO;
        }
        if (fromCurrencyId == toCurrencyId) {
            return Env.ONE;
        }
        String key = conversionTypeId + "|" + fromCurrencyId + "|" + toCurrencyId + "|" + TimeUtil.getDay((Timestamp)conversionDate).getTime();
        BigDecimal conversionRate = (BigDecimal)conversionValues.get((Object)key);
        if (conversionRate != null) {
            return conversionRate;
        }
        conversionRate = Optional.ofNullable(MConversionRate.getRate((int)fromCurrencyId, (int)toCurrencyId, (Timestamp)conversionDate, (int)conversionTypeId, (int)clientId, (int)organizationId)).orElse(Env.ZERO);
        conversionValues.put((Object)key, (Object)conversionRate);
        return conversionRate;
    }

    public BigDecimal getConvertedAmount(Properties context, int conversionTypeId, int fromCurrencyId, int toCurrencyId, Timestamp conversionDate, int clientId, int organizationId, BigDecimal amount) {
        MCurrency currencyTo = MCurrency.get((Properties)context, (int)toCurrencyId);
        return Optional.ofNullable(amount).orElse(Env.ZERO).multiply(this.getConversionRate(context, conversionTypeId, fromCurrencyId, toCurrencyId, conversionDate, clientId, organizationId)).setScale(currencyTo.getStdPrecision(), 4);
    }
}

