/*
 * Decompiled with CFR 0.152.
 */
package org.spin.report;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.report.BankBalanceToDateAbstract;

public class BankBalanceToDate
extends BankBalanceToDateAbstract {
    private String sql = null;
    private String sqlInsert = null;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getDateTrx() == null) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        }
        if (this.getDateTrxTo() == null) {
            this.setDateTrxTo(new Timestamp(System.currentTimeMillis()));
        }
        String beginningBalanceMessage = Msg.getMsg((Properties)this.getCtx(), (String)"BeginningBalance");
        this.sql = "SELECT p.SeqNo, p.C_BankAccount_ID, p.IsReceipt, p.DocStatus, p.StatementDate, p.DateTrx, p.PayAmt, p.DocumentNo, p.UnReconciledDebit, p.UnReconciledCredit, (p.UnReconciledCredit - p.UnReconciledDebit) UnReconciledBalance, p.ReconciledDebit, p.ReconciledCredit, (p.ReconciledCredit - p.ReconciledDebit) ReconciledBalance, p.C_BankStatement_ID, p.C_BPartner_ID, COALESCE(ba.C_Bank_ID, " + this.getBankId() + ") C_Bank_ID, p.Description, p.LineDescription FROM ( SELECT 10 AS SeqNo, p.C_BankAccount_ID, NULL AS IsReceipt, NULL AS DocStatus, NULL StatementDate, SUM(p.PayAmt) PayAmt, '' DocumentNo, ? DateTrx, '* " + beginningBalanceMessage + " *' Description, '* " + beginningBalanceMessage + " *' LineDescription, SUM(CASE WHEN p.StatementDate IS NULL OR IsReconciled='N' THEN CASE WHEN IsReceipt = 'N' THEN ABS(p.PayAmt) ELSE 0 END ELSE 0 END) UnReconciledDebit, SUM(CASE WHEN p.StatementDate IS NULL OR IsReconciled='N' THEN CASE WHEN IsReceipt = 'Y' THEN ABS(p.PayAmt) ELSE 0 END ELSE 0 END) UnReconciledCredit, SUM(CASE WHEN p.StatementDate IS NOT NULL AND IsReconciled = 'Y' THEN CASE WHEN IsReceipt = 'N' THEN ABS(p.PayAmt) ELSE 0 END ELSE 0 END) ReconciledDebit, SUM(CASE WHEN p.StatementDate IS NOT NULL AND IsReconciled = 'Y' THEN CASE WHEN IsReceipt = 'Y' THEN ABS(p.PayAmt) ELSE 0 END ELSE 0 END) ReconciledCredit, NULL C_BankStatement_ID, NULL C_BPartner_ID, NULL C_Payment_ID FROM (\tSELECT \t\tCOALESCE(bs.StatementDate, vp.DateTrx) StatementDate, \t\tp.PayAmt, \t\tCASE WHEN SIGN(p.PayAmt) > 0 THEN 'Y' ELSE 'N' END IsReceipt, \t\tp.C_BankAccount_ID, \t\tp.DateTrx, \t\tCASE WHEN COALESCE(bs.StatementDate, vp.DateTrx) < ? THEN 'Y' ELSE 'N' END AS IsReconciled \tFROM \tRV_Payment p \tLEFT JOIN C_BankStatementLine bsl ON(bsl.C_Payment_ID = p.C_Payment_ID) \tLEFT JOIN C_BankStatement bs ON(bs.C_BankStatement_ID = bsl.C_BankStatement_ID) \tLEFT JOIN C_Payment vp ON(vp.Reversal_ID = p.C_Payment_ID AND p.DocStatus IN ('RE','VO') AND vp.DocStatus IN ('RE','VO')) \tWHERE p.Processed = 'Y'  AND p.AD_Client_ID = " + this.getAD_Client_ID() + " )  AS p WHERE p.DateTrx < ? GROUP BY p.C_BankAccount_ID UNION ALL SELECT 20 AS SeqNo, p.C_BankAccount_ID, p.IsReceipt, p.DocStatus, p.StatementDate, ABS(p.PayAmt) AS PayAmt, p.DocumentNo, p.DateTrx, p.Description, p.LineDescription, CASE WHEN p.StatementDate IS NULL OR IsReconciled='N' THEN CASE WHEN IsReceipt = 'N' THEN ABS(p.PayAmt) ELSE 0 END ELSE 0 END UnReconciledDebit, CASE WHEN p.StatementDate IS NULL OR IsReconciled='N' THEN CASE WHEN IsReceipt = 'Y' THEN ABS(p.PayAmt) ELSE 0 END ELSE 0 END UnReconciledCredit, CASE WHEN p.StatementDate IS NOT NULL AND IsReconciled = 'Y' THEN CASE WHEN IsReceipt = 'N' THEN ABS(p.PayAmt) ELSE 0 END ELSE 0 END ReconciledDebit, CASE WHEN p.StatementDate IS NOT NULL AND IsReconciled = 'Y' THEN CASE WHEN IsReceipt = 'Y' THEN ABS(p.PayAmt) ELSE 0 END ELSE 0 END ReconciledCredit, p.C_BankStatement_ID, p.C_BPartner_ID, p.C_Payment_ID FROM (\tSELECT \t\tCOALESCE(bs.StatementDate, vp.DateTrx) StatementDate, \t\tp.PayAmt,\t\tCASE WHEN SIGN(p.PayAmt) > 0 THEN 'Y' ELSE 'N' END IsReceipt, \t\tp.C_BankAccount_ID, \t\tp.DateTrx, \t\tCASE WHEN COALESCE(bs.StatementDate, vp.DateTrx) BETWEEN ? AND ? THEN 'Y' ELSE 'N' END AS IsReconciled, \t\tp.DocStatus, p.DocumentNo, bsl.C_BankStatement_ID, p.C_BPartner_ID, p.C_Payment_ID, (bp.Name || COALESCE(' ' || bp.Name2, '')) AS Description, bsl.Description AS LineDescription \tFROM \tRV_Payment p  INNER JOIN C_BPartner bp ON(bp.C_BPartner_ID = p.C_BPartner_ID) \tLEFT JOIN C_BankStatementLine bsl ON(bsl.C_Payment_ID = p.C_Payment_ID) \tLEFT JOIN C_BankStatement bs ON(bs.C_BankStatement_ID = bsl.C_BankStatement_ID) \tLEFT JOIN C_Payment vp ON(vp.Reversal_ID = p.C_Payment_ID AND p.DocStatus IN ('RE','VO') AND vp.DocStatus IN ('RE','VO')) \tWHERE p.Processed = 'Y'  AND p.AD_Client_ID = " + this.getAD_Client_ID() + " )  AS p WHERE p.DateTrx BETWEEN ? AND ? ) p INNER JOIN C_BankAccount ba ON(ba.C_BankAccount_ID = p.C_BankAccount_ID) WHERE ba.C_Bank_ID = " + this.getBankId() + " " + (this.getBankAccountId() != 0 ? "AND p.C_BankAccount_ID = " + this.getBankAccountId() + " " : "") + "ORDER BY SeqNo, DateTrx, StatementDate";
        this.sqlInsert = "INSERT INTO T_BankBalance(AD_Client_ID, AD_Org_ID, AD_PInstance_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, C_Bank_ID, C_BankAccount_ID, C_BPartner_ID, Description, LineDescription, DocStatus, DocumentNo, IsReceipt, PayAmt, ReconciledDebit, ReconciledCredit, ReconciledBalance, SeqNo, StatementDate, DateTrx, UnReconciledDebit, UnReconciledCredit, UnReconciledBalance, AvailableAmt, BalanceAmount) VALUES(" + this.getAD_Client_ID() + " , " + Env.getAD_Org_ID((Properties)this.getCtx()) + ", " + this.getAD_PInstance_ID() + ", 'Y', getDate(), " + this.getAD_User_ID() + ", getDate(), " + this.getAD_User_ID() + ", ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    protected String doIt() throws Exception {
        this.log.fine("SQL = " + this.sql.toString());
        CPreparedStatement pstmtSelect = DB.prepareStatement((String)this.sql, (String)this.get_TrxName());
        int i = 1;
        pstmtSelect.setTimestamp(i++, this.getDateTrx());
        pstmtSelect.setTimestamp(i++, this.getDateTrx());
        pstmtSelect.setTimestamp(i++, this.getDateTrx());
        pstmtSelect.setTimestamp(i++, this.getDateTrx());
        pstmtSelect.setTimestamp(i++, this.getDateTrxTo());
        pstmtSelect.setTimestamp(i++, this.getDateTrx());
        pstmtSelect.setTimestamp(i++, this.getDateTrxTo());
        ResultSet resultSet = pstmtSelect.executeQuery();
        BigDecimal reconciledSummaryBalance = Env.ZERO;
        BigDecimal unReconciledSummaryBalance = Env.ZERO;
        AtomicInteger counter = new AtomicInteger(0);
        while (resultSet.next()) {
            int sequece = resultSet.getInt("SeqNo");
            BigDecimal reconciledBalance = resultSet.getBigDecimal("ReconciledBalance");
            BigDecimal unReconciledBalance = resultSet.getBigDecimal("UnReconciledBalance");
            BigDecimal reconciledDebit = resultSet.getBigDecimal("ReconciledDebit");
            BigDecimal reconciledCredit = resultSet.getBigDecimal("ReconciledCredit");
            BigDecimal unReconciledDebit = resultSet.getBigDecimal("UnReconciledDebit");
            BigDecimal unReconciledCredit = resultSet.getBigDecimal("UnReconciledCredit");
            if (sequece == 10) {
                reconciledSummaryBalance = reconciledBalance;
                unReconciledSummaryBalance = unReconciledBalance;
            } else {
                reconciledSummaryBalance = reconciledSummaryBalance.add(reconciledCredit.subtract(reconciledDebit));
                unReconciledSummaryBalance = unReconciledSummaryBalance.add(unReconciledCredit.subtract(unReconciledDebit));
            }
            BigDecimal availableAmount = reconciledSummaryBalance.add(unReconciledSummaryBalance);
            BigDecimal balanceAmount = reconciledBalance.add(unReconciledBalance);
            DB.executeUpdateEx((String)this.sqlInsert, (Object[])new Object[]{resultSet.getInt("C_Bank_ID"), resultSet.getInt("C_BankAccount_ID"), resultSet.getInt("C_BPartner_ID"), resultSet.getString("Description"), resultSet.getString("LineDescription"), resultSet.getString("DocStatus"), resultSet.getString("DocumentNo"), resultSet.getString("IsReceipt"), resultSet.getBigDecimal("PayAmt"), reconciledDebit, reconciledCredit, reconciledSummaryBalance, resultSet.getInt("SeqNo") + counter.addAndGet(1), resultSet.getTimestamp("StatementDate"), resultSet.getTimestamp("DateTrx"), unReconciledDebit, unReconciledCredit, unReconciledSummaryBalance, availableAmount, balanceAmount}, (String)this.get_TrxName());
            if (sequece != 10) continue;
            reconciledDebit = Env.ZERO;
            reconciledCredit = Env.ZERO;
            unReconciledDebit = Env.ZERO;
            unReconciledCredit = Env.ZERO;
        }
        return "Ok";
    }
}

