/*
 * Decompiled with CFR 0.152.
 */
package org.spin.report;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MDocType;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.report.BPartnerAccountStatementAbstract;
import org.spin.report.util.ConversionUtil;

public class BPartnerAccountStatement
extends BPartnerAccountStatementAbstract {
    private String sql = null;
    private String sqlInsert = null;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getDateTrx() == null) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        }
        if (this.getDateTrxTo() == null) {
            this.setDateTrxTo(new Timestamp(System.currentTimeMillis()));
        }
        if (this.getCurrencyId() <= 0) {
            this.setCurrencyId(Env.getContextAsInt((Properties)this.getCtx(), (String)"#C_Currency_ID"));
        }
        String beginningBalanceMessage = Msg.getMsg((Properties)this.getCtx(), (String)"BeginningBalance");
        StringBuffer additionalWhere = new StringBuffer(" WHERE asr.AD_Client_ID = ").append(this.getAD_Client_ID());
        if (this.getBPartnerId() != 0) {
            additionalWhere.append(" AND asr.C_BPartner_ID = ").append(this.getBPartnerId());
        }
        if (this.getBPAccountTypeId() != 0) {
            additionalWhere.append(" AND EXISTS(SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = asr.C_BPartner_ID AND bp.C_BP_AccountType_ID = ").append(this.getBPAccountTypeId()).append(")");
        }
        if (this.getBPIndustryTypeId() != 0) {
            additionalWhere.append(" AND EXISTS(SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = asr.C_BPartner_ID AND bp.C_BP_IndustryType_ID = ").append(this.getBPIndustryTypeId()).append(")");
        }
        if (this.getBPSalesGroupId() != 0) {
            additionalWhere.append(" AND EXISTS(SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = asr.C_BPartner_ID AND bp.C_BP_SalesGroup_ID = ").append(this.getBPSalesGroupId()).append(")");
        }
        if (this.getBPSegmentId() != 0) {
            additionalWhere.append(" AND EXISTS(SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = asr.C_BPartner_ID AND bp.C_BP_Segment_ID = ").append(this.getBPSegmentId()).append(")");
        }
        if (this.getBPGroupId() != 0) {
            additionalWhere.append(" AND EXISTS(SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = asr.C_BPartner_ID AND bp.C_BP_Group_ID = ").append(this.getBPGroupId()).append(")");
        }
        if (this.getOrgId() > 0) {
            additionalWhere.append(" AND asr.AD_Org_ID = ").append(this.getOrgId());
        }
        if (this.getSalesRepId() != 0) {
            additionalWhere.append(" AND EXISTS(SELECT 1 FROM C_BPartner bp LEFT JOIN C_BPartner_Location bpl ON(bpl.C_BPartner_ID = bp.C_BPartner_ID) LEFT JOIN C_SalesRegion bps ON(bps.C_SalesRegion_ID = bpl.C_SalesRegion_ID) WHERE bp.C_BPartner_ID = asr.C_BPartner_ID AND (bp.SalesRep_ID = " + this.getSalesRepId() + " OR bps.SalesRep_ID = " + this.getSalesRepId() + "))");
        }
        if (this.getSalesRegionId() != 0) {
            additionalWhere.append(" AND EXISTS(SELECT 1 FROM C_BPartner bp LEFT JOIN C_BPartner_Location bpl ON(bpl.C_BPartner_ID = bp.C_BPartner_ID) WHERE bp.C_BPartner_ID = asr.C_BPartner_ID AND bpl.C_SalesRegion_ID = " + this.getSalesRegionId() + ")");
        }
        if (this.getOrgId() > 0) {
            additionalWhere.append(" AND asr.AD_Org_ID IN(0, ").append(this.getOrgId()).append(")");
        }
        if (!this.isShowAllocations()) {
            this.sql = "SELECT asr.AD_Org_ID, asr.SeqNo, asr.Multiplier, asr.C_Order_ID, asr.C_Invoice_ID, asr.C_Payment_ID, asr.C_AllocationHdr_ID, asr.C_AllocationLine_ID, asr.DocumentNo, asr.DateTrx, asr.DateAcct, asr.C_BPartner_ID, asr.AmtSource, asr.AmtSourceDr, asr.AmtSourceCr, (asr.AmtSourceDr - asr.AmtSourceCr) AS Balance,  asr.IsAllocated, asr.Description, asr.C_DocType_ID, asr.C_ConversionType_ID, asr.C_Currency_ID FROM (    SELECT bb.AD_Client_ID, bb.SeqNo, 0 AS AD_Org_ID, 0 AS Multiplier, 0 AS C_Payment_ID, 0 AS C_Invoice_ID, 0 AS C_Order_ID, NULL AS DocumentNo, getDate() AS DateTrx, getDate() AS DateAcct, bb.C_BPartner_ID, SUM(bb.AmtSource) AS AmtSource, SUM(bb.AmtSourceDr) AS AmtSourceDr, SUM(bb.AmtSourceCr) AS AmtSourceCr, 'N' AS IsAllocated, 0 AS C_AllocationHdr_ID, 0 AS C_AllocationLine_ID, '* " + beginningBalanceMessage + " *' AS Description, 0 AS C_DocType_ID, null AS C_ConversionType_ID, " + this.getCurrencyId() + " AS C_Currency_ID    FROM (        SELECT i.AD_Client_ID, 10 SeqNo, i.C_BPartner_ID, \t\t\tSUM(currencyConvert(i.GrandTotal, i.C_Currency_ID, " + this.getCurrencyId() + ", i.DateAcct, i.C_ConversionType_ID, i.AD_Client_ID, i.AD_Org_ID)) AS AmtSource, \t\t\tSUM(CASE WHEN (i.Multiplier = 1 AND i.IsSOTrx = 'Y') OR (i.Multiplier = -1 AND i.IsSOTrx = 'N') THEN currencyConvert(i.GrandTotal, i.C_Currency_ID, " + this.getCurrencyId() + ", i.DateAcct, i.C_ConversionType_ID, i.AD_Client_ID, i.AD_Org_ID) * i.Multiplier ELSE 0 END) AS AmtSourceDr, \t\t\tSUM(CASE WHEN (i.Multiplier = -1 AND i.IsSOTrx = 'Y') OR (i.Multiplier = 1 AND i.IsSOTrx = 'N') THEN currencyConvert(i.GrandTotal, i.C_Currency_ID, " + this.getCurrencyId() + ", i.DateAcct, i.C_ConversionType_ID, i.AD_Client_ID, i.AD_Org_ID) * i.Multiplier ELSE 0 END) AS AmtSourceCr        FROM RV_C_Invoice i        WHERE i.DocStatus IN('CO', 'CL')         AND i.DateInvoiced < ?         AND (i.AD_Org_ID = " + this.getOrgId() + " OR " + this.getOrgId() + " = 0)         GROUP BY i.AD_Client_ID, i.C_BPartner_ID        UNION        SELECT p.AD_Client_ID, 10 SeqNo, p.C_BPartner_ID, \t\t\tSUM(currencyConvert(p.PayAmt, p.C_Currency_ID, " + this.getCurrencyId() + ", p.DateAcct, p.C_ConversionType_ID, p.AD_Client_ID, p.AD_Org_ID)) AS AmtSource, \t\t\tSUM(CASE WHEN p.IsReceipt = 'N' THEN currencyConvert(p.PayAmt, p.C_Currency_ID, " + this.getCurrencyId() + ", p.DateAcct, p.C_ConversionType_ID, p.AD_Client_ID, p.AD_Org_ID) * p.MultiplierAP ELSE 0 END) AS AmtSourceDr, \t\t\tSUM(CASE WHEN p.IsReceipt = 'Y' THEN currencyConvert(p.PayAmt, p.C_Currency_ID, " + this.getCurrencyId() + ", p.DateAcct, p.C_ConversionType_ID, p.AD_Client_ID, p.AD_Org_ID) * p.MultiplierAP ELSE 0 END) AS AmtSourceCr        FROM C_Payment_V p        WHERE p.DocStatus IN('CO', 'CL')         AND p.DateTrx < ?         AND (p.AD_Org_ID = " + this.getOrgId() + " OR " + this.getOrgId() + " = 0)         GROUP BY p.AD_Client_ID, p.C_BPartner_ID        UNION    \t SELECT al.AD_Client_ID, 10 SeqNo, al.C_BPartner_ID, \t\t\tSUM(currencyConvert(al.Amount, a.C_Currency_ID, " + this.getCurrencyId() + ", a.DateAcct, null, a.AD_Client_ID, a.AD_Org_ID)) AS AmtSource, \t\t\t0 AS AmtSourceDr, \t\t\tSUM(currencyConvert(al.Amount, a.C_Currency_ID, " + this.getCurrencyId() + ", a.DateAcct, null, a.AD_Client_ID, a.AD_Org_ID)) AS AmtSourceCr    \t FROM C_AllocationLine al \t\t INNER JOIN C_AllocationHdr a ON(a.C_AllocationHdr_ID = al.C_AllocationHdr_ID)\t \t WHERE al.C_Charge_ID IS NOT NULL    \t AND EXISTS(SELECT 1 FROM C_AllocationHdr a WHERE a.C_AllocationHdr_ID = al.C_AllocationHdr_ID AND a.DocStatus IN('CO', 'CL') AND a.DateTrx < ?)        AND (al.AD_Org_ID = " + this.getOrgId() + " OR " + this.getOrgId() + " = 0)         GROUP BY al.AD_Client_ID, al.C_BPartner_ID        UNION    \t SELECT m.AD_Client_ID, 10 SeqNo, m.C_BPartner_ID, \t\t\tSUM(currencyConvert(COALESCE(m.Amount, m.Qty), p.C_Currency_ID, " + this.getCurrencyId() + ", p.DateAcct, p.C_ConversionType_ID, p.AD_Client_ID, p.AD_Org_ID)) AS AmtSource, \t\t\t0 AS AmtSourceDr, \t\t\tSUM(currencyConvert(COALESCE(m.Amount, m.Qty), p.C_Currency_ID, " + this.getCurrencyId() + ", p.DateAcct, p.C_ConversionType_ID, p.AD_Client_ID, p.AD_Org_ID)) AS AmtSourceCr    \t FROM HR_Movement m \t\t INNER JOIN HR_Process p ON(p.HR_Process_ID = m.HR_Process_ID)\t \t WHERE p.DocStatus IN('CO', 'CL') AND p.DateAcct < ?        AND (p.AD_Org_ID = " + this.getOrgId() + " OR " + this.getOrgId() + " = 0) \t \t AND EXISTS(SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID = m.HR_Concept_ID AND c.IsPaid = 'Y')        GROUP BY m.AD_Client_ID, m.C_BPartner_ID    ) bb    GROUP BY bb.SeqNo, bb.AD_Client_ID, bb.C_BPartner_ID    UNION ALL    SELECT p.AD_Client_ID, 20 SeqNo, p.AD_Org_ID, 1, 0 AS C_Payment_ID, 0 AS C_Invoice_ID, 0 AS C_Order_ID, p.DocumentNo, p.DateAcct AS DateTrx, p.DateAcct, m.C_BPartner_ID, COALESCE(m.Amount, m.Qty) AS AmtSource, 0 AS AmtSourceDr, COALESCE(m.Amount, m.Qty) AS AmtSourceCr, 'N' AS IsAllocated, 0 AS C_AllocationHdr_ID, 0 AS C_AllocationLine_ID, p.Name AS Description, p.C_DocType_ID, p.C_ConversionType_ID, p.C_Currency_ID    FROM HR_Process p    INNER JOIN HR_Movement m ON(m.HR_Process_ID = p.HR_Process_ID)    WHERE p.DocStatus IN('CO', 'CL')     AND p.DateAcct BETWEEN ? AND ?     AND EXISTS(SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID = m.HR_Concept_ID AND c.IsPaid = 'Y')     UNION ALL    SELECT i.AD_Client_ID, 20 SeqNo, i.AD_Org_ID, i.Multiplier, 0 AS C_Payment_ID, i.C_Invoice_ID, i.C_Order_ID, i.DocumentNo, i.DateInvoiced AS DateTrx, i.DateAcct, i.C_BPartner_ID, i.GrandTotal AS AmtSource, CASE WHEN (i.Multiplier = 1 AND i.IsSOTrx = 'Y') OR (i.Multiplier = -1 AND i.IsSOTrx = 'N') THEN i.GrandTotal * i.Multiplier ELSE 0 END AS AmtSourceDr, CASE WHEN (i.Multiplier = -1 AND i.IsSOTrx = 'Y') OR (i.Multiplier = 1 AND i.IsSOTrx = 'N') THEN i.GrandTotal * i.Multiplier ELSE 0 END AS AmtSourceCr, 'N' AS IsAllocated, 0 AS C_AllocationHdr_ID, 0 AS C_AllocationLine_ID, i.Description, i.C_DocType_ID, i.C_ConversionType_ID, i.C_Currency_ID    FROM RV_C_Invoice i    WHERE i.DocStatus IN('CO', 'CL')     AND i.DateInvoiced BETWEEN ? AND ?     UNION ALL    SELECT p.AD_Client_ID, 20 SeqNo, p.AD_Org_ID, p.MultiplierAP AS Multiplier, p.C_Payment_ID, 0 AS C_Invoice_ID, p.C_Order_ID, p.DocumentNo, p.DateTrx, p.DateAcct, p.C_BPartner_ID, p.PayAmt AS AmtSource, CASE WHEN p.IsReceipt = 'N' THEN p.PayAmt * p.MultiplierAP ELSE 0 END AS AmtSourceDr, CASE WHEN p.IsReceipt = 'Y' THEN p.PayAmt * p.MultiplierAP ELSE 0 END AS AmtSourceCr, 'N' AS IsAllocated, 0 AS C_AllocationHdr_ID, 0 AS C_AllocationLine_ID, p.Description, p.C_DocType_ID, p.C_ConversionType_ID, p.C_Currency_ID    FROM C_Payment_V p    WHERE p.DocStatus IN('CO', 'CL')     AND p.DateTrx BETWEEN ? AND ?     UNION ALL    SELECT a.AD_Client_ID, 20 SeqNo, a.AD_Org_ID, -1 AS Multiplier, al.C_Payment_ID, al.C_Invoice_ID, al.C_Order_ID, a.DocumentNo, a.DateTrx, a.DateAcct, al.C_BPartner_ID, al.Amount AS AmtSource, 0 AS AmtSourceDr, al.Amount AS AmtSourceCr, 'N' AS IsAllocated, a.C_AllocationHdr_ID, al.C_AllocationLine_ID, a.Description, a.C_DocType_ID, null AS C_ConversionType_ID, a.C_Currency_ID    FROM C_AllocationHdr a    INNER JOIN C_AllocationLine al ON (al.C_AllocationHdr_ID = a.C_AllocationHdr_ID)\t WHERE a.DocStatus IN('CO', 'CL')\t AND al.C_Charge_ID IS NOT NULL    AND a.DateTrx BETWEEN ? AND ? ) AS asr " + additionalWhere + " ORDER BY asr.C_BPartner_ID, asr.SeqNo, asr.DateTrx";
        }
        this.sqlInsert = "INSERT INTO T_BPartnerAccountStatement(AD_Client_ID, AD_Org_ID, AD_PInstance_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, IsShowAllocations, Multiplier, C_Order_ID, C_Invoice_ID, C_Payment_ID, C_AllocationHdr_ID, C_AllocationLine_ID, DocumentNo, DateTrx, DateAcct, C_BPartner_ID, AmtSource, AmtSourceDr, AmtSourceCr, Balance, IsAllocated, SeqNo, Description, BalanceAmount, C_Currency_ID) VALUES(" + this.getAD_Client_ID() + " , " + this.getOrgId() + ", " + this.getAD_PInstance_ID() + ", 'Y', getDate(), " + this.getAD_User_ID() + ", getDate(), " + this.getAD_User_ID() + ", " + (this.isShowAllocations() ? "'Y'" : "'N'") + ", ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    protected String doIt() throws Exception {
        CPreparedStatement pstmtSelect = null;
        ResultSet resultSet = null;
        try {
            String amountCrColumnName;
            this.log.fine("SQL = " + this.sql.toString());
            pstmtSelect = DB.prepareStatement((String)this.sql, (String)this.get_TrxName());
            int i = 1;
            pstmtSelect.setTimestamp(i++, this.getDateTrx());
            pstmtSelect.setTimestamp(i++, this.getDateTrx());
            pstmtSelect.setTimestamp(i++, this.getDateTrx());
            pstmtSelect.setTimestamp(i++, this.getDateTrx());
            pstmtSelect.setTimestamp(i++, this.getDateTrx());
            pstmtSelect.setTimestamp(i++, this.getDateTrxTo());
            pstmtSelect.setTimestamp(i++, this.getDateTrx());
            pstmtSelect.setTimestamp(i++, this.getDateTrxTo());
            pstmtSelect.setTimestamp(i++, this.getDateTrx());
            pstmtSelect.setTimestamp(i++, this.getDateTrxTo());
            pstmtSelect.setTimestamp(i++, this.getDateTrx());
            pstmtSelect.setTimestamp(i++, this.getDateTrxTo());
            resultSet = pstmtSelect.executeQuery();
            BigDecimal balanceAmount = Env.ZERO;
            AtomicInteger counter = new AtomicInteger(0);
            int currentBusinessPartnerId = 0;
            String amountDrColumnName = this.isSOTrx() ? "AmtSourceDr" : "AmtSourceCr";
            String string = amountCrColumnName = this.isSOTrx() ? "AmtSourceCr" : "AmtSourceDr";
            while (resultSet.next()) {
                BigDecimal amountSourceCr;
                BigDecimal amountSourceDr;
                int sequece = resultSet.getInt("SeqNo");
                BigDecimal balance = resultSet.getBigDecimal("Balance");
                BigDecimal amountSource = resultSet.getBigDecimal("AmtSource");
                if (amountSource == null) {
                    amountSource = Env.ZERO;
                }
                if ((amountSourceDr = resultSet.getBigDecimal(amountDrColumnName)) == null) {
                    amountSourceDr = Env.ZERO;
                }
                if ((amountSourceCr = resultSet.getBigDecimal(amountCrColumnName)) == null) {
                    amountSourceCr = Env.ZERO;
                }
                Timestamp transactionDate = resultSet.getTimestamp("DateTrx");
                Timestamp accountingDate = resultSet.getTimestamp("DateAcct");
                int businessPartnerId = resultSet.getInt("C_BPartner_ID");
                int organizationId = resultSet.getInt("AD_Org_ID");
                int conversionTypeId = resultSet.getInt("C_ConversionType_ID");
                int fromCurrencyId = resultSet.getInt("C_Currency_ID");
                amountSource = ConversionUtil.get().getConvertedAmount(this.getCtx(), conversionTypeId, fromCurrencyId, this.getCurrencyId(), accountingDate, this.getAD_Client_ID(), organizationId, amountSource);
                amountSourceDr = ConversionUtil.get().getConvertedAmount(this.getCtx(), conversionTypeId, fromCurrencyId, this.getCurrencyId(), accountingDate, this.getAD_Client_ID(), organizationId, amountSourceDr);
                amountSourceCr = ConversionUtil.get().getConvertedAmount(this.getCtx(), conversionTypeId, fromCurrencyId, this.getCurrencyId(), accountingDate, this.getAD_Client_ID(), organizationId, amountSourceCr);
                balance = ConversionUtil.get().getConvertedAmount(this.getCtx(), conversionTypeId, fromCurrencyId, this.getCurrencyId(), accountingDate, this.getAD_Client_ID(), organizationId, balance);
                if (sequece == 10 || currentBusinessPartnerId != businessPartnerId) {
                    balanceAmount = this.isSOTrx() ? balance : balance.negate();
                    currentBusinessPartnerId = businessPartnerId;
                    if (sequece == 10 || transactionDate == null) {
                        transactionDate = this.getDateTrx();
                        accountingDate = this.getDateTrx();
                    }
                } else {
                    balanceAmount = balanceAmount.add(amountSourceDr).subtract(amountSourceCr);
                }
                int orderId = resultSet.getInt("C_Order_ID");
                int invoiceId = resultSet.getInt("C_Invoice_ID");
                int paymentId = resultSet.getInt("C_Payment_ID");
                int allocationHeaderId = resultSet.getInt("C_AllocationHdr_ID");
                int allocationLineId = resultSet.getInt("C_AllocationLine_ID");
                int documentTypeId = resultSet.getInt("C_DocType_ID");
                String description = resultSet.getString("Description");
                if (documentTypeId != 0) {
                    MDocType documentType = MDocType.get((Properties)this.getCtx(), (int)documentTypeId);
                    String documentName = documentType.getName();
                    if (!Env.isBaseLanguage((Properties)this.getCtx(), null)) {
                        documentName = documentType.get_Translation("Name");
                    }
                    description = Util.isEmpty((String)description) ? documentName : documentName + Env.NL + description;
                }
                DB.executeUpdateEx((String)this.sqlInsert, (Object[])new Object[]{resultSet.getBigDecimal("Multiplier"), orderId == 0 ? null : Integer.valueOf(orderId), invoiceId == 0 ? null : Integer.valueOf(invoiceId), paymentId == 0 ? null : Integer.valueOf(paymentId), allocationHeaderId == 0 ? null : Integer.valueOf(allocationHeaderId), allocationLineId == 0 ? null : Integer.valueOf(allocationLineId), resultSet.getString("DocumentNo"), transactionDate, accountingDate, businessPartnerId, amountSource, amountSourceDr, amountSourceCr, balance, resultSet.getString("IsAllocated"), resultSet.getInt("SeqNo") + counter.addAndGet(1), description, balanceAmount, this.getCurrencyId()}, (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            try {
                throw new DBException(e, this.sql.toString());
            }
            catch (Throwable throwable) {
                DB.close(resultSet, pstmtSelect);
                throw throwable;
            }
        }
        DB.close((ResultSet)resultSet, (Statement)pstmtSelect);
        return "Ok";
    }
}

