/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pos.util;

import java.util.Arrays;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInOut;
import org.compiere.model.MOrder;
import org.compiere.model.MPOS;
import org.compiere.model.MProduct;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class ShipmentValidationUtil {
    public static final String COLUMNNAME_IsConfirmCompleteShipment = "IsConfirmCompleteShipment";
    public static final String MESSAGE_MissingProductsOnShipment = "MissingProductsOnShipment";
    public static final String MESSAGE_MissingProductsOnShipmentLine = "MissingProductsOnShipmentLine";

    public static void validateShipmentFromPOS(MInOut shipment) {
        if (shipment.getC_POS_ID() <= 0) {
            return;
        }
        MPOS pos = MPOS.get((Properties)shipment.getCtx(), (int)shipment.getC_POS_ID());
        if (!pos.get_ValueAsBoolean(COLUMNNAME_IsConfirmCompleteShipment)) {
            return;
        }
        StringBuffer errors = new StringBuffer();
        MOrder order = (MOrder)shipment.getC_Order();
        Arrays.asList(order.getLines()).stream().filter(orderLine -> orderLine.getM_Product_ID() > 0).forEach(orderLine -> {
            MProduct product = MProduct.get((Properties)orderLine.getCtx(), (int)orderLine.getM_Product_ID());
            if (orderLine.getQtyOrdered().subtract(orderLine.getQtyDelivered()).compareTo(Env.ZERO) > 0) {
                errors.append(Env.NL);
                errors.append(Msg.getMsg((Properties)order.getCtx(), (String)MESSAGE_MissingProductsOnShipmentLine, (Object[])new Object[]{orderLine.getLine(), product.getValue() + "-" + product.getName(), orderLine.getQtyOrdered().subtract(orderLine.getQtyDelivered())}));
            }
        });
        if (errors.length() > 0) {
            throw new AdempiereException(Msg.parseTranslation((Properties)shipment.getCtx(), (String)"@MissingProductsOnShipment@") + errors.toString());
        }
    }
}

