/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pos.util;

import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrderLine;
import org.compiere.model.MTax;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class PointOfSalesImprovementsChanges {
    public static final String COLUMNNAME_IsTaxExempt = "IsTaxExempt";

    public static void changeTax(MOrderLine orderLine, boolean isSOTaxExempt) {
        if (!orderLine.isProcessed()) {
            if (isSOTaxExempt) {
                MTax exemptTax = PointOfSalesImprovementsChanges.getDefaultExemptTax(orderLine.getAD_Org_ID());
                if (exemptTax == null) {
                    throw new AdempiereException("@C_Tax_ID@ @IsTaxExempt@ @NotFound@");
                }
                if (orderLine.getC_Tax_ID() == exemptTax.getC_Tax_ID()) {
                    return;
                }
                orderLine.setC_Tax_ID(exemptTax.getC_Tax_ID());
                orderLine.setLineNetAmt();
            } else {
                orderLine.setTax();
                orderLine.setLineNetAmt();
            }
        }
    }

    public static MTax getTax(int taxCategoryId) {
        Optional<MTax> optionalTax = Arrays.asList(MTax.getAll((Properties)Env.getCtx())).stream().filter(tax -> tax.getC_TaxCategory_ID() == taxCategoryId && PointOfSalesImprovementsChanges.isSalesTax(tax)).findFirst();
        if (optionalTax.isPresent()) {
            return optionalTax.get();
        }
        return null;
    }

    private static MTax getDefaultExemptTax(int organizationId) {
        Optional<MTax> optionalTax = Arrays.asList(MTax.getAll((Properties)Env.getCtx())).stream().filter(tax -> tax.isZeroTax() && (tax.getAD_Org_ID() == organizationId || tax.getAD_Org_ID() == 0) && PointOfSalesImprovementsChanges.isSalesTax(tax)).findFirst();
        if (optionalTax.isPresent()) {
            return optionalTax.get();
        }
        return null;
    }

    private static boolean isSalesTax(MTax tax) {
        return tax.isSalesTax() || !Util.isEmpty((String)tax.getSOPOType()) && (tax.getSOPOType().equals("B") || tax.getSOPOType().equals("S"));
    }
}

