/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pos.util;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MMailText;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.pos.util.PaymentVerificationHandler;
import org.spin.queue.notification.DefaultNotifier;
import org.spin.queue.util.QueueLoader;

public class PaymentApprovalUtil {
    public static final String COLUMNNAME_IsPaymentVerified = "IsPaymentVerified";
    public static final String COLUMNNAME_IsPaymentVerificationRequired = "IsPaymentVerificationRequired";
    public static final String MESSAGE_PaymentNotVerifyByOperator = "PaymentNotVerifyByOperator";
    public static final String COLUMNNAME_C_PaymentMethod_ID = "C_PaymentMethod_ID";
    public static final String COLUMNNAME_PayVerificationSupervisor_ID = "PayVerificationSupervisor_ID";
    public static final String COLUMNNAME_PayVerificationMailText_ID = "PayVerificationMailText_ID";

    public static void setDefaultVerificationFromPointOfSales(MPayment payment) {
        if (payment.isProcessed() || payment.getC_POS_ID() <= 0 || !payment.isReceipt() || payment.getC_Charge_ID() > 0) {
            return;
        }
        PO paymentTypeAllocation = new Query(payment.getCtx(), "C_POSPaymentTypeAllocation", "C_POS_ID = ? AND C_PaymentMethod_ID = ? AND IsPaymentVerificationRequired = ?", payment.get_TrxName()).setParameters(new Object[]{payment.getC_POS_ID(), payment.get_ValueAsInt(COLUMNNAME_C_PaymentMethod_ID), "Y"}).setOnlyActiveRecords(true).first();
        if (paymentTypeAllocation != null && paymentTypeAllocation.get_ID() > 0) {
            payment.set_ValueOfColumn(COLUMNNAME_IsPaymentVerificationRequired, (Object)true);
        }
    }

    public static void sendPaymentVerificationNotification(MPayment payment) {
        if (payment.isProcessed() || payment.getC_POS_ID() <= 0 || !payment.isReceipt() || payment.getC_Charge_ID() > 0) {
            return;
        }
        PO paymentTypeAllocation = new Query(payment.getCtx(), "C_POSPaymentTypeAllocation", "C_POS_ID = ? AND C_PaymentMethod_ID = ? AND IsPaymentVerificationRequired = ?", payment.get_TrxName()).setParameters(new Object[]{payment.getC_POS_ID(), payment.get_ValueAsInt(COLUMNNAME_C_PaymentMethod_ID), "Y"}).setOnlyActiveRecords(true).first();
        if (paymentTypeAllocation != null && paymentTypeAllocation.get_ID() > 0 && paymentTypeAllocation.get_ValueAsInt(COLUMNNAME_PayVerificationSupervisor_ID) > 0 && paymentTypeAllocation.get_ValueAsInt(COLUMNNAME_PayVerificationMailText_ID) > 0) {
            DefaultNotifier notifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(Env.getCtx()).withTransactionName(payment.get_TrxName());
            MMailText template = new MMailText(payment.getCtx(), paymentTypeAllocation.get_ValueAsInt(COLUMNNAME_PayVerificationMailText_ID), payment.get_TrxName());
            template.setPO((PO)payment);
            template.setPO(paymentTypeAllocation);
            String description = template.getMailHeader();
            String text = template.getMailText(true);
            notifier.clearMessage().withUpdateHandler(PaymentVerificationHandler.class.getName()).withApplicationType("UDP").withUserId(payment.get_ValueAsInt("CollectingAgent_ID")).withText(text).addRecipient(paymentTypeAllocation.get_ValueAsInt(COLUMNNAME_PayVerificationSupervisor_ID), null, "CFM").withTableId(MPayment.Table_ID).withRecordId(payment.getC_Payment_ID()).withDescription(description).addToQueue();
        }
    }

    public static void validateApprovalforPayment(MOrder order) {
        MPayment.getOfOrder((MOrder)order).forEach(payment -> PaymentApprovalUtil.validateApprovalForPayment(payment));
    }

    public static void validateApprovalForPayment(MPayment payment) {
        if (payment.get_ValueAsBoolean(COLUMNNAME_IsPaymentVerificationRequired) && !payment.get_ValueAsBoolean(COLUMNNAME_IsPaymentVerified)) {
            throw new AdempiereException(Msg.parseTranslation((Properties)payment.getCtx(), (String)"@PaymentNotVerifyByOperator@"));
        }
    }
}

