/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pos.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.pos.process.GenerateRefundFromPOSAbstract;

public class GenerateRefundFromPOS
extends GenerateRefundFromPOSAbstract {
    private AtomicInteger created = new AtomicInteger();
    private StringBuffer generatedDocuments = new StringBuffer();
    private List<MPayment> payments = new ArrayList<MPayment>();

    protected String doIt() throws Exception {
        MTable table = MTable.get((Properties)this.getCtx(), (String)"C_POSPaymentReference");
        if (table == null) {
            throw new AdempiereException("@C_POSPaymentReference_ID@ @AD_Table_ID@ @NotFound@");
        }
        Iterator iterator = this.getSelectionKeys().iterator();
        while (iterator.hasNext()) {
            int orderRefundId = (Integer)iterator.next();
            PO orderBankAccount = table.getPO(orderRefundId, this.get_TrxName());
            this.createPayment(orderBankAccount, this.getSelectionAsBigDecimal(orderRefundId, "OPB_ConvertedAmt"));
        }
        this.processingPayments();
        return "@Created@ " + this.created + (this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }

    private void processingPayments() {
        this.payments.forEach(payment -> {
            if (!payment.processIt("CO")) {
                throw new AdempiereException("@Error@ " + payment.getProcessMsg());
            }
            payment.saveEx();
            this.created.incrementAndGet();
            this.addToMessage(payment.getDocumentNo());
        });
    }

    private MPayment createPayment(PO paymentReference, BigDecimal convertedAmount) {
        int orderId = paymentReference.get_ValueAsInt("C_Order_ID");
        MOrder salesOrder = new MOrder(this.getCtx(), orderId, this.get_TrxName());
        List<MInvoice> invoices = Arrays.asList(salesOrder.getInvoices());
        MInvoice invoice = null;
        if (!invoices.isEmpty()) {
            invoice = (MInvoice)invoices.stream().findFirst().get();
        }
        MPayment payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
        int currencyId = paymentReference.get_ValueAsInt("C_Currency_ID");
        int conversionTypeId = paymentReference.get_ValueAsInt("C_ConversionType_ID");
        int paymentMethodId = paymentReference.get_ValueAsInt("C_PaymentMethod_ID");
        int posId = paymentReference.get_ValueAsInt("C_POS_ID");
        String description = paymentReference.get_ValueAsString("Description");
        String tenderType = paymentReference.get_ValueAsString("TenderType");
        payment.setC_BPartner_ID(salesOrder.getC_BPartner_ID());
        payment.setC_BankAccount_ID(this.getBankAccountId());
        payment.setC_ConversionType_ID(conversionTypeId);
        payment.setC_Currency_ID(currencyId);
        payment.setDateTrx(this.getPayDate());
        payment.setDateAcct(this.getPayDate());
        if (this.getDocTypeTargetId() > 0) {
            payment.setC_DocType_ID(this.getDocTypeTargetId());
        }
        payment.setIsReceipt(false);
        payment.setC_POS_ID(posId);
        if (invoice != null) {
            payment.setC_Invoice_ID(invoice.getC_Invoice_ID());
        } else {
            payment.setC_Order_ID(salesOrder.getC_Order_ID());
        }
        payment.setPayAmt(convertedAmount);
        MUser user = MUser.get((Properties)this.getCtx(), (int)this.getAD_User_ID());
        String userName = "";
        if (user != null) {
            userName = user.getName();
        }
        payment.addDescription(description);
        payment.addDescription(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@Created@ @from@") + " - " + userName + " - " + DisplayType.getDateFormat((int)15).format(this.getPayDate()));
        payment.set_ValueOfColumn("C_PaymentMethod_ID", (Object)paymentMethodId);
        payment.setTenderType(tenderType);
        payment.setDocumentNo(this.getDocumentNo());
        payment.setCheckNo(this.getDocumentNo());
        payment.saveEx();
        paymentReference.set_ValueOfColumn("IsPaid", (Object)true);
        paymentReference.set_ValueOfColumn("Processed", (Object)true);
        paymentReference.saveEx();
        this.payments.add(payment);
        return payment;
    }
}

