/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pos.model.validator;

import java.util.Arrays;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.spin.pos.util.PointOfSalesImprovementsChanges;

public class ChangeTax
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ChangeTax.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        if (type == 1 || type == 2) {
            if (entity.get_TableName().equals("C_OrderLine")) {
                MDocType documentType;
                boolean isTaxExempt;
                MOrderLine orderLine2;
                MOrder salesOrder;
                if ((entity.is_new() || entity.is_ValueChanged("M_Product_ID") || entity.is_ValueChanged("C_Charge_ID") || entity.is_ValueChanged("QtyEntered") || entity.is_ValueChanged("PriceEntered") || entity.is_ValueChanged("Discount") || entity.is_ValueChanged("C_BPartner_ID") || entity.is_ValueChanged("C_UOM_ID") || entity.is_ValueChanged("C_Tax_ID")) && (salesOrder = (orderLine2 = (MOrderLine)entity).getParent()).isSOTrx() && !salesOrder.isReturnOrder() && (isTaxExempt = (documentType = MDocType.get((Properties)entity.getCtx(), (int)salesOrder.getC_DocTypeTarget_ID())).get_ValueAsBoolean("IsTaxExempt"))) {
                    PointOfSalesImprovementsChanges.changeTax(orderLine2, isTaxExempt);
                }
            } else if (entity.get_TableName().equals("C_Order") && (entity.is_new() || entity.is_ValueChanged("C_DocTypeTarget_ID") || entity.is_ValueChanged("C_BPartner_ID") || entity.is_ValueChanged("M_PriceList_ID") || entity.is_ValueChanged("M_Warehouse_ID"))) {
                MOrder order = (MOrder)entity;
                MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)order.getC_DocTypeTarget_ID());
                boolean isTaxExempt = documentType.get_ValueAsBoolean("IsTaxExempt");
                if (order.isSOTrx() && !order.isReturnOrder()) {
                    Arrays.asList(order.getLines()).forEach(orderLine -> {
                        PointOfSalesImprovementsChanges.changeTax(orderLine, isTaxExempt);
                        orderLine.saveEx();
                    });
                }
            }
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        return null;
    }
}

