/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model.validator;

import java.util.Arrays;
import java.util.Optional;
import org.compiere.model.MClient;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.report.FinReportAbstract;
import org.compiere.report.MReport;
import org.compiere.report.MReportColumnSet;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class FinReport
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(FinReport.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("AD_PInstance", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        MPInstance pInstance;
        if (po instanceof MPInstance && type == 2 && !(pInstance = (MPInstance)po).isProcessing() && pInstance.is_ValueChanged("IsProcessing") && pInstance.getAD_Process_ID() == FinReportAbstract.getProcessId()) {
            MReport report = new MReport(pInstance.getCtx(), pInstance.getRecord_ID(), pInstance.get_TrxName());
            MReportColumnSet columnSet = report.getColumnSet();
            int C_Currency_ID = report.getC_AcctSchema().getC_Currency_ID();
            int C_Currency_ID_To = 0;
            int C_ConversionType_ID = 0;
            Optional<MPInstancePara> period = Arrays.asList(pInstance.getParameters()).stream().filter(param -> param.getParameterName().equals("C_Period_ID")).findFirst();
            for (int col = 0; col < columnSet.getColumns().length; ++col) {
                if (columnSet.getColumns()[col].getFactor() == null || !columnSet.getColumns()[col].getFactor().equals("X")) continue;
                C_Currency_ID_To = columnSet.getColumns()[col].get_ValueAsInt("C_Currency_ID");
                C_ConversionType_ID = columnSet.getColumns()[col].get_ValueAsInt("C_ConversionType_ID");
                String sql = "UPDATE T_Report SET Col_" + col + "= CurrencyConvert(Col_" + col + "," + C_Currency_ID + "," + C_Currency_ID_To + "," + "(SELECT EndDate FROM C_Period WHERE C_Period_ID = " + (period.isPresent() ? period.get().getP_Number() : Integer.valueOf(0)) + ")," + C_ConversionType_ID + "," + pInstance.getAD_Client_ID() + "," + pInstance.getAD_Org_ID() + " ) WHERE AD_PInstance_ID = ? " + "AND NOT EXISTS(SELECT 1 FROM PA_ReportLine pl WHERE pl.CalculationType= 'P' AND pl.PA_ReportLine_ID = T_Report.PA_ReportLine_ID)";
                DB.executeUpdate((String)sql, (int)pInstance.getAD_PInstance_ID(), (String)po.get_TrxName());
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

