/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pa.setup;

import java.util.Arrays;
import java.util.Properties;
import org.adempiere.model.GenericPO;
import org.compiere.acct.Doc_InOut_EstimatedLandedCosts;
import org.compiere.model.MCostType;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MLanguage;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ModelValidator;
import org.spin.pa.engine.AverageInvoiceWithEstimatedCostingMethod;
import org.spin.util.ISetupDefinition;

public class EstimatedLandedCosts
implements ISetupDefinition {
    public String doIt(Properties context, String transactionName) {
        this.createDocumentBaseType(context, transactionName);
        this.setLogicForCostType(context, transactionName);
        this.createModelValidator(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void createDocumentBaseType(Properties context, String transactionName) {
        GenericPO docBaseTypeMaterialReceipt = new GenericPO("C_DocBaseType", context, 0, transactionName);
        docBaseTypeMaterialReceipt.set_ValueOfColumn("DocBaseType", (Object)"MMR");
        docBaseTypeMaterialReceipt.set_ValueOfColumn("Name", (Object)"Material Receipt (Estimated Landed Costs)");
        docBaseTypeMaterialReceipt.set_ValueOfColumn("Description", (Object)"(*Created from Setup Automatically*)");
        docBaseTypeMaterialReceipt.set_ValueOfColumn("UUID", (Object)"(*AutomaticSetup*)");
        docBaseTypeMaterialReceipt.set_ValueOfColumn("AccountingClassName", (Object)Doc_InOut_EstimatedLandedCosts.class.getName());
        docBaseTypeMaterialReceipt.set_ValueOfColumn("EntityType", (Object)"ECA20");
        docBaseTypeMaterialReceipt.set_ValueOfColumn("AD_Table_ID", (Object)MInOut.Table_ID);
        docBaseTypeMaterialReceipt.setIsDirectLoad(true);
        docBaseTypeMaterialReceipt.saveEx();
        this.createTranslation(context, transactionName, "C_DocBaseType_Trl", "C_DocBaseType_ID", docBaseTypeMaterialReceipt.get_ID(), "Recibo de Material (Costos Estimados)");
        MDocType docTypeMaterialReceipt = new MDocType(context, 0, transactionName);
        docTypeMaterialReceipt.setName("Material Receipt (Estimated Landed Costs)");
        docTypeMaterialReceipt.setPrintName("Material Receipt (Estimated Landed Costs)");
        docTypeMaterialReceipt.set_ValueOfColumn("C_DocBaseType_ID", (Object)docBaseTypeMaterialReceipt.get_ID());
        docTypeMaterialReceipt.setDocBaseType("MMR");
        docTypeMaterialReceipt.setGL_Category_ID();
        docTypeMaterialReceipt.setIsDirectLoad(true);
        docTypeMaterialReceipt.saveEx();
        this.createTranslation(context, transactionName, "C_DocType".concat("_Trl"), "C_DocType_ID", docTypeMaterialReceipt.get_ID(), "Recibo de Material (Costos Estimados)");
    }

    private void createTranslation(Properties context, String transactionName, String tableName, String poColumnNameId, int poId, String translation) {
        Arrays.asList(MLanguage.getMaintainLanguage((Properties)context)).forEach(languague -> {
            if (languague.isSystemLanguage() && languague.getAD_Language().contains("es_")) {
                GenericPO trl = new GenericPO(tableName, context, 0, transactionName);
                trl.set_ValueOfColumn(poColumnNameId, (Object)poId);
                trl.set_ValueOfColumn("Name", (Object)translation);
                trl.set_ValueOfColumn("Description", (Object)translation);
                trl.set_ValueOfColumn("PrintName", (Object)translation);
                trl.set_ValueOfColumn("AD_Language", (Object)languague.getAD_Language());
                trl.saveEx();
            }
        });
    }

    private X_AD_ModelValidator createModelValidator(Properties context, String transactionName) {
        X_AD_ModelValidator modelValidator = (X_AD_ModelValidator)new Query(context, "AD_ModelValidator", "ModelValidationClass = ?", transactionName).setParameters(new Object[]{org.spin.pa.model.validator.EstimatedLandedCosts.class.getName()}).setClient_ID().first();
        if (modelValidator != null && modelValidator.getAD_ModelValidator_ID() > 0) {
            return modelValidator;
        }
        modelValidator = new X_AD_ModelValidator(context, 0, transactionName);
        modelValidator.setName("Estimated Landed Costs");
        modelValidator.setEntityType("ECA20");
        modelValidator.setDescription("(*Created from Setup Automatically*)");
        modelValidator.setSeqNo(200);
        modelValidator.setModelValidationClass(org.spin.pa.model.validator.EstimatedLandedCosts.class.getName());
        modelValidator.setUUID("(*AutomaticSetup*)");
        modelValidator.setIsDirectLoad(true);
        modelValidator.saveEx();
        return modelValidator;
    }

    private void setLogicForCostType(Properties context, String transactionName) {
        MCostType.get((Properties)context, (String)transactionName).forEach(costType -> {
            if (costType.getCostingMethod().equals("I")) {
                costType.set_ValueOfColumn("ClassName", (Object)AverageInvoiceWithEstimatedCostingMethod.class.getName());
                costType.save();
            }
        });
    }
}

