/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pa.report;

import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MPeriod;
import org.compiere.report.MReportTree;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.spin.pa.report.FinStatementByElementAbstract;

public class FinStatementByElement
extends FinStatementByElementAbstract {
    private StringBuffer parameterWhere = new StringBuffer();
    private long m_start = System.currentTimeMillis();
    private static final String attributeTableName = "tableName";
    private static final String attributeFactColumnReferenceId = "factColumnReferenceId";
    private static final String attributeColumnId = "columnId";
    private static final String attributeColumnValue = "columnValue";
    private static final String attributeColumnName = "columnName";
    private static final String amountTypeAccountSign = "AS";
    private static final String amountTypeExpectedSign = "ES";
    private String columnDebit = "fa.AmtAcctDr";
    private String columnCredit = "fa.AmtAcctCr";
    private String columnBalance = "fa.AmtAcctDr - fa.AmtAcctCr";
    private String columnQty = "fa.Qty";
    private static final Map<String, String> elementTreeType = new HashMap<String, String>(){
        {
            this.put("AC", "EV");
            this.put("U1", "U1");
            this.put("U2", "U2");
            this.put("U3", "U3");
            this.put("U4", "U4");
        }
    };
    private static final Map<String, Map<String, String>> elementInfo = new HashMap<String, Map<String, String>>(){
        {
            this.put("OO", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "AD_Org");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "AD_Org_ID");
                    this.put(FinStatementByElement.attributeColumnId, "AD_Org_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "Value");
                    this.put(FinStatementByElement.attributeColumnName, "Name");
                }
            });
            this.put("AC", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "C_ElementValue");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "Account_ID");
                    this.put(FinStatementByElement.attributeColumnId, "C_ElementValue_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "Value");
                    this.put(FinStatementByElement.attributeColumnName, "Name");
                }
            });
            this.put("SA", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "C_SubAcct");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "C_SubAcct_ID");
                    this.put(FinStatementByElement.attributeColumnId, "C_SubAcct_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "Value");
                    this.put(FinStatementByElement.attributeColumnName, "Name");
                }
            });
            this.put("BP", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "C_BPartner");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "C_BPartner_ID");
                    this.put(FinStatementByElement.attributeColumnId, "C_BPartner_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "Value");
                    this.put(FinStatementByElement.attributeColumnName, "Name");
                }
            });
            this.put("PR", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "M_Product");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "M_Product_ID");
                    this.put(FinStatementByElement.attributeColumnId, "M_Product_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "Value");
                    this.put(FinStatementByElement.attributeColumnName, "Name");
                }
            });
            this.put("AY", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "C_Activity");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "C_Activity_ID");
                    this.put(FinStatementByElement.attributeColumnId, "C_Activity_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "Value");
                    this.put(FinStatementByElement.attributeColumnName, "Name");
                }
            });
            this.put("LF", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "C_Location");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "C_LocFrom_ID");
                    this.put(FinStatementByElement.attributeColumnId, "C_Location_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "City");
                    this.put(FinStatementByElement.attributeColumnName, "Address1");
                }
            });
            this.put("LT", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "C_Location");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "C_LocTo_ID");
                    this.put(FinStatementByElement.attributeColumnId, "C_Location_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "City");
                    this.put(FinStatementByElement.attributeColumnName, "Address1");
                }
            });
            this.put("MC", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "C_Campaign");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "C_Campaign_ID");
                    this.put(FinStatementByElement.attributeColumnId, "C_Campaign_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "Value");
                    this.put(FinStatementByElement.attributeColumnName, "Name");
                }
            });
            this.put("OT", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "AD_Org");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "AD_OrgTrx_ID");
                    this.put(FinStatementByElement.attributeColumnId, "AD_Org_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "Value");
                    this.put(FinStatementByElement.attributeColumnName, "Name");
                }
            });
            this.put("PJ", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "C_Project");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "C_Project_ID");
                    this.put(FinStatementByElement.attributeColumnId, "C_Project_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "Value");
                    this.put(FinStatementByElement.attributeColumnName, "Name");
                }
            });
            this.put("SR", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "C_SalesRegion");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "C_SalesRegion_ID");
                    this.put(FinStatementByElement.attributeColumnId, "C_SalesRegion_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "Value");
                    this.put(FinStatementByElement.attributeColumnName, "Name");
                }
            });
            this.put("U1", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "C_ElementValue");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "User1_ID");
                    this.put(FinStatementByElement.attributeColumnId, "C_ElementValue_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "Value");
                    this.put(FinStatementByElement.attributeColumnName, "Name");
                }
            });
            this.put("U2", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "C_ElementValue");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "User2_ID");
                    this.put(FinStatementByElement.attributeColumnId, "C_ElementValue_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "Value");
                    this.put(FinStatementByElement.attributeColumnName, "Name");
                }
            });
            this.put("U3", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "C_ElementValue");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "User3_ID");
                    this.put(FinStatementByElement.attributeColumnId, "C_ElementValue_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "Value");
                    this.put(FinStatementByElement.attributeColumnName, "Name");
                }
            });
            this.put("U4", new HashMap<String, String>(){
                {
                    this.put(FinStatementByElement.attributeTableName, "C_ElementValue");
                    this.put(FinStatementByElement.attributeFactColumnReferenceId, "User4_ID");
                    this.put(FinStatementByElement.attributeColumnId, "C_ElementValue_ID");
                    this.put(FinStatementByElement.attributeColumnValue, "Value");
                    this.put(FinStatementByElement.attributeColumnName, "Name");
                }
            });
        }
    };

    protected String doIt() {
        String selectedAmountType = Optional.ofNullable(this.getAmountType()).orElse(amountTypeAccountSign);
        if (selectedAmountType.compareTo(amountTypeExpectedSign) == 0) {
            this.columnDebit = "AcctBalance(fa.Account_ID, fa.AmtAcctDr, 0)";
            this.columnCredit = "AcctBalance(fa.Account_ID, 0, fa.AmtAcctCr)";
            this.columnBalance = "AcctBalance(fa.Account_ID, fa.AmtAcctDr, fa.AmtAcctCr)";
            this.columnQty = "AcctBalance(fa.Account_ID, fa.Qty, 0)";
        }
        this.setWhereClause();
        this.createBalanceLine();
        this.createDetailLines();
        this.log.fine(System.currentTimeMillis() - this.m_start + " ms");
        return "";
    }

    private void setWhereClause() {
        this.parameterWhere.append("fa.C_AcctSchema_ID=").append(this.getAcctSchemaId()).append(" AND fa.PostingType='").append(this.getPostingType()).append("'");
        if (this.getAccountId() > 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause((Properties)this.getCtx(), (int)this.getHierarchyId(), (String)"AC", (int)this.getAccountId(), (String)"fa."));
        }
        if (this.getOrgId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause((Properties)this.getCtx(), (int)this.getHierarchyId(), (String)"OO", (int)this.getOrgId(), (String)"fa."));
        }
        if (this.getBPartnerId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause((Properties)this.getCtx(), (int)this.getHierarchyId(), (String)"BP", (int)this.getBPartnerId(), (String)"fa."));
        }
        if (this.getProductId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause((Properties)this.getCtx(), (int)this.getHierarchyId(), (String)"PR", (int)this.getProductId(), (String)"fa."));
        }
        if (this.getProjectId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause((Properties)this.getCtx(), (int)this.getHierarchyId(), (String)"PJ", (int)this.getProjectId(), (String)"fa."));
        }
        if (this.getActivityId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause((Properties)this.getCtx(), (int)this.getHierarchyId(), (String)"AY", (int)this.getActivityId(), (String)"fa."));
        }
        if (this.getCampaignId() != 0) {
            this.parameterWhere.append(" AND fa.C_Campaign_ID=").append(this.getCampaignId());
        }
        if (this.getSalesRegionId() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause((Properties)this.getCtx(), (int)this.getHierarchyId(), (String)"SR", (int)this.getSalesRegionId(), (String)"fa."));
        }
        if (this.getUser1Id() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause((Properties)this.getCtx(), (int)this.getHierarchyId(), (String)"U1", (int)this.getUser1Id(), (String)"fa."));
        }
        if (this.getUser2Id() != 0) {
            this.parameterWhere.append(" AND ").append(MReportTree.getWhereClause((Properties)this.getCtx(), (int)this.getHierarchyId(), (String)"U2", (int)this.getUser2Id(), (String)"fa."));
        }
        if (this.getAccountType() != null) {
            this.parameterWhere.append(" AND fa.AccountType='").append(this.getAccountType()).append("'");
        }
        this.setDateAcct();
        StringBuffer sb = new StringBuffer();
        sb.append(" - DateAcct ").append(this.getDateAcct()).append("-").append(this.getDateAcctTo());
        sb.append(" - Where=").append(this.parameterWhere);
        this.log.fine(sb.toString());
    }

    private void setDateAcct() {
        if (this.getDateAcct() != null) {
            if (this.getDateAcctTo() == null) {
                this.setDateAcctTo(new Timestamp(System.currentTimeMillis()));
            }
            return;
        }
        if (this.getPeriodId() == 0) {
            GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
            cal.setTimeInMillis(System.currentTimeMillis());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.set(5, 1);
            this.setDateAcct(new Timestamp(cal.getTimeInMillis()));
            cal.add(2, 1);
            cal.add(6, -1);
            this.setDateAcctTo(new Timestamp(cal.getTimeInMillis()));
            return;
        }
        MPeriod period = new MPeriod(this.getCtx(), this.getPeriodId(), this.get_TrxName());
        this.setDateAcct(period.getStartDate());
        this.setDateAcctTo(period.getEndDate());
    }

    private void createBalanceLine() {
        boolean beginBalance = this.isBeginningBalance();
        Optional.ofNullable(elementInfo.get(this.getElementType())).ifPresent(currentElementInfo -> {
            String factColumnDimensionId = (String)currentElementInfo.get(attributeFactColumnReferenceId);
            String sourceColumnValue = (String)currentElementInfo.get(attributeColumnValue);
            String sourceColumnName = (String)currentElementInfo.get(attributeColumnName);
            String sourceColumnId = (String)currentElementInfo.get(attributeColumnId);
            String dimensionTableName = (String)currentElementInfo.get(attributeTableName);
            String accountType = Optional.ofNullable(this.getAccountType()).orElse("");
            String elementFrom = "";
            if (this.getElementType().compareTo("AC") == 0 || this.getElementType().compareTo("U1") == 0 || this.getElementType().compareTo("U2") == 0 || this.getElementType().compareTo("U3") == 0 || this.getElementType().compareTo("U4") == 0) {
                elementFrom = " INNER JOIN C_Element e ON (e.C_Element_ID = dim.C_Element_ID)  INNER JOIN AD_Tree t ON (t.AD_Tree_ID = e.AD_Tree_ID AND TreeType = '" + elementTreeType.get(this.getElementType()) + "') ";
            }
            StringBuilder where = new StringBuilder();
            where.append(" WHERE ").append(this.parameterWhere).append(" AND TRUNC(DateAcct, 'DD') < ").append(DB.TO_DATE((Timestamp)this.getDateAcct()));
            StringBuffer sb = new StringBuffer("INSERT INTO T_ReportStatementByElement (AD_PInstance_ID, Fact_Acct_ID, LevelNo, DateAcct, Info,AmtAcctDr, AmtAcctCr, Balance, Qty, Account_ID, AccountValue, AccountName, AccountType, AD_Table_ID, Record_ID, Value, Name) ");
            sb.append(" SELECT ").append(this.getAD_PInstance_ID()).append(",0").append(",0").append(",".concat(DB.TO_DATE((Timestamp)this.getDateAcct(), (boolean)true))).append(",".concat(DB.TO_STRING((String)Msg.getMsg((Properties)Env.getCtx(), (String)"BeginningBalance")))).append(",COALESCE(fa.AmtAcctDr, 0) AmtAcctDr ").append(",COALESCE(fa.AmtAcctCr, 0) AmtAcctCr ").append(",COALESCE(fa.Balance,0) Balance ").append(",COALESCE(fa.Qty, 0) Qty ").append(",0 ").append(", ''").append(", ''").append(", '".concat(accountType).concat("'")).append(",0 ").append(",0 ").append(", dim.".concat(sourceColumnValue)).append(", dim.".concat(sourceColumnName)).append(" FROM ".concat(dimensionTableName).concat(" dim ")).append(elementFrom).append(" ".concat(beginBalance ? "LEFT" : "INNER").concat(" JOIN (SELECT ")).append("fa.".concat(factColumnDimensionId)).append(",SUM(".concat(this.columnDebit).concat(") AmtAcctDr")).append(",SUM(".concat(this.columnCredit).concat(") AmtAcctCr")).append(",SUM(".concat(this.columnBalance).concat(") Balance")).append(",SUM(".concat(this.columnQty).concat(") Qty ")).append("FROM Fact_Acct fa ").append((CharSequence)where).append("GROUP BY ".concat("fa.").concat(factColumnDimensionId).concat(") ")).append(" fa ON (fa.".concat(factColumnDimensionId).concat(" = dim.").concat(sourceColumnId).concat(")"));
            sb.append("WHERE dim.AD_Client_ID = ").append(this.getAD_Client_ID());
            if (this.getAccountId() > 0 && !elementFrom.isEmpty()) {
                sb.append(" AND  dim.C_ElementValue_ID = ").append(this.getAccountId());
            }
            if (this.getAccountType() != null && !this.getAccountType().isEmpty() && !elementFrom.isEmpty()) {
                sb.append(" AND  dim.AccountType = '").append(this.getAccountType()).append("'");
            }
            if (!beginBalance) {
                sb.append(" AND (fa.AmtAcctDr !=0 OR fa.AmtAcctCr!=0)");
            }
            int no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
            this.log.fine("#" + no + " (Account_ID=" + this.getAccountId() + ")");
            this.log.finest(sb.toString());
        });
    }

    private void createDetailLines() {
        Optional.ofNullable(elementInfo.get(this.getElementType())).ifPresent(currentElementInfo -> {
            String factColumnDimensionId = (String)currentElementInfo.get(attributeFactColumnReferenceId);
            String sourceColumnValue = (String)currentElementInfo.get(attributeColumnValue);
            String sourceColumnName = (String)currentElementInfo.get(attributeColumnName);
            String sourceColumnId = (String)currentElementInfo.get(attributeColumnId);
            String dimensionTableName = (String)currentElementInfo.get(attributeTableName);
            Language currentLanguage = Env.getLanguage((Properties)this.getCtx());
            Boolean isBaseLanguage = currentLanguage.isBaseLanguage();
            StringBuffer sb = new StringBuffer("INSERT INTO T_ReportStatementByElement (AD_PInstance_ID, Fact_Acct_ID, LevelNo, DateAcct, Description,AmtAcctDr, AmtAcctCr, Balance, Qty, Account_ID , Accountvalue, AccountName, AccountType, AD_Table_ID, Record_ID, Value, Name, Info) ");
            sb.append(" SELECT ").append(this.getAD_PInstance_ID()).append(",fa.Fact_Acct_ID ").append(", 1").append(",TRUNC(fa.DateAcct, 'DD') ").append(", fa.Description ").append(", ".concat(this.columnDebit)).append(", ".concat(this.columnCredit)).append(", ".concat(this.columnBalance)).append(", ".concat(this.columnQty)).append(", fa.Account_ID ").append(", ev.Value ").append(", ev.Name ").append(", ev.AccountType ").append(", fa.AD_Table_ID ").append(", fa.Record_ID ").append(", dim.".concat(sourceColumnValue)).append(", dim.".concat(sourceColumnName)).append(isBaseLanguage == false ? ", etrl.Name" : ", e.Name").append(" FROM Fact_Acct fa ").append(" INNER JOIN C_Elementvalue ev on (fa.Account_ID = ev.C_ElementValue_ID) ").append(" INNER JOIN ".concat(dimensionTableName).concat(" dim ON (fa.").concat(factColumnDimensionId).concat("= dim.").concat(sourceColumnId).concat(") ")).append(" INNER JOIN AD_Table t ON (fa.AD_Table_ID=t.AD_Table_ID)").append(" INNER JOIN AD_Element e ON (t.TableName||'_ID'=e.ColumnName) ").append(isBaseLanguage == false ? " INNER JOIN AD_Element_trl etrl ON (e.AD_Element_ID=etrl.AD_Element_ID AND etrl.AD_Language = '" + currentLanguage.getAD_Language() + "')" : "").append(" WHERE ").append(this.parameterWhere).append(" AND TRUNC(fa.DateAcct, 'DD') BETWEEN ").append(DB.TO_DATE((Timestamp)this.getDateAcct())).append(" AND ").append(DB.TO_DATE((Timestamp)this.getDateAcctTo()));
            sb.append(" AND ev.AD_Client_ID = ").append(this.getAD_Client_ID());
            int no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
            this.log.fine("#" + no);
            this.log.finest(sb.toString());
        });
    }
}

