/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pa.model.validator;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.pa.model.MOrderLandedCost;
import org.spin.pa.model.MOrderLandedCostAllocation;
import org.spin.pa.model.MPAProductTariffCost;

public class EstimatedTariffLandedCosts
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EstimatedTariffLandedCosts.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        return null;
    }

    public String docValidate(PO entity, int timing) {
        String error;
        MOrder order;
        if (timing == 7 && entity.get_TableName().equals("C_Order") && !(order = (MOrder)entity).isSOTrx() && !Util.isEmpty((String)(error = this.landedCostAllocation(order)))) {
            return error;
        }
        if (timing == 4 && entity.get_TableName().equals("C_Order") && !(order = (MOrder)entity).isSOTrx()) {
            this.reActivateCostAllocation(order);
        }
        return null;
    }

    private String landedCostAllocation(MOrder order) {
        AtomicReference<String> error = new AtomicReference<String>("");
        String whereClause = "C_Order_ID = ? AND EXISTS(SELECT 1 FROM PA_Product_Tariff_Cost ptc WHERE ptc.M_Product_ID = C_OrderLine.M_Product_ID AND ptc.TariffRate!=0) ";
        new Query(order.getCtx(), "C_OrderLine", whereClause, order.get_TrxName()).setParameters(new Object[]{order.get_ID()}).list().forEach(orderLine -> {
            MProduct product = MProduct.get((Properties)order.getCtx(), (int)orderLine.getM_Product_ID());
            BigDecimal orderLineAmount = this.getOrderLineCost((MOrderLine)orderLine);
            MPAProductTariffCost.getTariffCostsByProduct(product).forEach(tariffLandedCost -> {
                MOrderLandedCost orderLandedCost = new MOrderLandedCost(order.getCtx(), 0, order.get_TrxName());
                orderLandedCost.setM_CostElement_ID(tariffLandedCost.getM_CostElement_ID());
                orderLandedCost.setLandedCostDistribution("L");
                orderLandedCost.set_ValueOfColumn("C_OrderLine_ID", orderLine.getC_OrderLine_ID());
                orderLandedCost.setC_Order_ID(orderLine.getC_Order_ID());
                Optional.ofNullable(tariffLandedCost.getTariffRate()).ifPresent(tariff -> {
                    if (tariff.compareTo(Env.ZERO) != 0) {
                        orderLandedCost.setAmt(orderLineAmount.multiply(tariff.divide(Env.ONEHUNDRED)));
                    }
                });
                orderLandedCost.setProcessed(true);
                orderLandedCost.save();
                error.set(this.distributeLandedCost((MOrderLine)orderLine, orderLandedCost));
            });
        });
        return error.get();
    }

    private BigDecimal getOrderLineCost(MOrderLine orderLine) {
        AtomicReference<BigDecimal> orderLineAmount = new AtomicReference<BigDecimal>(Env.ZERO);
        orderLineAmount.set(orderLine.getLineNetAmt());
        new Query(orderLine.getCtx(), "C_OrderLandedCostAllocation", "C_OrderLine_ID = ? ", orderLine.get_TrxName()).setParameters(new Object[]{orderLine.get_ID()}).list().stream().forEach(allocation -> orderLineAmount.set(((BigDecimal)orderLineAmount.get()).add(allocation.getAmt())));
        return orderLineAmount.get();
    }

    private void reActivateCostAllocation(MOrder order) {
        Optional<List<MOrderLandedCost>> maybeOrderLandedCost = Optional.ofNullable(MOrderLandedCost.getOfOrder(order.getC_Order_ID(), order.get_TrxName()));
        maybeOrderLandedCost.ifPresent(orderLandedCostAllocation -> orderLandedCostAllocation.forEach(landedCost -> {
            if (landedCost.get_ValueAsInt("C_OrderLine_ID") > 0) {
                Arrays.asList(landedCost.getLines("")).stream().forEach(landedCostAllocation -> landedCostAllocation.deleteEx(true));
                landedCost.deleteEx(true);
            }
        }));
    }

    public String distributeLandedCost(MOrderLine orderLine, MOrderLandedCost orderLandedCost) {
        Object msgreturn;
        MOrderLandedCostAllocation[] lines = orderLandedCost.getLines("AND C_OrderLine_ID = " + orderLine.getC_OrderLine_ID());
        int precision = MPriceList.getPricePrecision((Properties)orderLine.getCtx(), (int)orderLine.getParent().getM_PriceList_ID());
        if (lines.length == 0) {
            ArrayList<MOrderLandedCostAllocation> list = new ArrayList<MOrderLandedCostAllocation>();
            if (orderLine.getM_Product_ID() > 0) {
                MOrderLandedCostAllocation allocation = new MOrderLandedCostAllocation(orderLine.getCtx(), 0, orderLine.get_TrxName());
                allocation.setC_OrderLandedCost_ID(orderLandedCost.getC_OrderLandedCost_ID());
                allocation.setC_OrderLine_ID(orderLine.getC_OrderLine_ID());
                allocation.setAD_Org_ID(orderLine.getAD_Org_ID());
                allocation.setAmt(BigDecimal.ZERO);
                allocation.setBase(BigDecimal.ZERO);
                allocation.setQty(BigDecimal.ZERO);
                allocation.saveEx();
                list.add(allocation);
            }
            lines = list.toArray(lines);
        }
        if (lines.length == 1) {
            BigDecimal base = orderLandedCost.getBase(orderLandedCost.getLandedCostDistribution(), orderLine);
            if (base.signum() == 0) {
                msgreturn = new StringBuilder("Total of Base values is 0 - ").append(orderLandedCost.getLandedCostDistribution());
                return ((StringBuilder)msgreturn).toString();
            }
            lines[0].setBase(base);
            lines[0].setQty(orderLine.getQtyOrdered());
            lines[0].setAmt(orderLandedCost.getAmt());
            lines[0].saveEx();
        } else if (lines.length > 1) {
            BigDecimal total = Env.ZERO;
            for (MOrderLandedCostAllocation mOrderLandedCostAllocation : lines) {
                total = total.add(orderLandedCost.getBase(orderLandedCost.getLandedCostDistribution(), orderLine));
            }
            if (total.signum() == 0) {
                msgreturn = new StringBuilder("Total of Base values is 0 - ").append(orderLandedCost.getLandedCostDistribution());
                return ((StringBuilder)msgreturn).toString();
            }
            for (MOrderLandedCostAllocation mOrderLandedCostAllocation : lines) {
                BigDecimal base = orderLandedCost.getBase(orderLandedCost.getLandedCostDistribution(), orderLine);
                mOrderLandedCostAllocation.setBase(base);
                mOrderLandedCostAllocation.setQty(orderLine.getQtyOrdered());
                if (base.signum() != 0) {
                    BigDecimal result = orderLandedCost.getAmt().multiply(base);
                    result = result.divide(total, MathContext.DECIMAL128);
                    mOrderLandedCostAllocation.setAmt(result.doubleValue(), precision);
                }
                mOrderLandedCostAllocation.saveEx();
            }
            this.allocateLandedCostRounding(lines, orderLandedCost);
        }
        return "";
    }

    private void allocateLandedCostRounding(MOrderLandedCostAllocation[] lines, MOrderLandedCost orderLandedCost) {
        MOrderLandedCostAllocation largestAmtAllocation = null;
        BigDecimal allocationAmt = Env.ZERO;
        for (MOrderLandedCostAllocation allocation : lines) {
            if (largestAmtAllocation == null || allocation.getAmt().compareTo(largestAmtAllocation.getAmt()) > 0) {
                largestAmtAllocation = allocation;
            }
            allocationAmt = allocationAmt.add(allocation.getAmt());
        }
        BigDecimal difference = orderLandedCost.getAmt().subtract(allocationAmt);
        if (difference.signum() != 0 && largestAmtAllocation != null) {
            largestAmtAllocation.setAmt(largestAmtAllocation.getAmt().add(difference));
            largestAmtAllocation.saveEx();
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Difference=" + difference + ", C_OrderLandedCostAllocation_ID=" + largestAmtAllocation.getC_OrderLandedCostAllocation_ID() + ", Amt" + largestAmtAllocation.getAmt());
            }
        }
    }
}

