/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pa.model.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.spin.pa.model.MOrderLandedCost;

public class EstimatedLandedCosts
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EstimatedLandedCosts.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        return null;
    }

    public String docValidate(PO entity, int timing) {
        String error;
        MOrder order;
        if (timing == 7 && entity.get_TableName().equals("C_Order") && !(order = (MOrder)entity).isSOTrx() && !Util.isEmpty((String)(error = this.landedCostAllocation(order)))) {
            return error;
        }
        if (timing == 4 && entity.get_TableName().equals("C_Order") && !(order = (MOrder)entity).isSOTrx()) {
            this.reActivateCostAllocation(order);
        }
        return null;
    }

    private String landedCostAllocation(MOrder order) {
        AtomicReference<String> error = new AtomicReference<String>("");
        Optional<List<MOrderLandedCost>> maybeOrderLandedCost = Optional.ofNullable(MOrderLandedCost.getOfOrder(order.getC_Order_ID(), order.get_TrxName()));
        maybeOrderLandedCost.ifPresent(orderLandedCostAllocation -> orderLandedCostAllocation.forEach(landedCost -> {
            if (Util.isEmpty((String)((String)error.get()))) {
                error.set(landedCost.distributeLandedCost());
                landedCost.setProcessed(true);
                landedCost.save();
            }
        }));
        return error.get();
    }

    private void reActivateCostAllocation(MOrder order) {
        Optional<List<MOrderLandedCost>> maybeOrderLandedCost = Optional.ofNullable(MOrderLandedCost.getOfOrder(order.getC_Order_ID(), order.get_TrxName()));
        maybeOrderLandedCost.ifPresent(orderLandedCostAllocation -> orderLandedCostAllocation.forEach(landedCost -> {
            landedCost.setProcessed(false);
            landedCost.save();
            Arrays.asList(landedCost.getLines("")).stream().forEach(landedCostAllocation -> landedCostAllocation.deleteEx(true));
        }));
    }
}

