/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pa.model.validator;

import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MLandedCost;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class CostAdjustment
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(CostAdjustment.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        return null;
    }

    public String docValidate(PO entity, int timing) {
        MInvoice invoice;
        if (timing == 7 && entity.get_TableName().equals("C_Invoice")) {
            invoice = (MInvoice)entity;
            AtomicReference<Boolean> hasLandedCosts = new AtomicReference<Boolean>(false);
            MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)invoice.getC_DocTypeTarget_ID());
            if (documentType.get_ValueAsBoolean("IsLandedCostAdjustment")) {
                Arrays.asList(invoice.getLines()).forEach(line -> {
                    if (!((Boolean)hasLandedCosts.get()).booleanValue()) {
                        hasLandedCosts.set(Optional.ofNullable(line.getLandedCost("")).orElse(new MLandedCost[0]).length > 0);
                    }
                });
                if (!hasLandedCosts.get().booleanValue()) {
                    throw new AdempiereException("@NotFound@ @C_LandedCost_ID@");
                }
            }
        }
        if (timing == 9 && entity.get_TableName().equals("C_Invoice")) {
            invoice = (MInvoice)entity;
            MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)invoice.getC_DocTypeTarget_ID());
            if (documentType.get_ValueAsBoolean("IsLandedCostAdjustment")) {
                this.createAllocation(invoice);
                invoice.setIsPaid(true);
            }
        }
        return null;
    }

    private void createAllocation(MInvoice invoice) {
        MDocType docTypeInvoice = MDocType.get((Properties)invoice.getCtx(), (int)invoice.getC_DocTypeTarget_ID());
        MAllocationHdr allocation = new MAllocationHdr(invoice.getCtx(), true, invoice.getDateAcct(), invoice.getC_Currency_ID(), invoice.getDescription(), invoice.get_TrxName());
        if (docTypeInvoice.get_ValueAsInt("AllocationDocTypeLandedCost_ID") > 0) {
            allocation.setC_DocType_ID(docTypeInvoice.get_ValueAsInt("AllocationDocTypeLandedCost_ID"));
        }
        allocation.saveEx();
        MAllocationLine allocationLine = new MAllocationLine(allocation, Env.ZERO, Env.ZERO, invoice.getGrandTotal(true).negate(), Env.ZERO);
        allocationLine.setDocInfo(invoice.getC_BPartner_ID(), invoice.getC_Order_ID(), invoice.get_ID());
        allocationLine.saveEx();
        allocation.processIt("CO");
        allocation.saveEx();
    }
}

