/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pa.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MConversionRate;
import org.compiere.model.MOrderLine;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.pa.model.X_C_OrderLandedCostAllocation;

public class MOrderLandedCostAllocation
extends X_C_OrderLandedCostAllocation
implements IDocumentLine {
    private static final long serialVersionUID = -3876186097908624583L;
    private MOrderLine orderLine = null;
    private static CCache<Integer, List<MOrderLandedCostAllocation>> s_cache = new CCache("C_OrderLandedCostAllocation", 20);

    public MOrderLandedCostAllocation(Properties ctx, int C_OrderLandedCostAllocation_ID, String trxName) {
        super(ctx, C_OrderLandedCostAllocation_ID, trxName);
    }

    public MOrderLandedCostAllocation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setAmt(double Amt, int precision) {
        BigDecimal bd = BigDecimal.valueOf(Amt);
        if (bd.scale() > precision) {
            bd = bd.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setAmt(bd);
    }

    public static MOrderLandedCostAllocation[] getOfOrderLine(int C_OrderLine_ID, String trxName) {
        AtomicReference<Object> retValue = new AtomicReference<Object>(s_cache.get((Object)C_OrderLine_ID));
        if (retValue.get() == null) {
            StringBuilder whereClause = new StringBuilder("C_OrderLine_ID").append("=?");
            Optional.ofNullable(new Query(Env.getCtx(), "C_OrderLandedCostAllocation", whereClause.toString(), trxName).setParameters(new Object[]{C_OrderLine_ID}).list()).ifPresent(orderLandedCostAllocation -> {
                retValue.set(orderLandedCostAllocation);
                s_cache.put((Object)C_OrderLine_ID, retValue.get());
            });
        }
        return ((List)retValue.get()).toArray(new MOrderLandedCostAllocation[((List)retValue.get()).size()]);
    }

    protected boolean beforeSave(boolean newRecord) {
        this.setProcessed(true);
        return true;
    }

    public int getC_ConversionType_ID() {
        return this.getOrderLine().getParent().getC_ConversionType_ID();
    }

    public int getC_Currency_ID() {
        return this.getOrderLine().getParent().getC_Currency_ID();
    }

    public int getC_DocType_ID() {
        return this.getOrderLine().getParent().getC_DocType_ID();
    }

    public Timestamp getDateAcct() {
        return this.getOrderLine().getParent().getDateAcct();
    }

    public String getDescription() {
        return this.getOrderLine().getDescription();
    }

    public int getM_AttributeSetInstanceTo_ID() {
        return this.getOrderLine().getM_AttributeSetInstance_ID();
    }

    public int getM_AttributeSetInstance_ID() {
        return this.getOrderLine().getM_AttributeSetInstance_ID();
    }

    public int getM_LocatorTo_ID() {
        return 0;
    }

    public int getM_Locator_ID() {
        return 0;
    }

    public int getM_Product_ID() {
        return this.getOrderLine().getM_Product_ID();
    }

    public BigDecimal getMovementQty() {
        return super.getQty();
    }

    public BigDecimal getPriceActual() {
        BigDecimal amount = Optional.ofNullable(MConversionRate.convertBase((Properties)this.getCtx(), (BigDecimal)this.getAmt(), (int)this.getC_Currency_ID(), (Timestamp)this.getDateAcct(), (int)this.getC_ConversionType_ID(), (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID()).divide(this.getQty(), this.getOrderLine().getParent().getM_PriceList().getPricePrecision(), 4)).orElse(Env.ZERO);
        return amount;
    }

    public BigDecimal getPriceActualCurrency() {
        return Optional.ofNullable(this.getAmt().divide(this.getQty(), this.getOrderLine().getParent().getM_PriceList().getPricePrecision(), 4)).orElse(Env.ZERO);
    }

    public IDocumentLine getReversalDocumentLine() {
        return null;
    }

    public int getReversalLine_ID() {
        return 0;
    }

    public boolean isReversalParent() {
        return false;
    }

    public boolean isSOTrx() {
        return false;
    }

    public void setM_AttributeSetInstance_ID(int arg0) {
    }

    public void setM_Locator_ID(int arg0) {
    }

    public MOrderLine getOrderLine() {
        this.orderLine = Optional.ofNullable(this.orderLine).orElse((MOrderLine)this.getC_OrderLine());
        return this.orderLine;
    }
}

