/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pa.model;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.pa.model.MOrderLandedCostAllocation;
import org.spin.pa.model.X_C_OrderLandedCost;

public class MOrderLandedCost
extends X_C_OrderLandedCost {
    private static final long serialVersionUID = 2629138678703667123L;

    public MOrderLandedCost(Properties ctx, int C_OrderLandedCost_ID, String trxName) {
        super(ctx, C_OrderLandedCost_ID, trxName);
    }

    public MOrderLandedCost(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static List<MOrderLandedCost> getOfOrder(int C_Order_ID, String trxName) {
        StringBuilder whereClause = new StringBuilder("C_Order_ID").append("=?");
        return new Query(Env.getCtx(), "C_OrderLandedCost", whereClause.toString(), trxName).setParameters(new Object[]{C_Order_ID}).list();
    }

    public MOrderLandedCostAllocation[] getLines(String whereClause) {
        StringBuilder whereClauseFinal = new StringBuilder("C_OrderLandedCost_ID").append("=?");
        if (!Util.isEmpty((String)whereClause)) {
            whereClauseFinal.append(" ").append(whereClause);
        }
        List list = new Query(this.getCtx(), "C_OrderLandedCostAllocation", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.getC_OrderLandedCost_ID()}).list();
        return list.toArray(new MOrderLandedCostAllocation[list.size()]);
    }

    public String distributeLandedCost() {
        MOrderLine[] orderLines;
        MOrderLandedCostAllocation[] lines = this.getLines("");
        MOrder order = (MOrder)this.getC_Order();
        int precision = MPriceList.getPricePrecision((Properties)order.getCtx(), (int)order.getM_PriceList_ID());
        if (lines.length == 0 && (orderLines = order.getLines()).length > 0) {
            ArrayList<MOrderLandedCostAllocation> list = new ArrayList<MOrderLandedCostAllocation>();
            MOrderLine[] mOrderLineArray = orderLines;
            int n = mOrderLineArray.length;
            for (int i = 0; i < n; ++i) {
                MOrderLine line = mOrderLineArray[i];
                if (line.getM_Product_ID() <= 0) continue;
                MOrderLandedCostAllocation allocation = new MOrderLandedCostAllocation(this.getCtx(), 0, this.get_TrxName());
                allocation.setC_OrderLandedCost_ID(this.getC_OrderLandedCost_ID());
                allocation.setC_OrderLine_ID(line.getC_OrderLine_ID());
                allocation.setAD_Org_ID(this.getAD_Org_ID());
                allocation.setAmt(BigDecimal.ZERO);
                allocation.setBase(BigDecimal.ZERO);
                allocation.setQty(BigDecimal.ZERO);
                allocation.saveEx();
                list.add(allocation);
            }
            if (list.size() > 0) {
                lines = list.toArray(lines);
            }
        }
        if (lines.length == 1) {
            MOrderLine orderLine = (MOrderLine)lines[0].getC_OrderLine();
            BigDecimal base = this.getBase(this.getLandedCostDistribution(), orderLine);
            if (base.signum() == 0) {
                StringBuilder msgreturn = new StringBuilder("Total of Base values is 0 - ").append(this.getLandedCostDistribution());
                return msgreturn.toString();
            }
            lines[0].setBase(base);
            lines[0].setQty(orderLine.getQtyOrdered());
            lines[0].setAmt(this.getAmt());
            lines[0].saveEx();
        } else if (lines.length > 1) {
            MOrderLine orderLine;
            BigDecimal total = Env.ZERO;
            for (MOrderLandedCostAllocation allocation : lines) {
                orderLine = (MOrderLine)allocation.getC_OrderLine();
                total = total.add(this.getBase(this.getLandedCostDistribution(), orderLine));
            }
            if (total.signum() == 0) {
                StringBuilder msgreturn = new StringBuilder("Total of Base values is 0 - ").append(this.getLandedCostDistribution());
                return msgreturn.toString();
            }
            for (MOrderLandedCostAllocation allocation : lines) {
                orderLine = (MOrderLine)allocation.getC_OrderLine();
                BigDecimal base = this.getBase(this.getLandedCostDistribution(), orderLine);
                allocation.setBase(base);
                allocation.setQty(orderLine.getQtyOrdered());
                if (base.signum() != 0) {
                    BigDecimal result = this.getAmt().multiply(base);
                    result = result.divide(total, MathContext.DECIMAL128);
                    allocation.setAmt(result.doubleValue(), precision);
                }
                allocation.saveEx();
            }
            this.allocateLandedCostRounding(lines);
        }
        return "";
    }

    private void allocateLandedCostRounding(MOrderLandedCostAllocation[] lines) {
        MOrderLandedCostAllocation largestAmtAllocation = null;
        BigDecimal allocationAmt = Env.ZERO;
        for (MOrderLandedCostAllocation allocation : lines) {
            if (largestAmtAllocation == null || allocation.getAmt().compareTo(largestAmtAllocation.getAmt()) > 0) {
                largestAmtAllocation = allocation;
            }
            allocationAmt = allocationAmt.add(allocation.getAmt());
        }
        BigDecimal difference = this.getAmt().subtract(allocationAmt);
        if (difference.signum() != 0 && largestAmtAllocation != null) {
            largestAmtAllocation.setAmt(largestAmtAllocation.getAmt().add(difference));
            largestAmtAllocation.saveEx();
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Difference=" + difference + ", C_OrderLandedCostAllocation_ID=" + largestAmtAllocation.getC_OrderLandedCostAllocation_ID() + ", Amt" + largestAmtAllocation.getAmt());
            }
        }
    }

    public BigDecimal getBase(String CostDistribution, MOrderLine orderLine) {
        if ("C".equals(CostDistribution)) {
            return orderLine.getQtyOrdered().multiply(orderLine.getPriceActual());
        }
        if ("L".equals(CostDistribution)) {
            return Env.ONE;
        }
        if ("Q".equals(CostDistribution)) {
            return orderLine.getQtyOrdered();
        }
        if ("V".equals(CostDistribution)) {
            MProduct product = orderLine.getProduct();
            if (product == null) {
                this.log.severe("No Product");
                return Env.ZERO;
            }
            return orderLine.getQtyOrdered().multiply(product.getVolume());
        }
        if ("W".equals(CostDistribution)) {
            MProduct product = orderLine.getProduct();
            if (product == null) {
                this.log.severe("No Product");
                return Env.ZERO;
            }
            return orderLine.getQtyOrdered().multiply(product.getWeight());
        }
        this.log.severe("Invalid Criteria: " + CostDistribution);
        return Env.ZERO;
    }
}

