/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.pa.util.PerformanceAnalysisUtil;

public class Doc_NotPost
extends Doc {
    private static Map<String, MTable> s_cache = Collections.synchronizedMap(new CCache("AD_Table", 20));

    public Doc_NotPost(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, Doc_NotPost.getDocumentClass(rs), rs, null, trxName);
        this.setDateAcctColumn(rs);
    }

    private static Class<?> getDocumentClass(ResultSet rs) {
        AtomicReference<Object> docClass = new AtomicReference<Object>(null);
        Optional<ResultSet> maybeResultSet = Optional.ofNullable(rs);
        maybeResultSet.ifPresent(resultSet -> {
            try {
                MTable table = Doc_NotPost.getTable(resultSet.getMetaData().getTableName(1));
                docClass.set(MTable.getClass((String)table.getTableName()));
            }
            catch (SQLException e) {
                s_log.severe(e.getMessage());
            }
        });
        return docClass.get();
    }

    private void setDateAcctColumn(ResultSet rs) {
        AtomicReference<Object> dateAcctValue = new AtomicReference<Object>(null);
        Arrays.asList(PerformanceAnalysisUtil.DateAcct_ColumnNames).stream().forEach(dateAcct -> {
            try {
                if (rs.findColumn((String)dateAcct) > 0 && dateAcctValue.get() == null) {
                    dateAcctValue.set(rs.getTimestamp((String)dateAcct));
                    this.setDateAcct((Timestamp)dateAcctValue.get());
                    this.setDateDoc((Timestamp)dateAcctValue.get());
                }
            }
            catch (SQLException e) {
                s_log.warning(e.getMessage());
            }
        });
    }

    protected String loadDocumentDetails() {
        return null;
    }

    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact((Doc)this, as, "A");
        facts.add(fact);
        return facts;
    }

    private static MTable getTable(String tableName) {
        AtomicReference<Object> tableResult = new AtomicReference<Object>(null);
        Optional<String> maybeTableName = Optional.ofNullable(tableName);
        maybeTableName.ifPresent(tablePO -> {
            Optional<MTable> table = Optional.ofNullable(s_cache.get(tablePO));
            tableResult.set(table.orElse((MTable)new Query(Env.getCtx(), "AD_Table", "UPPER(TableName) = ?", null).setParameters(new Object[]{tablePO.toUpperCase()}).first()));
        });
        return tableResult.get();
    }
}

