/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.X_C_LandedCostAllocation;
import org.compiere.util.Env;

public class Doc_CostAdjustment
extends Doc {
    public Doc_CostAdjustment(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MInvoice.class, rs, null, trxName);
    }

    protected String loadDocumentDetails() {
        MInvoice invoice = (MInvoice)this.getPO();
        this.setDateDoc(invoice.getDateInvoiced());
        this.setIsTaxIncluded(invoice.isTaxIncluded());
        this.setAmount(0, invoice.getGrandTotal());
        this.setAmount(1, invoice.getTotalLines());
        this.setAmount(2, invoice.getChargeAmt());
        this.p_lines = this.loadLines(invoice);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MInvoice invoice) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MInvoiceLine[] lines = invoice.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MInvoiceLine line = lines[i];
            if (line.isDescription()) continue;
            DocLine docLine = new DocLine((PO)line, (Doc)this);
            BigDecimal Qty = line.getQtyInvoiced();
            boolean cm = this.getDocumentType().equals("ARC") || this.getDocumentType().equals("APC");
            docLine.setQty(cm ? Qty.negate() : Qty, invoice.isSOTrx());
            BigDecimal LineNetAmt = line.getLineNetAmt();
            BigDecimal PriceList = line.getPriceList();
            docLine.setAmount(LineNetAmt, PriceList, Qty);
            this.log.fine(docLine.toString());
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuffer sb = new StringBuffer(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        retValue = retValue.subtract(this.getAmount(2));
        sb.append("-").append(this.getAmount(2));
        for (int i = 0; i < this.p_lines.length; ++i) {
            retValue = retValue.subtract(this.p_lines[i].getAmtSource());
            sb.append("-").append(this.p_lines[i].getAmtSource());
        }
        sb.append("]");
        this.log.fine(this.toString() + " Balance=" + retValue + sb.toString());
        return retValue;
    }

    public ArrayList<Fact> createFacts(MAcctSchema acctSchema) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact((Doc)this, acctSchema, "A");
        if (!acctSchema.isAccrual()) {
            return facts;
        }
        if (this.getDocumentType().equals("API")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, acctSchema), this.getC_Currency_ID(), this.getAmount(2), null);
            for (int i = 0; i < this.p_lines.length; ++i) {
                DocLine line = this.p_lines[i];
                boolean landedCost = this.landedCost(acctSchema, fact, line, true);
                if (!landedCost) continue;
                MAccount expense = line.getAccount(2, acctSchema);
                if (line.isItem()) {
                    expense = line.getAccount(10, acctSchema);
                }
                BigDecimal amt = line.getAmtSource();
                fact.createLine(line, expense, this.getC_Currency_ID(), null, amt);
                if (line.isItem()) continue;
                grossAmt = grossAmt.subtract(amt);
                serviceAmt = serviceAmt.add(amt);
            }
            FactLine[] fLines = fact.getLines();
            for (int i = 0; i < fLines.length; ++i) {
                if (fLines[i] == null) continue;
                fLines[i].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                fLines[i].setLocationFromOrg(fLines[i].getAD_Org_ID(), false);
            }
        } else if (this.getDocumentType().equals("APC")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, acctSchema), this.getC_Currency_ID(), null, this.getAmount(2));
            for (int i = 0; i < this.p_lines.length; ++i) {
                DocLine line = this.p_lines[i];
                boolean landedCost = this.landedCost(acctSchema, fact, line, false);
                if (!landedCost) continue;
                MAccount expense = line.getAccount(2, acctSchema);
                if (line.isItem()) {
                    expense = line.getAccount(10, acctSchema);
                }
                BigDecimal amt = line.getAmtSource();
                fact.createLine(line, expense, this.getC_Currency_ID(), amt, null);
                if (line.isItem()) continue;
                grossAmt = grossAmt.subtract(amt);
                serviceAmt = serviceAmt.add(amt);
            }
            FactLine[] fLines = fact.getLines();
            for (int i = 0; i < fLines.length; ++i) {
                if (fLines[i] == null) continue;
                fLines[i].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                fLines[i].setLocationFromOrg(fLines[i].getAD_Org_ID(), false);
            }
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            fact = null;
        }
        facts.add(fact);
        return facts;
    }

    private boolean landedCost(MAcctSchema as, Fact fact, DocLine line, boolean isDebit) {
        int invoiceLineId = line.get_ID();
        MLandedCostAllocation[] landedCostAllocations = MLandedCostAllocation.getOfInvoiceLine((Properties)this.getCtx(), (int)invoiceLineId, (String)this.getTrxName());
        if (landedCostAllocations.length == 0) {
            return false;
        }
        BigDecimal totalBase = Arrays.stream(landedCostAllocations).map(X_C_LandedCostAllocation::getBase).reduce(BigDecimal.ZERO, BigDecimal::add);
        MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), invoiceLineId, this.getTrxName());
        Arrays.stream(landedCostAllocations).filter(landedCostAllocation -> landedCostAllocation.getBase().signum() != 0).forEach(landedCostAllocation -> {
            BigDecimal percent = landedCostAllocation.getBase().divide(totalBase, 4);
            String desc = invoiceLine.getDescription();
            desc = desc == null ? percent + "%" : desc + " - " + percent + "%";
            if (line.getDescription() != null) {
                desc = desc + " - " + line.getDescription();
            }
            ProductCost productCost = new ProductCost(Env.getCtx(), landedCostAllocation.getM_Product_ID(), landedCostAllocation.getM_AttributeSetInstance_ID(), this.getTrxName());
            BigDecimal debitAmount = BigDecimal.ZERO;
            BigDecimal creditAmount = BigDecimal.ZERO;
            FactLine factLine = null;
            MCostType costType = MCostType.get((MAcctSchema)as, (int)landedCostAllocation.getM_Product_ID(), (int)landedCostAllocation.getAD_Org_ID());
            if ("I".equals(costType.getCostingMethod())) {
                BigDecimal assetAmount = Optional.ofNullable(MCostDetail.getByDocLineLandedCost((MLandedCostAllocation)landedCostAllocation, (int)as.getC_AcctSchema_ID(), (int)costType.get_ID())).orElseGet(() -> BigDecimal.ZERO);
                if (assetAmount.signum() != 0) {
                    if (isDebit) {
                        debitAmount = assetAmount;
                    } else {
                        creditAmount = assetAmount.negate();
                    }
                    factLine = fact.createLine(line, productCost.getAccount(3, as), as.getC_Currency_ID(), debitAmount, creditAmount);
                    factLine.setDescription(desc + " " + landedCostAllocation.getM_CostElement().getName());
                    factLine.setM_Product_ID(landedCostAllocation.getM_Product_ID());
                }
                BigDecimal costAllocation = landedCostAllocation.getPriceActual().multiply(landedCostAllocation.getQty());
                BigDecimal costAdjustment = costAllocation.subtract(assetAmount);
                this.setIsMultiCurrency(landedCostAllocation.getC_Currency_ID() != as.getC_Currency_ID());
                if (costAdjustment.signum() != 0) {
                    if (isDebit) {
                        debitAmount = costAdjustment;
                    } else {
                        creditAmount = costAdjustment;
                    }
                    factLine = fact.createLine(line, productCost.getAccount(3, as), this.getC_Currency_ID(), debitAmount, creditAmount);
                }
            } else {
                factLine = fact.createLine(line, productCost.getAccount(3, as), this.getC_Currency_ID(), debitAmount, creditAmount);
            }
            factLine.setDescription(desc + " " + landedCostAllocation.getM_CostElement().getName());
            factLine.setM_Product_ID(landedCostAllocation.getM_Product_ID());
        });
        this.log.config("Created #" + landedCostAllocations.length);
        return true;
    }
}

