/*
 * Decompiled with CFR 0.152.
 */
package org.spin.is.util;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MStore;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.model.X_W_Basket;

public class InternalStoreUtil {
    public static final String COLUMNNAME_IsStoreShowConvertedAmount = "IsStoreShowConvertedAmount";
    public static final String COLUMNNAME_StoreConversionType_ID = "StoreConversionType_ID";
    public static final String COLUMNNAME_StoreDisplayCurrency_ID = "StoreDisplayCurrency_ID";

    public static void setDefaultValuesFromStore(MOrder order) {
        MBPartner seller;
        if (order.get_ValueAsInt("W_Store_ID") <= 0) {
            return;
        }
        MStore store = MStore.get((Properties)order.getCtx(), (int)order.get_ValueAsInt("W_Store_ID"));
        order.setAD_Org_ID(store.getAD_Org_ID());
        MUser user = MUser.get((Properties)order.getCtx(), (int)order.getAD_User_ID());
        if (user.getC_BPartner_ID() > 0 && (seller = (MBPartner)user.getC_BPartner()).isSalesRep()) {
            order.setSalesRep_ID(user.getAD_User_ID());
        }
        InternalStoreUtil.validateSeller(order);
    }

    public static void validateSeller(X_W_Basket basket) {
        if (basket.getAD_User_ID() <= 0) {
            throw new AdempiereException("@AD_User_ID@ @NotFound@");
        }
        boolean isAllowed = InternalStoreUtil.isUserAllowed(basket.getCtx(), basket.getAD_User_ID(), basket.get_TrxName());
        if (!isAllowed) {
            throw new AdempiereException("@AD_User_ID@ / @W_Store_ID@ @NotFound@");
        }
    }

    public static void validateSeller(MOrder order) {
        if (order.getAD_User_ID() <= 0) {
            throw new AdempiereException("@AD_User_ID@ @NotFound@");
        }
        boolean isAllowed = InternalStoreUtil.isUserAllowed(order.getCtx(), order.getAD_User_ID(), order.get_TrxName());
        if (!isAllowed) {
            throw new AdempiereException("@AD_User_ID@ / @W_Store_ID@ @NotFound@");
        }
    }

    public static boolean isUserAllowed(Properties context, int userId, String transactionName) {
        return new Query(context, "W_StoreSellerAllocated", "SalesRep_ID = ?", transactionName).setParameters(new Object[]{userId}).setOnlyActiveRecords(true).setClient_ID().firstId() > 0;
    }
}

