/*
 * Decompiled with CFR 0.152.
 */
package org.spin.is.model.validator;

import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_W_Basket;
import org.compiere.util.CLogger;
import org.spin.is.util.InternalStoreUtil;

public class DefaultStoreValues
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(DefaultStoreValues.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addModelChange("W_Basket", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        if (type == 1 || type == 2) {
            if (entity.get_TableName().equals("C_Order")) {
                if (entity.is_new() || entity.is_ValueChanged("W_Store_ID")) {
                    InternalStoreUtil.setDefaultValuesFromStore((MOrder)entity);
                }
            } else if (entity.get_TableName().equals("W_Basket") && entity.is_new()) {
                InternalStoreUtil.validateSeller((X_W_Basket)entity);
            }
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        if (timing == 7) {
            // empty if block
        }
        return null;
    }
}

