/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.objects.User;

public class MessageEntity
implements BotApiObject {
    private static final String TYPE_FIELD = "type";
    private static final String OFFSET_FIELD = "offset";
    private static final String LENGTH_FIELD = "length";
    private static final String URL_FIELD = "url";
    private static final String USER_FIELD = "user";
    private static final String LANGUAGE_FIELD = "language";
    @JsonProperty(value="type")
    @NonNull
    private String type;
    @JsonProperty(value="offset")
    @NonNull
    private Integer offset;
    @JsonProperty(value="length")
    @NonNull
    private Integer length;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="user")
    private User user;
    @JsonProperty(value="language")
    private String language;
    @JsonIgnore
    private String text;

    protected void computeText(String message) {
        if (message != null) {
            this.text = message.substring(this.offset, this.offset + this.length);
        }
    }

    public static MessageEntityBuilder builder() {
        return new MessageEntityBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageEntity)) {
            return false;
        }
        MessageEntity other = (MessageEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Integer this$length = this.getLength();
        Integer other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Integer $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public Integer getOffset() {
        return this.offset;
    }

    @NonNull
    public Integer getLength() {
        return this.length;
    }

    public String getUrl() {
        return this.url;
    }

    public User getUser() {
        return this.user;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getText() {
        return this.text;
    }

    @JsonProperty(value="type")
    public void setType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="offset")
    public void setOffset(@NonNull Integer offset) {
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        this.offset = offset;
    }

    @JsonProperty(value="length")
    public void setLength(@NonNull Integer length) {
        if (length == null) {
            throw new NullPointerException("length is marked non-null but is null");
        }
        this.length = length;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="user")
    public void setUser(User user) {
        this.user = user;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    @JsonIgnore
    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return "MessageEntity(type=" + this.getType() + ", offset=" + this.getOffset() + ", length=" + this.getLength() + ", url=" + this.getUrl() + ", user=" + this.getUser() + ", language=" + this.getLanguage() + ", text=" + this.getText() + ")";
    }

    public MessageEntity(@NonNull String type, @NonNull Integer offset, @NonNull Integer length) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        if (length == null) {
            throw new NullPointerException("length is marked non-null but is null");
        }
        this.type = type;
        this.offset = offset;
        this.length = length;
    }

    public MessageEntity() {
    }

    public MessageEntity(@NonNull String type, @NonNull Integer offset, @NonNull Integer length, String url, User user, String language, String text) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        if (length == null) {
            throw new NullPointerException("length is marked non-null but is null");
        }
        this.type = type;
        this.offset = offset;
        this.length = length;
        this.url = url;
        this.user = user;
        this.language = language;
        this.text = text;
    }

    public static class MessageEntityBuilder {
        private String type;
        private Integer offset;
        private Integer length;
        private String url;
        private User user;
        private String language;
        private String text;

        MessageEntityBuilder() {
        }

        @JsonProperty(value="type")
        public MessageEntityBuilder type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @JsonProperty(value="offset")
        public MessageEntityBuilder offset(@NonNull Integer offset) {
            if (offset == null) {
                throw new NullPointerException("offset is marked non-null but is null");
            }
            this.offset = offset;
            return this;
        }

        @JsonProperty(value="length")
        public MessageEntityBuilder length(@NonNull Integer length) {
            if (length == null) {
                throw new NullPointerException("length is marked non-null but is null");
            }
            this.length = length;
            return this;
        }

        @JsonProperty(value="url")
        public MessageEntityBuilder url(String url) {
            this.url = url;
            return this;
        }

        @JsonProperty(value="user")
        public MessageEntityBuilder user(User user) {
            this.user = user;
            return this;
        }

        @JsonProperty(value="language")
        public MessageEntityBuilder language(String language) {
            this.language = language;
            return this;
        }

        @JsonIgnore
        public MessageEntityBuilder text(String text) {
            this.text = text;
            return this;
        }

        public MessageEntity build() {
            return new MessageEntity(this.type, this.offset, this.length, this.url, this.user, this.language, this.text);
        }

        public String toString() {
            return "MessageEntity.MessageEntityBuilder(type=" + this.type + ", offset=" + this.offset + ", length=" + this.length + ", url=" + this.url + ", user=" + this.user + ", language=" + this.language + ", text=" + this.text + ")";
        }
    }
}

