/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetChatAdministratorCustomTitle
extends BotApiMethod<Boolean> {
    public static final String PATH = "setChatAdministratorCustomTitle";
    private static final String CHATID_FIELD = "chat_id";
    private static final String USERID_FIELD = "user_id";
    private static final String CUSTOMTITLE_FIELD = "custom_title";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;
    @JsonProperty(value="custom_title")
    @NonNull
    private String customTitle;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error setting chat description", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.userId == null || this.userId == 0L) {
            throw new TelegramApiValidationException("UserId can't be empty", this);
        }
        if (this.customTitle == null) {
            throw new TelegramApiValidationException("CustomTitle can't be null", this);
        }
    }

    public static SetChatAdministratorCustomTitleBuilder builder() {
        return new SetChatAdministratorCustomTitleBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetChatAdministratorCustomTitle)) {
            return false;
        }
        SetChatAdministratorCustomTitle other = (SetChatAdministratorCustomTitle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$customTitle = this.getCustomTitle();
        String other$customTitle = other.getCustomTitle();
        return !(this$customTitle == null ? other$customTitle != null : !this$customTitle.equals(other$customTitle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetChatAdministratorCustomTitle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $customTitle = this.getCustomTitle();
        result = result * 59 + ($customTitle == null ? 43 : $customTitle.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public Long getUserId() {
        return this.userId;
    }

    @NonNull
    public String getCustomTitle() {
        return this.customTitle;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="user_id")
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="custom_title")
    public void setCustomTitle(@NonNull String customTitle) {
        if (customTitle == null) {
            throw new NullPointerException("customTitle is marked non-null but is null");
        }
        this.customTitle = customTitle;
    }

    public String toString() {
        return "SetChatAdministratorCustomTitle(chatId=" + this.getChatId() + ", userId=" + this.getUserId() + ", customTitle=" + this.getCustomTitle() + ")";
    }

    public SetChatAdministratorCustomTitle() {
    }

    public SetChatAdministratorCustomTitle(@NonNull String chatId, @NonNull Long userId, @NonNull String customTitle) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (customTitle == null) {
            throw new NullPointerException("customTitle is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
        this.customTitle = customTitle;
    }

    public static class SetChatAdministratorCustomTitleBuilder {
        private String chatId;
        private Long userId;
        private String customTitle;

        SetChatAdministratorCustomTitleBuilder() {
        }

        @JsonProperty(value="chat_id")
        public SetChatAdministratorCustomTitleBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="user_id")
        public SetChatAdministratorCustomTitleBuilder userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="custom_title")
        public SetChatAdministratorCustomTitleBuilder customTitle(@NonNull String customTitle) {
            if (customTitle == null) {
                throw new NullPointerException("customTitle is marked non-null but is null");
            }
            this.customTitle = customTitle;
            return this;
        }

        public SetChatAdministratorCustomTitle build() {
            return new SetChatAdministratorCustomTitle(this.chatId, this.userId, this.customTitle);
        }

        public String toString() {
            return "SetChatAdministratorCustomTitle.SetChatAdministratorCustomTitleBuilder(chatId=" + this.chatId + ", userId=" + this.userId + ", customTitle=" + this.customTitle + ")";
        }
    }
}

