/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pc.model.validator;

import java.sql.Timestamp;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MConversionType;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class InvoiceExpirationValidation
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(InvoiceExpirationValidation.class);
    private int clientId = -1;
    private static CCache<String, Timestamp> s_cache = new CCache("PaymentTerm", 20, 2);

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Payment", (ModelValidator)this);
        engine.addModelChange("C_AllocationLine", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        Optional<PO> maybeDocument = Optional.ofNullable(entity);
        maybeDocument.ifPresent(document -> {
            MPayment payment;
            MInvoice invoice;
            if (document.get_TableName().equals("C_Payment")) {
                MPayment payment2;
                MInvoice invoice2;
                if ((type == 1 || type == 2) && document.get_ValueAsInt("C_Invoice_ID") > 0 && (invoice2 = MInvoice.get((Properties)(payment2 = (MPayment)document).getCtx(), (int)payment2.getC_Invoice_ID())).isSOTrx()) {
                    MConversionType paymentConversionType = (MConversionType)payment2.getC_ConversionType();
                    MConversionType invoiceConversionType = (MConversionType)invoice2.getC_ConversionType();
                    if (payment2.getDateTrx().after(this.getDueDate(invoice2.getC_PaymentTerm_ID(), invoice2.getDateInvoiced())) && paymentConversionType.get_ValueAsInt("ParentConversionType_ID") > 0) {
                        MConversionType validConversionType = new MConversionType(payment2.getCtx(), invoiceConversionType.get_ValueAsInt("ParentConversionType_ID"), payment2.get_TrxName());
                        throw new AdempiereException("@Invalid@ @C_ConversionType_ID@ " + invoiceConversionType.getName() + "\n @C_ConversionType_ID@ -> " + validConversionType.getName());
                    }
                }
            } else if (document.get_TableName().equals("C_AllocationLine") && (type == 1 || type == 2) && document.get_ValueAsInt("C_Invoice_ID") > 0 && document.get_ValueAsInt("C_Payment_ID") > 0 && (invoice = MInvoice.get((Properties)(payment = new MPayment(document.getCtx(), document.get_ValueAsInt("C_Payment_ID"), document.get_TrxName())).getCtx(), (int)document.get_ValueAsInt("C_Invoice_ID"))).isSOTrx()) {
                MConversionType paymentConversionType = (MConversionType)payment.getC_ConversionType();
                MConversionType invoiceConversionType = (MConversionType)invoice.getC_ConversionType();
                if (payment.getDateTrx().after(this.getDueDate(invoice.getC_PaymentTerm_ID(), invoice.getDateInvoiced())) && paymentConversionType.get_ValueAsInt("ParentConversionType_ID") > 0) {
                    MConversionType validConversionType = new MConversionType(payment.getCtx(), invoiceConversionType.get_ValueAsInt("ParentConversionType_ID"), payment.get_TrxName());
                    throw new AdempiereException("@Invalid@ @C_ConversionType_ID@ " + invoiceConversionType.getName() + "\n @C_ConversionType_ID@ -> " + validConversionType.getName());
                }
            }
        });
        return null;
    }

    public String docValidate(PO entity, int timing) {
        return null;
    }

    private Timestamp getDueDate(int paymentTermId, Timestamp dateDoc) {
        String key = String.valueOf(paymentTermId).concat(dateDoc.toString());
        Timestamp resultValue = (Timestamp)s_cache.get((Object)key);
        if (resultValue == null) {
            resultValue = DB.getSQLValueTS(null, (String)"SELECT PaymentTermDueDate(?, ?)", (Object[])new Object[]{paymentTermId, dateDoc});
        }
        s_cache.put((Object)key, (Object)resultValue);
        return resultValue;
    }
}

