/*
 * Decompiled with CFR 0.152.
 */
package org.spin.wms.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementConfirm;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionBatch;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MWMInOutBound;

public class ValidateProduct {
    public static final String COLUMNNAME_IsBlockedForTakingInventory = "IsBlockedForTakingInventory";
    public static final String MESSAGE_ProductBlockedForTakingInventory = "ProductBlockedForTakingInventory";
    private static List<String> documentsForValidateProduct = Arrays.asList("C_Order", "M_InOut", "M_InOutConfirm", "DD_Order", "M_Movement", "M_MovementConfirm", "M_ProductionBatch", "M_Production", "M_Inventory", "WM_InOutBound");
    private static List<String> tablesForValidateProduct = Arrays.asList("C_OrderLine", "M_InOutLine", "M_InOutLineConfirm", "M_MovementLine", "M_MovementLineConfirm", "M_ProductionBatchLine", "M_ProductionLine", "M_InventoryLine", "WM_InOutBoundLine");
    private static List<String> columnsForValidateProduct = Arrays.asList("M_Product_ID");

    public static void loadTablesForValidateProduct(ModelValidationEngine engine, ModelValidator listener) {
        documentsForValidateProduct.forEach(tableName -> engine.addDocValidate(tableName, listener));
        tablesForValidateProduct.forEach(tableName -> engine.addModelChange(tableName, listener));
    }

    public static boolean isValidTable(String tableName) {
        return tablesForValidateProduct.stream().filter(tableNameToFind -> tableNameToFind.equals(tableName)).findAny().isPresent();
    }

    public static boolean isValidDocument(String tableName) {
        return documentsForValidateProduct.stream().filter(tableNameToFind -> tableNameToFind.equals(tableName)).findAny().isPresent();
    }

    public static void validateProduct(PO entity) {
        columnsForValidateProduct.stream().filter(columnName -> entity.is_ValueChanged(columnName) && entity.get_ValueAsInt(columnName) > 0).forEach(columnName -> {
            try {
                ValidateProduct.validate(entity, entity.get_ValueAsInt(columnName));
            }
            catch (Exception e) {
                throw new AdempiereException("@ProductBlockedForTakingInventory@" + Env.NL + e.getLocalizedMessage());
            }
        });
    }

    private static void validate(PO entity, int productId) {
        MProduct product = new MProduct(entity.getCtx(), productId, entity.get_TrxName());
        if (product.get_ValueAsBoolean(COLUMNNAME_IsBlockedForTakingInventory)) {
            if (ValidateProduct.existsPhysicalInventoryInProgress(entity.getCtx(), productId, entity, entity.get_TrxName())) {
                throw new AdempiereException("@M_Product_ID@: " + product.getValue() + " - " + product.getName());
            }
            ValidateProduct.markProductFromInventoryLine(entity, product);
        } else {
            ValidateProduct.markProductFromInventoryLine(entity, product);
        }
    }

    public static void validateProductFromDocument(PO entity) {
        if (entity.get_TableName().equals("C_Order")) {
            MOrder order = (MOrder)entity;
            if (order.isSOTrx() && !order.isReturnOrder()) {
                StringBuffer errorMessage = new StringBuffer();
                Arrays.asList(order.getLines()).stream().filter(orderLine -> {
                    if (orderLine.getM_Product_ID() <= 0) {
                        return false;
                    }
                    MProduct product = MProduct.get((Properties)entity.getCtx(), (int)orderLine.getM_Product_ID());
                    if (!product.isStocked()) {
                        return false;
                    }
                    return Optional.ofNullable(orderLine.getQtyOrdered()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0;
                }).forEach(orderLine -> {
                    try {
                        ValidateProduct.validate((PO)orderLine, orderLine.getM_Product_ID());
                    }
                    catch (Exception e) {
                        if (errorMessage.length() > 0) {
                            errorMessage.append(Env.NL);
                        }
                        errorMessage.append(e.getLocalizedMessage());
                    }
                });
                if (errorMessage.length() > 0) {
                    throw new AdempiereException("@ProductBlockedForTakingInventory@" + Env.NL + errorMessage.toString());
                }
            }
        } else if (entity.get_TableName().equals("DD_Order")) {
            MDDOrder order = (MDDOrder)entity;
            StringBuffer errorMessage = new StringBuffer();
            order.getLines().stream().filter(orderLine -> {
                if (orderLine.getM_Product_ID() <= 0) {
                    return false;
                }
                MProduct product = MProduct.get((Properties)entity.getCtx(), (int)orderLine.getM_Product_ID());
                if (!product.isStocked()) {
                    return false;
                }
                return Optional.ofNullable(orderLine.getQtyOrdered()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0;
            }).forEach(orderLine -> {
                try {
                    ValidateProduct.validate((PO)orderLine, orderLine.getM_Product_ID());
                }
                catch (Exception e) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append(Env.NL);
                    }
                    errorMessage.append(e.getLocalizedMessage());
                }
            });
            if (errorMessage.length() > 0) {
                throw new AdempiereException("@ProductBlockedForTakingInventory@" + Env.NL + errorMessage.toString());
            }
        } else if (entity.get_TableName().equals("M_InOut")) {
            MInOut inOut = (MInOut)entity;
            StringBuffer errorMessage = new StringBuffer();
            Arrays.asList(inOut.getLines()).stream().filter(orderLine -> {
                if (orderLine.getM_Product_ID() <= 0) {
                    return false;
                }
                MProduct product = MProduct.get((Properties)entity.getCtx(), (int)orderLine.getM_Product_ID());
                if (!product.isStocked()) {
                    return false;
                }
                return Optional.ofNullable(orderLine.getMovementQty()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0;
            }).forEach(inOutLine -> {
                try {
                    ValidateProduct.validate((PO)inOutLine, inOutLine.getM_Product_ID());
                }
                catch (Exception e) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append(Env.NL);
                    }
                    errorMessage.append(e.getLocalizedMessage());
                }
            });
            if (errorMessage.length() > 0) {
                throw new AdempiereException("@ProductBlockedForTakingInventory@" + Env.NL + errorMessage.toString());
            }
        } else if (entity.get_TableName().equals("M_Movement")) {
            MMovement movement = (MMovement)entity;
            StringBuffer errorMessage = new StringBuffer();
            Arrays.asList(movement.getLines(true)).stream().filter(movementLine -> {
                if (movementLine.getM_Product_ID() <= 0) {
                    return false;
                }
                MProduct product = MProduct.get((Properties)entity.getCtx(), (int)movementLine.getM_Product_ID());
                if (!product.isStocked()) {
                    return false;
                }
                return Optional.ofNullable(movementLine.getMovementQty()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0;
            }).forEach(movementLine -> {
                try {
                    ValidateProduct.validate((PO)movementLine, movementLine.getM_Product_ID());
                }
                catch (Exception e) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append(Env.NL);
                    }
                    errorMessage.append(e.getLocalizedMessage());
                }
            });
            if (errorMessage.length() > 0) {
                throw new AdempiereException("@ProductBlockedForTakingInventory@" + Env.NL + errorMessage.toString());
            }
        } else if (entity.get_TableName().equals("M_Production")) {
            MProduction production = (MProduction)entity;
            try {
                ValidateProduct.validate(entity, production.getM_Product_ID());
            }
            catch (Exception e) {
                throw new AdempiereException("@ProductBlockedForTakingInventory@" + Env.NL + e.getLocalizedMessage());
            }
            StringBuffer errorMessage = new StringBuffer();
            Arrays.asList(production.getLines()).stream().filter(productionLine -> {
                if (productionLine.getM_Product_ID() <= 0) {
                    return false;
                }
                MProduct product = MProduct.get((Properties)entity.getCtx(), (int)productionLine.getM_Product_ID());
                if (!product.isStocked()) {
                    return false;
                }
                return Optional.ofNullable(productionLine.getMovementQty()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0;
            }).forEach(productionLine -> {
                try {
                    ValidateProduct.validate((PO)productionLine, productionLine.getM_Product_ID());
                }
                catch (Exception e) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append(Env.NL);
                    }
                    errorMessage.append(e.getLocalizedMessage());
                }
            });
            if (errorMessage.length() > 0) {
                throw new AdempiereException("@ProductBlockedForTakingInventory@" + Env.NL + errorMessage.toString());
            }
        } else if (entity.get_TableName().equals("WM_InOutBound")) {
            MWMInOutBound outbound = (MWMInOutBound)entity;
            StringBuffer errorMessage = new StringBuffer();
            outbound.getLines(true, null).stream().filter(outboundLine -> {
                if (outboundLine.getM_Product_ID() <= 0) {
                    return false;
                }
                MProduct product = MProduct.get((Properties)entity.getCtx(), (int)outboundLine.getM_Product_ID());
                if (!product.isStocked()) {
                    return false;
                }
                return Optional.ofNullable(outboundLine.getMovementQty()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0;
            }).forEach(movementLine -> {
                try {
                    ValidateProduct.validate((PO)movementLine, movementLine.getM_Product_ID());
                }
                catch (Exception e) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append(Env.NL);
                    }
                    errorMessage.append(e.getLocalizedMessage());
                }
            });
            if (errorMessage.length() > 0) {
                throw new AdempiereException("@ProductBlockedForTakingInventory@" + Env.NL + errorMessage.toString());
            }
        } else if (entity.get_TableName().equals("M_InOutConfirm")) {
            MInOutConfirm inOutConfirm = (MInOutConfirm)entity;
            StringBuffer errorMessage = new StringBuffer();
            Arrays.asList(inOutConfirm.getLines(true)).stream().filter(inOutConfirmLine -> {
                MInOutLine inoutLine = (MInOutLine)inOutConfirmLine.getM_InOutLine();
                MProduct product = MProduct.get((Properties)entity.getCtx(), (int)inoutLine.getM_Product_ID());
                if (!product.isStocked()) {
                    return false;
                }
                return Optional.ofNullable(inOutConfirmLine.getTargetQty()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0;
            }).forEach(inOutConfirmLine -> {
                try {
                    ValidateProduct.validate((PO)inOutConfirmLine, inOutConfirmLine.getM_InOutLine().getM_Product_ID());
                }
                catch (Exception e) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append(Env.NL);
                    }
                    errorMessage.append(e.getLocalizedMessage());
                }
            });
            if (errorMessage.length() > 0) {
                throw new AdempiereException("@ProductBlockedForTakingInventory@" + Env.NL + errorMessage.toString());
            }
        } else if (entity.get_TableName().equals("M_ProductionBatch")) {
            MProductionBatch production = (MProductionBatch)entity;
            try {
                ValidateProduct.validate(entity, production.getM_Product_ID());
            }
            catch (Exception e) {
                throw new AdempiereException("@ProductBlockedForTakingInventory@" + Env.NL + e.getLocalizedMessage());
            }
        } else if (entity.get_TableName().equals("M_MovementConfirm")) {
            MMovementConfirm movementConfirm = (MMovementConfirm)entity;
            StringBuffer errorMessage = new StringBuffer();
            Arrays.asList(movementConfirm.getLines(true)).stream().filter(movementConfirmLine -> {
                MMovementLine inoutLine = (MMovementLine)movementConfirmLine.getM_InventoryLine();
                MProduct product = MProduct.get((Properties)entity.getCtx(), (int)inoutLine.getM_Product_ID());
                if (!product.isStocked()) {
                    return false;
                }
                return Optional.ofNullable(movementConfirmLine.getTargetQty()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0;
            }).forEach(movementConfirmLine -> {
                try {
                    ValidateProduct.validate((PO)movementConfirmLine, movementConfirmLine.getM_MovementLine().getM_Product_ID());
                }
                catch (Exception e) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append(Env.NL);
                    }
                    errorMessage.append(e.getLocalizedMessage());
                }
            });
            if (errorMessage.length() > 0) {
                throw new AdempiereException("@ProductBlockedForTakingInventory@" + Env.NL + errorMessage.toString());
            }
        } else if (entity.get_TableName().equals("M_Inventory")) {
            MInventory inventory = (MInventory)entity;
            StringBuffer errorMessage = new StringBuffer();
            Arrays.asList(inventory.getLines(true)).stream().filter(orderLine -> {
                if (orderLine.getM_Product_ID() <= 0) {
                    return false;
                }
                MProduct product = MProduct.get((Properties)entity.getCtx(), (int)orderLine.getM_Product_ID());
                if (!product.isStocked()) {
                    return false;
                }
                return Optional.ofNullable(orderLine.getMovementQty()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0;
            }).forEach(inventoryLine -> {
                try {
                    ValidateProduct.validate((PO)inventoryLine, inventoryLine.getM_Product_ID());
                }
                catch (Exception e) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append(Env.NL);
                    }
                    errorMessage.append(e.getLocalizedMessage());
                }
            });
            if (errorMessage.length() > 0) {
                throw new AdempiereException("@ProductBlockedForTakingInventory@" + Env.NL + errorMessage.toString());
            }
        }
    }

    private static void markProductFromInventoryLine(PO entity, MProduct product) {
        MInventory inventory;
        MInventoryLine inventoryLine;
        if (entity.get_TableName().equals("M_InventoryLine") && !(inventoryLine = (MInventoryLine)entity).isProcessed() && !(inventory = inventoryLine.getParent()).isReversal() && inventory.isStocktake()) {
            product.set_ValueOfColumn(COLUMNNAME_IsBlockedForTakingInventory, (Object)true);
            product.saveEx();
        }
    }

    public static void validateProductForUnMark(PO entity) {
        if (entity.get_TableName().equals("M_InventoryLine")) {
            MInventoryLine inventoryLine = (MInventoryLine)entity;
            MProduct product = new MProduct(entity.getCtx(), inventoryLine.getM_Product_ID(), entity.get_TrxName());
            boolean exists = ValidateProduct.existsPhysicalInventoryInProgress(inventoryLine.getCtx(), product.getM_Product_ID(), inventoryLine.getM_Inventory_ID(), inventoryLine.get_TrxName());
            if (exists) {
                product.set_ValueOfColumn(COLUMNNAME_IsBlockedForTakingInventory, (Object)exists);
                product.saveEx();
            }
        }
    }

    private static boolean existsPhysicalInventoryInProgress(Properties context, int productId, int physicalInventoryId, String transactionName) {
        StringBuffer exclussionWhere = new StringBuffer();
        if (physicalInventoryId > 0) {
            exclussionWhere.append(" AND M_Inventory.M_Inventory_ID <> ").append(physicalInventoryId).append(" ");
        }
        return new Query(context, "M_Inventory", "IsStocktake = 'Y' AND Processed = 'N' " + (exclussionWhere.length() > 0 ? exclussionWhere : "") + "AND EXISTS(SELECT 1 FROM M_InventoryLine il \t\t\t\t\t\tINNER JOIN M_Locator l ON(l.M_Locator_ID = il.M_Locator_ID) \t\t\t\t\t\tWHERE il.M_Inventory_ID = M_Inventory.M_Inventory_ID \t\t\t\t\t\tAND il.M_Product_ID = ?)", transactionName).setParameters(new Object[]{productId}).firstId() > 0;
    }

    private static boolean existsPhysicalInventoryInProgress(Properties context, int productId, PO entity, String transactionName) {
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        StringBuffer exclussionWhere = new StringBuffer();
        if (entity.get_TableName().equals("M_InventoryLine")) {
            exclussionWhere.append(" AND M_Inventory.M_Inventory_ID <> ? ");
            parameters.add(entity.get_ValueAsInt("M_Inventory_ID"));
        }
        parameters.add(productId);
        StringBuffer whereAdded = new StringBuffer();
        if (entity.get_ColumnIndex("M_Warehouse_ID") != -1) {
            whereAdded.append("l.M_Warehouse_ID = ?");
            parameters.add(entity.get_ValueAsInt("M_Warehouse_ID"));
        }
        if (entity.get_ColumnIndex("M_Locator_ID") != -1) {
            if (whereAdded.length() > 0) {
                whereAdded.append(" OR ");
            }
            whereAdded.append("l.M_Locator_ID = ?");
            parameters.add(entity.get_ValueAsInt("M_Locator_ID"));
        }
        if (entity.get_ColumnIndex("M_LocatorTo_ID") != -1) {
            if (whereAdded.length() > 0) {
                whereAdded.append(" OR ");
            }
            whereAdded.append("l.M_Locator_ID = ?");
            parameters.add(entity.get_ValueAsInt("M_LocatorTo_ID"));
        }
        return new Query(context, "M_Inventory", "IsStocktake = 'Y' AND Processed = 'N' " + (exclussionWhere.length() > 0 ? exclussionWhere : "") + "AND EXISTS(SELECT 1 FROM M_InventoryLine il \t\t\t\t\t\tINNER JOIN M_Locator l ON(l.M_Locator_ID = il.M_Locator_ID) \t\t\t\t\t\tWHERE il.M_Inventory_ID = M_Inventory.M_Inventory_ID \t\t\t\t\t\tAND il.M_Product_ID = ?" + (whereAdded.length() > 0 ? " AND (" + whereAdded + ")" : "") + ")", transactionName).setParameters(parameters).firstId() > 0;
    }
}

