/*
 * Decompiled with CFR 0.152.
 */
package org.spin.wms.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.MWMInOutBoundLine;

public class ManagedByWeightHandler {
    public static final String COLUMNNAME_IsManagedByWeight = "IsManagedByWeight";
    public static final String MESSAGE_ProductIsManagedByWeight = "ProductIsManagedByWeight";
    private static List<String> tablesForManagedByWeight = Arrays.asList("M_Product", "WM_InOutBoundLine");

    public static void loadTablesForManagedByWeight(ModelValidationEngine engine, ModelValidator listener) {
        tablesForManagedByWeight.forEach(tableName -> engine.addModelChange(tableName, listener));
    }

    public static void validateProduct(PO entity) {
        MUOM unitOfMeasure;
        MProduct product;
        if (!entity.get_TableName().equals("M_Product")) {
            return;
        }
        if ((entity.is_new() || entity.is_ValueChanged(COLUMNNAME_IsManagedByWeight) || entity.is_ValueChanged("C_UOM_ID")) && (product = (MProduct)entity).get_ValueAsBoolean(COLUMNNAME_IsManagedByWeight) && (Util.isEmpty((String)(unitOfMeasure = MUOM.get((Properties)product.getCtx(), (int)product.getC_UOM_ID())).getUOMType()) || !unitOfMeasure.getUOMType().equals("WE"))) {
            throw new AdempiereException("@ProductIsManagedByWeight@ " + product.getValue() + " - " + product.getName());
        }
    }

    public static void changeQuantityToBaseUnit(PO entity) {
        if (!entity.get_TableName().equals("WM_InOutBoundLine")) {
            return;
        }
        if (entity.is_new() || entity.is_ValueChanged("M_Product_ID") || entity.is_ValueChanged("C_UOM_ID") || entity.is_ValueChanged("MovementQty") || entity.is_ValueChanged("PickedQty")) {
            MWMInOutBoundLine inOutBoundLine = (MWMInOutBoundLine)entity;
            if (inOutBoundLine.getM_Product_ID() <= 0) {
                return;
            }
            MOrder salesOrder = (MOrder)inOutBoundLine.getC_Order();
            if (salesOrder.get_ValueAsInt("W_Basket_ID") > 0) {
                return;
            }
            MProduct product = MProduct.get((Properties)inOutBoundLine.getCtx(), (int)inOutBoundLine.getM_Product_ID());
            if (product.get_ValueAsBoolean(COLUMNNAME_IsManagedByWeight) && inOutBoundLine.getC_UOM_ID() != product.getC_UOM_ID()) {
                if (inOutBoundLine.getMovementQty() != null && inOutBoundLine.getMovementQty().compareTo(Env.ZERO) != 0) {
                    BigDecimal convertedMovementQuantity = MUOMConversion.convertProductTo((Properties)inOutBoundLine.getCtx(), (int)inOutBoundLine.getM_Product_ID(), (int)inOutBoundLine.getC_UOM_ID(), (BigDecimal)inOutBoundLine.getMovementQty());
                    if (convertedMovementQuantity == null || convertedMovementQuantity.compareTo(Env.ZERO) == 0) {
                        throw new AdempiereException("@C_UOM_Conversion_ID@ @NotFound@: " + product.getValue() + " - " + product.getName());
                    }
                    inOutBoundLine.setMovementQty(convertedMovementQuantity);
                }
                if (inOutBoundLine.getPickedQty() != null && inOutBoundLine.getPickedQty().compareTo(Env.ZERO) != 0) {
                    BigDecimal convertedPickedQuantity = MUOMConversion.convertProductTo((Properties)inOutBoundLine.getCtx(), (int)inOutBoundLine.getM_Product_ID(), (int)inOutBoundLine.getC_UOM_ID(), (BigDecimal)inOutBoundLine.getPickedQty());
                    if (convertedPickedQuantity == null || convertedPickedQuantity.compareTo(Env.ZERO) == 0) {
                        throw new AdempiereException("@C_UOM_Conversion_ID@ @NotFound@: " + product.getValue() + " - " + product.getName());
                    }
                    inOutBoundLine.setPickedQty(convertedPickedQuantity);
                }
                inOutBoundLine.setC_UOM_ID(product.getC_UOM_ID());
            }
        }
    }
}

