/*
 * Decompiled with CFR 0.152.
 */
package org.spin.wms.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DocTypeNotFoundException;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.I_WM_InOutBoundLine;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;
import org.eevolution.process.GenerateShipmentOutBound;
import org.eevolution.process.MovementGenerate;
import org.eevolution.process.ReleaseInOutBound;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.process.GenerateInvoiceInOutBound;

public class ExpressOutboundOrder {
    public static final String COLUMNNAME_IsAutoReleaseInOutBound = "IsAutoReleaseInOutBound";
    public static final String COLUMNNAME_IsAutoInvoiceInOutBound = "IsAutoInvoiceInOutBound";
    public static final String COLUMNNAME_IsAutoShipmentInOutBound = "IsAutoShipmentInOutBound";
    public static final String COLUMNNAME_IsCloseRelatedOrders = "IsCloseRelatedOrders";
    public static final String COLUMNNAME_IsPrintPickList = "IsPrintPickList";
    public static final String COLUMNNAME_IsAutoGenerateMovement = "IsAutoGenerateMovement";
    public static final String COLUMNNAME_IsAutoGenerateInOutBound = "IsAutoGenerateInOutBound";
    public static final String MESSAGE_ProductBlockedForTakingInventory = "ProductBlockedForTakingInventory";
    public static final String MESSAGE_OutboundOrderNotReleased = "OutboundOrderNotReleased";
    public static final String COLUMNNAME_C_DocTypeInOutBound_ID = "C_DocTypeInOutBound_ID";
    public static final String WM_AREA_TYPE_ID = "WM_Area_Type_ID";
    public static final String WM_SECTION_TYPE_ID = "WM_Section_Type_ID";
    public static final String M_LOCATOR_ID = "M_Locator_ID";
    public static final String C_DOCTYPE_ID = "C_DocType_ID";
    public static final String DOCACTION = "DocAction";
    public static final String DELIVERYRULE = "DeliveryRule";
    public static final String DELIVERYVIARULE = "DeliveryViaRule";
    public static final String M_SHIPPER_ID = "M_Shipper_ID";
    public static final String FREIGHTCOSTRULE = "FreightCostRule";
    public static final String M_FREIGHTCATEGORY_ID = "M_FreightCategory_ID";
    public static final String ISPRINTPICKLIST = "IsPrintPickList";
    public static final String ISCREATESUPPLY = "IsCreateSupply";
    private static final String ISINCLUDENOTAVAILABLE = "IsIncludeNotAvailable";
    private static final String MOVEMENTDATE = "MovementDate";
    public static final String DATEINVOICED = "DateInvoiced";
    public static final String CONSOLIDATEDOCUMENT = "ConsolidateDocument";

    public static void validateInOutBoundOrderReleased(MWMInOutBound outBoundOrder) {
        StringBuffer errorMessage = new StringBuffer();
        new Query(outBoundOrder.getCtx(), "WM_InOutBoundLine", "WM_InOutBoundLine.WM_InOutBound_ID = ? AND NOT EXISTS(SELECT 1 FROM DD_OrderLine ddl \t\t\t\t\tWHERE ddl.WM_InOutBoundLine_ID = WM_InOutBoundLine.WM_InOutBoundLine_ID)", outBoundOrder.get_TrxName()).setParameters(new Object[]{outBoundOrder.getWM_InOutBound_ID()}).setOrderBy("Line").list().forEach(outboundOrderLine -> {
            MProduct product = MProduct.get((Properties)outBoundOrder.getCtx(), (int)outboundOrderLine.getM_Product_ID());
            if (errorMessage.length() > 0) {
                errorMessage.append(Env.NL);
            }
            errorMessage.append(outboundOrderLine.getLine() + ": " + product.getValue() + " - " + product.getName());
        });
        if (errorMessage.length() > 0) {
            throw new AdempiereException("@OutboundOrderNotReleased@ " + errorMessage.toString());
        }
    }

    public static void generateShipmentFromOutBoundOrder(MWMInOutBound outBoundOrder) {
        ProcessInfo processInformation = ProcessBuilder.create((Properties)outBoundOrder.getCtx()).process(Integer.valueOf(GenerateShipmentOutBound.getProcessId())).withoutTransactionClose().withRecordId(Integer.valueOf(MWMInOutBound.Table_ID), Integer.valueOf(outBoundOrder.getWM_InOutBound_ID())).withParameter(DOCACTION, (Object)"CO").withParameter(ISINCLUDENOTAVAILABLE, (Object)true).withParameter(MOVEMENTDATE, (Object)outBoundOrder.getPickDate()).withSelectedRecordsIds(MWMInOutBound.Table_ID, outBoundOrder.getLines(true, null).stream().map(outBoundOrderLine -> outBoundOrderLine.getWM_InOutBoundLine_ID()).collect(Collectors.toList())).execute(outBoundOrder.get_TrxName());
        if (processInformation.isError()) {
            throw new AdempiereException(processInformation.getSummary());
        }
    }

    public static void generateInvoiceFromOutBoundOrder(MWMInOutBound outBoundOrder) {
        ProcessInfo processInformation = ProcessBuilder.create((Properties)outBoundOrder.getCtx()).process(Integer.valueOf(GenerateInvoiceInOutBound.getProcessId())).withoutTransactionClose().withRecordId(Integer.valueOf(MWMInOutBound.Table_ID), Integer.valueOf(outBoundOrder.getWM_InOutBound_ID())).withParameter(DOCACTION, (Object)"CO").withParameter(ISINCLUDENOTAVAILABLE, (Object)true).withParameter(DATEINVOICED, (Object)outBoundOrder.getPickDate()).withParameter(CONSOLIDATEDOCUMENT, (Object)true).execute(outBoundOrder.get_TrxName());
        if (processInformation.isError()) {
            throw new AdempiereException(processInformation.getSummary());
        }
    }

    public static void generatePickingListOutBoundOrder(MWMInOutBound outBoundOrder, boolean printPickingList) {
        MLocator defaultLocator = MWarehouse.get((Properties)outBoundOrder.getCtx(), (int)outBoundOrder.getM_Warehouse_ID()).getDefaultLocator();
        outBoundOrder.setDocStatus("CO");
        outBoundOrder.saveEx();
        ProcessInfo processInformation = ProcessBuilder.create((Properties)outBoundOrder.getCtx()).process(Integer.valueOf(ReleaseInOutBound.getProcessId())).withoutTransactionClose().withParameter(M_LOCATOR_ID, (Object)defaultLocator.getM_Locator_ID()).withParameter(DOCACTION, (Object)"CO").withParameter("IsPrintPickList", (Object)printPickingList).withSelectedRecordsIds(I_WM_InOutBoundLine.Table_ID, outBoundOrder.getLines(true, null).stream().map(outBoundOrderLine -> outBoundOrderLine.getWM_InOutBoundLine_ID()).collect(Collectors.toList())).execute(outBoundOrder.get_TrxName());
        outBoundOrder.setDocStatus("IP");
        outBoundOrder.saveEx();
        if (processInformation.isError()) {
            throw new AdempiereException(processInformation.getSummary());
        }
        ExpressOutboundOrder.validateInOutBoundOrderReleased(outBoundOrder);
    }

    public static void reverseInvoicesFromOrder(MWMInOutBound outboundOrder) {
        if (!outboundOrder.isSOTrx()) {
            return;
        }
        new Query(outboundOrder.getCtx(), "C_Invoice", "C_Invoice.DocStatus NOT IN('CO', 'RE', 'VO') AND EXISTS(SELECT 1 FROM C_InvoiceLine il INNER JOIN WM_InOutBoundLine iol ON(iol.WM_InOutBoundLine_ID = il.WM_InOutBoundLine_ID)WHERE il.C_Invoice_ID = C_Invoice.C_Invoice_ID AND iol.WM_InOutBound_ID = ?)", outboundOrder.get_TrxName()).setParameters(new Object[]{outboundOrder.getWM_InOutBound_ID()}).getIDsAsList().forEach(invoiceId -> {
            MInvoice invoice = new MInvoice(outboundOrder.getCtx(), invoiceId.intValue(), outboundOrder.get_TrxName());
            invoice.processIt("VO");
            invoice.saveEx();
        });
    }

    public static void reverseShipmentsFromOrder(MWMInOutBound outboundOrder) {
        if (!outboundOrder.isSOTrx()) {
            return;
        }
        new Query(outboundOrder.getCtx(), "M_InOut", "M_InOut.DocStatus NOT IN('CO', 'RE', 'VO') AND EXISTS(SELECT 1 FROM M_InOutLine il INNER JOIN WM_InOutBoundLine iol ON(iol.WM_InOutBoundLine_ID = il.WM_InOutBoundLine_ID)WHERE il.M_InOut_ID = M_InOut.M_InOut_ID AND iol.WM_InOutBound_ID = ?)", outboundOrder.get_TrxName()).setParameters(new Object[]{outboundOrder.getWM_InOutBound_ID()}).getIDsAsList().forEach(invoiceId -> {
            MInvoice invoice = new MInvoice(outboundOrder.getCtx(), invoiceId.intValue(), outboundOrder.get_TrxName());
            invoice.processIt("VO");
            invoice.saveEx();
        });
    }

    public static void generateMovementFromDistributionOrder(MDDOrder distributionOrder) {
        ProcessInfo processInformation = ProcessBuilder.create((Properties)distributionOrder.getCtx()).process(Integer.valueOf(MovementGenerate.getProcessId())).withoutTransactionClose().withRecordId(Integer.valueOf(MDDOrder.Table_ID), Integer.valueOf(0)).withSelectedRecordsIds(MDDOrder.Table_ID, Arrays.asList(distributionOrder.getDD_Order_ID())).withParameter(MOVEMENTDATE, (Object)distributionOrder.getDateOrdered()).withParameter(DOCACTION, (Object)"CO").execute(distributionOrder.get_TrxName());
        if (processInformation.isError()) {
            throw new AdempiereException(processInformation.getSummary());
        }
    }

    public static void generateOutBoundOrderFromSalesOrder(MOrder order) {
        MWMInOutBound outBoundOrder = ExpressOutboundOrder.createOutBoundOrder(order);
        ExpressOutboundOrder.createBasedOnSalesOrders(outBoundOrder, Arrays.asList(order.getLines()));
        if (!outBoundOrder.processIt("CO")) {
            throw new AdempiereException(outBoundOrder.getProcessMsg());
        }
    }

    private static MWMInOutBound createOutBoundOrder(MOrder order) {
        MDocType documentType = MDocType.get((Properties)order.getCtx(), (int)order.getC_DocTypeTarget_ID());
        MLocator locator = MLocator.get((Properties)order.getCtx(), (int)MWarehouse.get((Properties)order.getCtx(), (int)order.getM_Warehouse_ID()).getDefaultLocator().getM_Locator_ID());
        MWMInOutBound outBoundOrder = new MWMInOutBound(order.getCtx(), 0, order.get_TrxName());
        outBoundOrder.setShipDate(order.getDateOrdered());
        outBoundOrder.setPickDate(order.getDateOrdered());
        outBoundOrder.setDocStatus("DR");
        outBoundOrder.setDocAction("CO");
        Optional.ofNullable(order.getPOReference()).ifPresent(arg_0 -> ((MWMInOutBound)outBoundOrder).setPOReference(arg_0));
        Optional.ofNullable(order.getPOReference()).ifPresent(arg_0 -> ((MWMInOutBound)outBoundOrder).setPriorityRule(arg_0));
        Optional.ofNullable(order.getPOReference()).ifPresent(arg_0 -> ((MWMInOutBound)outBoundOrder).setDeliveryViaRule(arg_0));
        Optional.ofNullable(order.getPOReference()).ifPresent(arg_0 -> ((MWMInOutBound)outBoundOrder).setFreightCostRule(arg_0));
        Optional.ofNullable(order.getDeliveryRule()).ifPresent(arg_0 -> ((MWMInOutBound)outBoundOrder).setDeliveryRule(arg_0));
        outBoundOrder.setM_Locator_ID(locator.getM_Locator_ID());
        if (documentType.get_ValueAsInt(COLUMNNAME_C_DocTypeInOutBound_ID) > 0) {
            outBoundOrder.setC_DocType_ID(documentType.get_ValueAsInt(COLUMNNAME_C_DocTypeInOutBound_ID));
        } else {
            int docTypeId = MDocType.getDocType((String)"WMO");
            if (docTypeId <= 0) {
                throw new DocTypeNotFoundException("WMO", "");
            }
            outBoundOrder.setC_DocType_ID(docTypeId);
        }
        if (order.getM_Shipper_ID() > 0) {
            outBoundOrder.setM_Shipper_ID(order.getM_Shipper_ID());
        }
        if (order.getM_FreightCategory_ID() > 0) {
            outBoundOrder.setM_FreightCategory_ID(order.getM_FreightCategory_ID());
        }
        outBoundOrder.setM_Warehouse_ID(locator.getM_Warehouse_ID());
        outBoundOrder.setIsSOTrx(true);
        outBoundOrder.saveEx();
        return outBoundOrder;
    }

    private static void createBasedOnSalesOrders(MWMInOutBound outBoundOrder, List<MOrderLine> orderLines) {
        orderLines.forEach(orderLine -> {
            MWMInOutBoundLine outBoundOrderLine = new MWMInOutBoundLine(outBoundOrder);
            outBoundOrderLine.setLine(ExpressOutboundOrder.getLineNo(outBoundOrder));
            outBoundOrderLine.setM_Product_ID(orderLine.getM_Product_ID());
            outBoundOrderLine.setM_AttributeSetInstance_ID(orderLine.getM_AttributeSetInstance_ID());
            outBoundOrderLine.setMovementQty(orderLine.getQtyOrdered().subtract(orderLine.getQtyDelivered()));
            outBoundOrderLine.setC_UOM_ID(orderLine.getC_UOM_ID());
            outBoundOrderLine.setDescription(orderLine.getDescription());
            outBoundOrderLine.setC_Order_ID(orderLine.getC_Order_ID());
            outBoundOrderLine.setC_OrderLine_ID(orderLine.getC_OrderLine_ID());
            outBoundOrderLine.setPickDate(outBoundOrder.getPickDate());
            outBoundOrderLine.setShipDate(outBoundOrder.getShipDate());
            outBoundOrderLine.saveEx();
        });
    }

    private static int getLineNo(MWMInOutBound outbound) {
        return DB.getSQLValueEx((String)outbound.get_TrxName(), (String)"SELECT COALESCE(MAX(Line),0)+10 AS DefaultValue FROM WM_InOutBoundLine WHERE WM_InOutBound_ID=?", (Object[])new Object[]{outbound.getWM_InOutBound_ID()});
    }
}

