/*
 * Decompiled with CFR 0.152.
 */
package org.spin.wms.model.validator;

import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MWMInOutBound;
import org.spin.wms.util.ExpressOutboundOrder;
import org.spin.wms.util.ManagedByWeightHandler;

public class ExpressWMS
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ExpressWMS.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("WM_InOutBound", (ModelValidator)this);
        engine.addDocValidate("DD_Order", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
        ManagedByWeightHandler.loadTablesForManagedByWeight(engine, this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        if (type == 1 || type == 2) {
            ManagedByWeightHandler.validateProduct(entity);
            ManagedByWeightHandler.changeQuantityToBaseUnit(entity);
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        if (timing == 9) {
            MDocType documentType;
            MOrder order;
            if (entity.get_TableName().equals("WM_InOutBound")) {
                MWMInOutBound outBoundOrder = (MWMInOutBound)entity;
                MDocType documentType2 = MDocType.get((Properties)entity.getCtx(), (int)outBoundOrder.getC_DocType_ID());
                if (outBoundOrder.isSOTrx()) {
                    if (documentType2.get_ValueAsBoolean("IsAutoReleaseInOutBound")) {
                        ExpressOutboundOrder.generatePickingListOutBoundOrder(outBoundOrder, documentType2.get_ValueAsBoolean("IsPrintPickList"));
                    } else {
                        if (documentType2.get_ValueAsBoolean("IsAutoShipmentInOutBound")) {
                            ExpressOutboundOrder.generateShipmentFromOutBoundOrder(outBoundOrder);
                        }
                        if (documentType2.get_ValueAsBoolean("IsAutoInvoiceInOutBound")) {
                            ExpressOutboundOrder.generateInvoiceFromOutBoundOrder(outBoundOrder);
                        }
                    }
                }
            } else if (entity.get_TableName().equals("DD_Order")) {
                MDDOrder distributionOrder = (MDDOrder)entity;
                MDocType documentType3 = MDocType.get((Properties)distributionOrder.getCtx(), (int)distributionOrder.getC_DocType_ID());
                if (documentType3.get_ValueAsBoolean("IsAutoGenerateMovement")) {
                    ExpressOutboundOrder.generateMovementFromDistributionOrder(distributionOrder);
                }
            } else if (entity.get_TableName().equals("C_Order") && (order = (MOrder)entity).isSOTrx() && !order.isReturnOrder() && (documentType = MDocType.get((Properties)order.getCtx(), (int)order.getC_DocTypeTarget_ID())).get_ValueAsBoolean("IsAutoGenerateInOutBound")) {
                ExpressOutboundOrder.generateOutBoundOrderFromSalesOrder(order);
            }
        } else if ((timing == 10 || timing == 13 || timing == 14) && entity.get_TableName().equals("WM_InOutBound")) {
            MWMInOutBound outBoundOrder = (MWMInOutBound)entity;
            MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)outBoundOrder.getC_DocType_ID());
            if (outBoundOrder.isSOTrx()) {
                if (documentType.get_ValueAsBoolean("IsAutoShipmentInOutBound")) {
                    ExpressOutboundOrder.reverseShipmentsFromOrder(outBoundOrder);
                }
                if (documentType.get_ValueAsBoolean("IsAutoInvoiceInOutBound")) {
                    ExpressOutboundOrder.reverseInvoicesFromOrder(outBoundOrder);
                }
            }
        }
        return null;
    }
}

