/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class TaxExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private PackOut packOut;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.parentsToExclude = new ArrayList<String>();
        this.parentsToExclude.add("C_Currency");
        this.parentsToExclude.add("AD_User_Roles");
        this.createTax(ctx, document, this.parentsToExclude);
    }

    private void createTax(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List taxCategoryList = new Query(ctx, "C_TaxCategory", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MTaxCategory taxCategoryExporter : taxCategoryList) {
            if (taxCategoryExporter.getC_TaxCategory_ID() < 999999) continue;
            this.cleanOfficialReference((PO)taxCategoryExporter);
            this.packOut.createGenericPO(document, (PO)taxCategoryExporter, true, parentsToExclude);
        }
        List taxList = new Query(ctx, "C_Tax", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MTax taxExporter : taxList) {
            if (taxExporter.getC_Tax_ID() < 999999) continue;
            this.cleanOfficialReference((PO)taxExporter);
            this.packOut.createGenericPO(document, (PO)taxExporter, true, parentsToExclude);
        }
    }
}

