/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.MColumnAccess;
import org.compiere.model.MRecordAccess;
import org.compiere.model.MRole;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class SecurityExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private PackOut packOut;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.parentsToExclude = new ArrayList<String>();
        this.parentsToExclude.add("C_Currency");
        this.parentsToExclude.add("GL_Category");
        this.parentsToExclude.add("AD_User_Roles");
        this.parentsToExclude.add("AD_Sequence");
        this.parentsToExclude.add("AD_Sequence_No");
        List roleList = new Query(ctx, "AD_Role", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MRole role : roleList) {
            if (role.getAD_Role_ID() < 999999) continue;
            this.cleanOfficialReference((PO)role);
            this.createRole(ctx, role, document, this.parentsToExclude);
        }
    }

    private void createRole(Properties ctx, MRole role, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        this.packOut.createGenericPO(document, (PO)role, true, parentsToExclude);
        List orgAccessList = new Query(ctx, "AD_Role_OrgAccess", "AD_Role_ID = ?", null).setParameters(new Object[]{role.getAD_Role_ID()}).list();
        for (Object access : orgAccessList) {
            if (access.getAD_Org_ID() < 999999) continue;
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            this.packOut.createGenericPO(document, (PO)access, true, parentsToExclude);
        }
        List processAccessList = new Query(ctx, "AD_Process_Access", "AD_Role_ID = ?", null).setParameters(new Object[]{role.getAD_Role_ID()}).list();
        for (Object access : processAccessList) {
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            this.packOut.createGenericPO(document, (PO)access, true, parentsToExclude);
        }
        List windowAccessList = new Query(ctx, "AD_Window_Access", "AD_Role_ID = ?", null).setParameters(new Object[]{role.getAD_Role_ID()}).list();
        for (Object access : windowAccessList) {
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            this.packOut.createGenericPO(document, (PO)access, true, parentsToExclude);
        }
        List formAccessList = new Query(ctx, "AD_Form_Access", "AD_Role_ID = ?", null).setParameters(new Object[]{role.getAD_Role_ID()}).list();
        for (Object access : formAccessList) {
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            this.packOut.createGenericPO(document, (PO)access, true, parentsToExclude);
        }
        List browseAccessList = new Query(ctx, "AD_Browse_Access", "AD_Role_ID = ?", null).setParameters(new Object[]{role.getAD_Role_ID()}).list();
        for (Object access : browseAccessList) {
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            this.packOut.createGenericPO(document, (PO)access, true, parentsToExclude);
        }
        List taskAccessList = new Query(ctx, "AD_Task_Access", "AD_Role_ID = ?", null).setParameters(new Object[]{role.getAD_Role_ID()}).list();
        for (Object access : taskAccessList) {
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            this.packOut.createGenericPO(document, (PO)access, true, parentsToExclude);
        }
        List dashboardAccessList = new Query(ctx, "AD_Dashboard_Access", "AD_Role_ID = ?", null).setParameters(new Object[]{role.getAD_Role_ID()}).list();
        for (Object access : dashboardAccessList) {
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            this.packOut.createGenericPO(document, (PO)access, true, parentsToExclude);
        }
        List workflowAccessList = new Query(ctx, "AD_Workflow_Access", "AD_Role_ID = ?", null).setParameters(new Object[]{role.getAD_Role_ID()}).list();
        for (Object access : workflowAccessList) {
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            this.packOut.createGenericPO(document, (PO)access, true, parentsToExclude);
        }
        List documentActionAccessList = new Query(ctx, "AD_Document_Action_Access", "AD_Role_ID = ?", null).setParameters(new Object[]{role.getAD_Role_ID()}).list();
        for (Object access : documentActionAccessList) {
            if (access.getC_DocType_ID() < 999999) continue;
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            this.packOut.createGenericPO(document, (PO)access, true, parentsToExclude);
        }
        List includeRoleAccessList = new Query(ctx, "AD_Role_Included", "AD_Role_ID = ?", null).setParameters(new Object[]{role.getAD_Role_ID()}).list();
        for (Object access : includeRoleAccessList) {
            if (access.getIncluded_Role_ID() < 999999) continue;
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            MRole includedRole = MRole.get((Properties)ctx, (int)access.getIncluded_Role_ID());
            this.packOut.createGenericPO(document, (PO)includedRole, true, parentsToExclude);
            this.packOut.createGenericPO(document, (PO)access);
        }
        List tableAccessList = new Query(ctx, "AD_Table_Access", "AD_Role_ID = ?", null).setParameters(new Object[]{role.getAD_Role_ID()}).list();
        for (Object access : tableAccessList) {
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            this.packOut.createGenericPO(document, (PO)access, true, parentsToExclude);
        }
        List columnAccessList = new Query(Env.getCtx(), "AD_Column_Access", "AD_Role_ID = ?", null).setParameters(new Object[]{role.getAD_Role_ID()}).setOnlyActiveRecords(true).list();
        for (MColumnAccess access : columnAccessList) {
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            this.packOut.createGenericPO(document, (PO)access, true, parentsToExclude);
        }
        List recordAccessList = new Query(Env.getCtx(), "AD_Record_Access", "AD_Role_ID = ?", null).setParameters(new Object[]{role.getAD_Role_ID()}).setOnlyActiveRecords(true).list();
        for (MRecordAccess access : recordAccessList) {
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            this.packOut.createGenericPO(document, (PO)access, true, parentsToExclude);
        }
    }
}

