/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.MEXPFormat;
import org.compiere.model.MEXPFormatLine;
import org.compiere.model.MEXPProcessor;
import org.compiere.model.MEXPProcessorParameter;
import org.compiere.model.MReplicationOrgAccess;
import org.compiere.model.MReplicationRoleAccess;
import org.compiere.model.MReplicationStrategy;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ReplicationDocument;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class ReplicationStrategyExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private PackOut packOut;
    private TransformerHandler document;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.document = document;
        this.parentsToExclude = new ArrayList<String>();
        this.parentsToExclude.add("AD_Table");
        this.parentsToExclude.add("AD_Org");
        this.createReplicationStrategy(ctx);
    }

    private void createReplicationStrategy(Properties ctx) throws SAXException {
        List replicationStrategyList = new Query(ctx, "AD_ReplicationStrategy", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MReplicationStrategy replicationStrategy : replicationStrategyList) {
            Object tableToReplicate2;
            if (replicationStrategy.getAD_ReplicationStrategy_ID() < 999999) continue;
            this.cleanOfficialReference((PO)replicationStrategy);
            this.exportProcessor(ctx, replicationStrategy.getEXP_Processor_ID());
            this.packOut.createGenericPO(this.document, (PO)replicationStrategy, true, this.parentsToExclude);
            List tablesList = replicationStrategy.getReplicationTables();
            for (Object tableToReplicate2 : tablesList) {
                this.packOut.createGenericPO(this.document, (PO)tableToReplicate2, true, this.parentsToExclude);
                this.createExportFormatBasedOnTable(ctx, tableToReplicate2.getAD_Table_ID());
            }
            List documentsList = replicationStrategy.getReplicationDocuments();
            tableToReplicate2 = documentsList.iterator();
            while (tableToReplicate2.hasNext()) {
                X_AD_ReplicationDocument documentToReplicate = (X_AD_ReplicationDocument)tableToReplicate2.next();
                this.packOut.createGenericPO(this.document, (PO)documentToReplicate, true, this.parentsToExclude);
                this.createExportFormatBasedOnTable(ctx, documentToReplicate.getAD_Table_ID());
            }
            List organizationsList = replicationStrategy.getOrgAccess();
            for (MReplicationOrgAccess organizationToReplicate : organizationsList) {
                this.packOut.createGenericPO(this.document, (PO)organizationToReplicate, true, this.parentsToExclude);
            }
            List rolesList = replicationStrategy.getRoleAccess();
            for (MReplicationRoleAccess roleToReplicate : rolesList) {
                this.packOut.createGenericPO(this.document, (PO)roleToReplicate, true, this.parentsToExclude);
            }
        }
    }

    private void createExportFormatBasedOnTable(Properties ctx, int tableId) throws SAXException {
        List exportFormatList = new Query(ctx, "EXP_Format", "AD_Table_ID = ?", null).setParameters(new Object[]{tableId}).setOnlyActiveRecords(true).list();
        for (MEXPFormat exportFormat : exportFormatList) {
            this.createExportFormat(ctx, exportFormat.getEXP_Format_ID());
        }
    }

    private void createExportFormat(Properties ctx, int exportFormatId) throws SAXException {
        String whereClause = "EXP_Format_ID = " + exportFormatId;
        List exportFormatList = new Query(ctx, "EXP_Format", exportFormatId != 0 ? whereClause : null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MEXPFormat exportFormat : exportFormatList) {
            if (exportFormat.getEXP_Format_ID() < 999999) continue;
            this.cleanOfficialReference((PO)exportFormat);
            this.packOut.createGenericPO(this.document, (PO)exportFormat, true, this.parentsToExclude);
            List formatLineList = new Query(ctx, "EXP_FormatLine", "EXP_Format_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{exportFormat.getEXP_Format_ID()}).list();
            for (MEXPFormatLine formatLine : formatLineList) {
                if (formatLine.getEXP_FormatLine_ID() < 999999) continue;
                this.cleanOfficialReference((PO)formatLine);
                if ((formatLine.getType().equals("M") || formatLine.getType().equals("R")) && formatLine.getEXP_EmbeddedFormat_ID() != 0) {
                    this.createExportFormat(ctx, formatLine.getEXP_EmbeddedFormat_ID());
                }
                this.packOut.createGenericPO(this.document, (PO)formatLine, true, this.parentsToExclude);
            }
        }
    }

    private void exportProcessor(Properties ctx, int exportProcessorId) throws SAXException {
        if (exportProcessorId == 0) {
            return;
        }
        MEXPProcessor exportProcessor = MEXPProcessor.get((Properties)ctx, (int)exportProcessorId, null);
        if (exportProcessor.getEXP_Processor_Type_ID() < 999999) {
            return;
        }
        this.cleanOfficialReference((PO)exportProcessor);
        this.packOut.createGenericPO(this.document, (PO)exportProcessor, true, this.parentsToExclude);
        List processorList = new Query(ctx, "EXP_Processor", "EXP_Processor_Type_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{exportProcessor.getEXP_Processor_Type_ID()}).list();
        for (MEXPProcessor processor : processorList) {
            if (processor.getEXP_Processor_ID() < 999999) continue;
            this.cleanOfficialReference((PO)processor);
            this.packOut.createGenericPO(this.document, (PO)processor, true, this.parentsToExclude);
            List processorParameterList = new Query(ctx, "EXP_ProcessorParameter", "EXP_Processor_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{processor.getEXP_Processor_ID()}).list();
            for (MEXPProcessorParameter parameter : processorParameterList) {
                if (parameter.getEXP_ProcessorParameter_ID() < 999999) continue;
                this.cleanOfficialReference((PO)parameter);
                this.packOut.createGenericPO(this.document, (PO)parameter, true, this.parentsToExclude);
            }
        }
    }
}

