/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.MDiscountSchema;
import org.compiere.model.MDiscountSchemaBreak;
import org.compiere.model.MDiscountSchemaLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class PriceExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private PackOut packOut;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.parentsToExclude = new ArrayList<String>();
        this.parentsToExclude.add("C_Currency");
        this.createPriceList(ctx, document, this.parentsToExclude);
        this.createDiscountShcema(ctx, document, this.parentsToExclude);
    }

    private void createPriceList(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List priceListList = new Query(ctx, "M_PriceList", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MPriceList priceList : priceListList) {
            if (priceList.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)priceList);
            this.packOut.createGenericPO(document, (PO)priceList, true, parentsToExclude);
            List priceListVersionList = new Query(ctx, "M_PriceList_Version", "M_PriceList_ID = ?", null).setParameters(new Object[]{priceList.get_ID()}).setOnlyActiveRecords(true).setClient_ID().list();
            for (MPriceListVersion priceListVersion : priceListVersionList) {
                if (priceListVersion.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)priceListVersion);
                this.packOut.createGenericPO(document, (PO)priceListVersion, true, parentsToExclude);
            }
        }
    }

    private void createDiscountShcema(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List discountSchemaList = new Query(ctx, "M_DiscountSchema", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MDiscountSchema discountSchema : discountSchemaList) {
            if (discountSchema.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)discountSchema);
            this.packOut.createGenericPO(document, (PO)discountSchema, true, parentsToExclude);
            List discountSchemaLineList = new Query(ctx, "M_DiscountSchemaLine", "M_DiscountSchema_ID = ?", null).setParameters(new Object[]{discountSchema.get_ID()}).setOnlyActiveRecords(true).setClient_ID().list();
            for (MDiscountSchemaLine discountSchemaLine : discountSchemaLineList) {
                if (discountSchemaLine.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)discountSchemaLine);
                this.packOut.createGenericPO(document, (PO)discountSchemaLine, true, parentsToExclude);
            }
            List discountSchemaBreakList = new Query(ctx, "M_DiscountSchemaBreak", "M_DiscountSchema_ID = ?", null).setParameters(new Object[]{discountSchema.get_ID()}).setOnlyActiveRecords(true).setClient_ID().list();
            for (MDiscountSchemaBreak discountSchemaBreak : discountSchemaBreakList) {
                if (discountSchemaBreak.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)discountSchemaBreak);
                this.packOut.createGenericPO(document, (PO)discountSchemaBreak, true, parentsToExclude);
            }
        }
    }
}

