/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.model.MHRProcessReport;
import org.spin.model.MHRProcessReportPayroll;
import org.spin.model.MHRProcessReportSource;
import org.spin.model.MHRProcessReportTemplate;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class PayrollReportExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude = new ArrayList<String>();

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        PackOut packOut = (PackOut)ctx.get("PackOutProcess");
        if (packOut == null) {
            packOut = new PackOut();
            packOut.setLocalContext(ctx);
        }
        this.createPayrollReport(ctx, document, packOut);
    }

    private void createPayrollReport(Properties ctx, TransformerHandler document, PackOut packOut) throws SAXException {
        List reportList = new Query(ctx, "HR_ProcessReport", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Name").list();
        for (MHRProcessReport report : reportList) {
            Object processReportLine2;
            if (report.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)report);
            packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
            packOut.createGenericPO(document, (PO)report, true, this.parentsToExclude);
            List processReportLineList = new Query(ctx, "HR_ProcessReportLine", "HR_ProcessReport_ID = ?", null).setParameters(new Object[]{report.getHR_ProcessReport_ID()}).setClient_ID().setOrderBy("SeqNo").list();
            for (Object processReportLine2 : processReportLineList) {
                if (processReportLine2.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)processReportLine2);
                packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
                packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
                packOut.createGenericPO(document, (PO)processReportLine2, true, this.parentsToExclude);
                List processReportSourceList = new Query(ctx, "HR_ProcessReportSource", "HR_ProcessReportLine_ID = ?", null).setParameters(new Object[]{processReportLine2.getHR_ProcessReportLine_ID()}).setClient_ID().setOrderBy("SeqNo").list();
                for (MHRProcessReportSource processReportSource : processReportSourceList) {
                    if (processReportSource.get_ID() < 999999) continue;
                    this.cleanOfficialReference((PO)processReportSource);
                    packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
                    packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
                    packOut.createGenericPO(document, (PO)processReportSource, true, this.parentsToExclude);
                }
            }
            List processReportPayrollList = new Query(ctx, "HR_ProcessReportPayroll", "HR_ProcessReport_ID = ?", null).setParameters(new Object[]{report.getHR_ProcessReport_ID()}).setClient_ID().list();
            processReportLine2 = processReportPayrollList.iterator();
            while (processReportLine2.hasNext()) {
                MHRProcessReportPayroll processReportPayroll = (MHRProcessReportPayroll)processReportLine2.next();
                if (processReportPayroll.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)processReportPayroll);
                packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
                packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
                packOut.createGenericPO(document, (PO)processReportPayroll, true, this.parentsToExclude);
            }
            List processReportTemplateList = new Query(ctx, "HR_ProcessReportTemplate", "HR_ProcessReport_ID = ?", null).setParameters(new Object[]{report.getHR_ProcessReport_ID()}).setClient_ID().list();
            for (MHRProcessReportTemplate processReportTemplate : processReportTemplateList) {
                if (processReportTemplate.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)processReportTemplate);
                packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
                packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
                packOut.createGenericPO(document, (PO)processReportTemplate, true, this.parentsToExclude);
            }
        }
    }
}

