/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.eevolution.model.MHRAttribute;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHREmployeeType;
import org.eevolution.model.MHRJobOpenings;
import org.eevolution.model.MHRLeaveAssign;
import org.eevolution.model.MHRLeaveReason;
import org.eevolution.model.MHRPayroll;
import org.eevolution.model.MHRPayrollConcept;
import org.eevolution.model.MHRRelationship;
import org.eevolution.model.MHRSalaryRange;
import org.eevolution.model.MHRSalaryStructureLine;
import org.eevolution.model.X_HR_JobOpeningHistory;
import org.eevolution.model.X_HR_LeaveTypeCombination;
import org.eevolution.model.X_HR_LeaveTypeEmployeeType;
import org.eevolution.model.X_HR_List;
import org.eevolution.model.X_HR_ListLine;
import org.eevolution.model.X_HR_ListVersion;
import org.spin.model.MHRProcessReport;
import org.spin.model.MHRProcessReportPayroll;
import org.spin.model.MHRProcessReportSource;
import org.spin.model.MHRProcessReportTemplate;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class PayrollExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude = new ArrayList<String>();

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        PackOut packOut = (PackOut)ctx.get("PackOutProcess");
        if (packOut == null) {
            packOut = new PackOut();
            packOut.setLocalContext(ctx);
        }
        this.createEmployeeSetup(ctx, document, packOut);
        this.createRecruitment(ctx, document, packOut);
        this.createPayroll(ctx, document, packOut);
        this.createPayrollReport(ctx, document, packOut);
        this.createLeaveManagement(ctx, document, packOut);
    }

    private void createRecruitment(Properties ctx, TransformerHandler document, PackOut packOut) throws SAXException {
        List careerLevelList = new Query(ctx, "HR_CareerLevel", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object careerLevel : careerLevelList) {
            if (careerLevel.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)careerLevel);
            packOut.createGenericPO(document, (PO)careerLevel, true, this.parentsToExclude);
        }
        List jobEducationList = new Query(ctx, "HR_JobEducation", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object jobEducation : jobEducationList) {
            if (jobEducation.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)jobEducation);
            packOut.createGenericPO(document, (PO)jobEducation, true, this.parentsToExclude);
        }
        List jobTypeList = new Query(ctx, "HR_JobType", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object jobType : jobTypeList) {
            if (jobType.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)jobType);
            packOut.createGenericPO(document, (PO)jobType, true, this.parentsToExclude);
        }
        List salaryRangeList = new Query(ctx, "HR_SalaryRange", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (MHRSalaryRange salaryRange : salaryRangeList) {
            if (salaryRange.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)salaryRange);
            packOut.createGenericPO(document, (PO)salaryRange, true, this.parentsToExclude);
        }
        List jobOpeningsList = new Query(ctx, "HR_JobOpening", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (MHRJobOpenings jobOpening : jobOpeningsList) {
            if (jobOpening.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)jobOpening);
            packOut.createGenericPO(document, (PO)jobOpening, true, this.parentsToExclude);
            List jobOpeningHistoryList = new Query(ctx, "HR_JobOpeningHistory", "HR_JobOpening_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{jobOpening.getHR_JobOpening_ID()}).setClient_ID().setOrderBy("DateTrx").list();
            for (X_HR_JobOpeningHistory jobOpeningHistory : jobOpeningHistoryList) {
                if (jobOpeningHistory.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)jobOpeningHistory);
                packOut.createGenericPO(document, (PO)jobOpeningHistory, true, this.parentsToExclude);
            }
        }
    }

    private void createEmployeeSetup(Properties ctx, TransformerHandler document, PackOut packOut) throws SAXException {
        List salaryStructureList = new Query(ctx, "HR_SalaryStructure", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object salaryStructure : salaryStructureList) {
            if (salaryStructure.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)salaryStructure);
            packOut.createGenericPO(document, (PO)salaryStructure, true, this.parentsToExclude);
            List salaryStructureLineList = new Query(ctx, "HR_SalaryStructureLine", "HR_SalaryStructure_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{salaryStructure.getHR_SalaryStructure_ID()}).setClient_ID().setOrderBy("Amount").list();
            for (MHRSalaryStructureLine salaryStructureLine : salaryStructureLineList) {
                if (salaryStructureLine.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)salaryStructureLine);
                packOut.createGenericPO(document, (PO)salaryStructureLine, true, this.parentsToExclude);
            }
        }
        List designationList = new Query(ctx, "HR_Designation", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object designation : designationList) {
            if (designation.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)designation);
            packOut.createGenericPO(document, (PO)designation, true, this.parentsToExclude);
        }
        List degreeList = new Query(ctx, "HR_Degree", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object degree : degreeList) {
            if (degree.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)degree);
            packOut.createGenericPO(document, (PO)degree, true, this.parentsToExclude);
        }
        List insuranceTypeList = new Query(ctx, "HR_InsuranceType", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object insuranceType : insuranceTypeList) {
            if (insuranceType.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)insuranceType);
            packOut.createGenericPO(document, (PO)insuranceType, true, this.parentsToExclude);
        }
        List skillTypeList = new Query(ctx, "HR_SkillType", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object skillType : skillTypeList) {
            if (skillType.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)skillType);
            packOut.createGenericPO(document, (PO)skillType, true, this.parentsToExclude);
        }
        List raceList = new Query(ctx, "HR_Race", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object race : raceList) {
            if (race.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)race);
            packOut.createGenericPO(document, (PO)race, true, this.parentsToExclude);
        }
        List gradeList = new Query(ctx, "HR_Grade", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object grade : gradeList) {
            if (grade.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)grade);
            packOut.createGenericPO(document, (PO)grade, true, this.parentsToExclude);
        }
        List employeeTypeList = new Query(ctx, "HR_EmployeeType", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (MHREmployeeType employeeType : employeeTypeList) {
            if (employeeType.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)employeeType);
            packOut.createGenericPO(document, (PO)employeeType, true, this.parentsToExclude);
        }
        List relationshipList = new Query(ctx, "HR_Relationship", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (MHRRelationship relationship : relationshipList) {
            if (relationship.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)relationship);
            packOut.createGenericPO(document, (PO)relationship, true, this.parentsToExclude);
        }
    }

    private void createPayroll(Properties ctx, TransformerHandler document, PackOut packOut) throws SAXException {
        List departmentList = new Query(ctx, "HR_Department", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object department : departmentList) {
            if (department.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)department);
            packOut.createGenericPO(document, (PO)department, true, this.parentsToExclude);
        }
        List jobList = new Query(ctx, "HR_Job", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object job : jobList) {
            if (job.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)job);
            packOut.createGenericPO(document, (PO)job, true, this.parentsToExclude);
        }
        List conceptCategoryList = new Query(ctx, "HR_Concept_Category", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object conceptCategory : conceptCategoryList) {
            if (conceptCategory.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)conceptCategory);
            packOut.createGenericPO(document, (PO)conceptCategory, true, this.parentsToExclude);
        }
        List listTypeDefinitionList = new Query(ctx, "HR_ListType", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object listType : listTypeDefinitionList) {
            if (listType.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)listType);
            packOut.createGenericPO(document, (PO)listType, true, this.parentsToExclude);
            List listDefinitionList = new Query(ctx, "HR_List", "HR_ListType_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{listType.getHR_ListType_ID()}).setClient_ID().setOrderBy("Value").list();
            for (X_HR_List listDefinition : listDefinitionList) {
                if (listDefinition.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)listDefinition);
                packOut.createGenericPO(document, (PO)listDefinition, true, this.parentsToExclude);
                List listVersionList = new Query(ctx, "HR_ListVersion", "HR_List_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{listDefinition.getHR_List_ID()}).setClient_ID().setOrderBy("ValidFrom").list();
                Iterator iterator = listVersionList.iterator();
                while (iterator.hasNext()) {
                    X_HR_ListVersion listVersion = (X_HR_ListVersion)iterator.next();
                    if (listVersion.get_ID() < 999999) continue;
                    this.cleanOfficialReference((PO)listVersion);
                    packOut.createGenericPO(document, (PO)listVersion, true, this.parentsToExclude);
                    List listLineList = new Query(ctx, "HR_ListLine", "HR_ListVersion_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{listVersion.getHR_ListVersion_ID()}).setClient_ID().setOrderBy("MinValue").list();
                    for (X_HR_ListLine listLine : listLineList) {
                        if (listLine.get_ID() < 999999) continue;
                        this.cleanOfficialReference((PO)listLine);
                        packOut.createGenericPO(document, (PO)listLine, true, this.parentsToExclude);
                    }
                }
            }
        }
        List conceptTypeList = new Query(ctx, "HR_Concept_Type", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object conceptType : conceptTypeList) {
            if (conceptType.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)conceptType);
            packOut.createGenericPO(document, (PO)conceptType, true, this.parentsToExclude);
        }
        List conceptList = new Query(ctx, "HR_Concept", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (MHRConcept concept : conceptList) {
            if (concept.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)concept);
            packOut.createGenericPO(document, (PO)concept, true, this.parentsToExclude);
            if (concept.isEmployee()) continue;
            List attributeList = new Query(ctx, "HR_Attribute", "HR_Concept_ID = ?", null).setParameters(new Object[]{concept.getHR_Concept_ID()}).setOnlyActiveRecords(true).setClient_ID().setOrderBy("ValidFrom").list();
            for (MHRAttribute attribute : attributeList) {
                if (attribute.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)attribute);
                attribute.set_ValueOfColumn("HR_Employee_ID", null);
                attribute.set_ValueOfColumn("AD_OrgTrx_ID", null);
                packOut.createGenericPO(document, (PO)attribute, true, this.parentsToExclude);
            }
        }
        List payrollList = new Query(ctx, "HR_Payroll", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (MHRPayroll payroll : payrollList) {
            if (payroll.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)payroll);
            packOut.createGenericPO(document, (PO)payroll, true, this.parentsToExclude);
            List payrollConceptList = new Query(ctx, "HR_PayrollConcept", "HR_Payroll_ID = ?", null).setParameters(new Object[]{payroll.getHR_Payroll_ID()}).setOnlyActiveRecords(true).setClient_ID().setOrderBy("SeqNo").list();
            for (MHRPayrollConcept payrollConcept : payrollConceptList) {
                if (payrollConcept.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)payrollConcept);
                packOut.createGenericPO(document, (PO)payrollConcept, true, this.parentsToExclude);
            }
        }
    }

    private void createPayrollReport(Properties ctx, TransformerHandler document, PackOut packOut) throws SAXException {
        List reportList = new Query(ctx, "HR_ProcessReport", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Name").list();
        for (MHRProcessReport report : reportList) {
            Object processReportLine2;
            if (report.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)report);
            packOut.createGenericPO(document, (PO)report, true, this.parentsToExclude);
            List processReportLineList = new Query(ctx, "HR_ProcessReportLine", "HR_ProcessReport_ID = ?", null).setParameters(new Object[]{report.getHR_ProcessReport_ID()}).setOnlyActiveRecords(true).setClient_ID().setOrderBy("SeqNo").list();
            for (Object processReportLine2 : processReportLineList) {
                if (processReportLine2.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)processReportLine2);
                packOut.createGenericPO(document, (PO)processReportLine2, true, this.parentsToExclude);
                List processReportSourceList = new Query(ctx, "HR_ProcessReportSource", "HR_ProcessReportLine_ID = ?", null).setParameters(new Object[]{processReportLine2.getHR_ProcessReportLine_ID()}).setOnlyActiveRecords(true).setClient_ID().setOrderBy("SeqNo").list();
                for (MHRProcessReportSource processReportSource : processReportSourceList) {
                    if (processReportSource.get_ID() < 999999) continue;
                    this.cleanOfficialReference((PO)processReportSource);
                    packOut.createGenericPO(document, (PO)processReportSource, true, this.parentsToExclude);
                }
            }
            List processReportPayrollList = new Query(ctx, "HR_ProcessReportPayroll", "HR_ProcessReport_ID = ?", null).setParameters(new Object[]{report.getHR_ProcessReport_ID()}).setOnlyActiveRecords(true).setClient_ID().list();
            processReportLine2 = processReportPayrollList.iterator();
            while (processReportLine2.hasNext()) {
                MHRProcessReportPayroll processReportPayroll = (MHRProcessReportPayroll)processReportLine2.next();
                if (processReportPayroll.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)processReportPayroll);
                packOut.createGenericPO(document, (PO)processReportPayroll, true, this.parentsToExclude);
            }
            List processReportTemplateList = new Query(ctx, "HR_ProcessReportTemplate", "HR_ProcessReport_ID = ?", null).setParameters(new Object[]{report.getHR_ProcessReport_ID()}).setOnlyActiveRecords(true).setClient_ID().list();
            for (MHRProcessReportTemplate processReportTemplate : processReportTemplateList) {
                if (processReportTemplate.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)processReportTemplate);
                packOut.createGenericPO(document, (PO)processReportTemplate, true, this.parentsToExclude);
            }
        }
    }

    private void createLeaveManagement(Properties ctx, TransformerHandler document, PackOut packOut) throws SAXException {
        List leaveTypeList = new Query(ctx, "HR_LeaveType", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (Object leaveType : leaveTypeList) {
            if (leaveType.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)leaveType);
            packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
            packOut.createGenericPO(document, (PO)leaveType, true, this.parentsToExclude);
            List leaveTypeCombinationList = new Query(ctx, "HR_LeaveTypeCombination", "HR_LeaveType_ID = ?", null).setParameters(new Object[]{leaveType.get_ID()}).setOnlyActiveRecords(true).setClient_ID().list();
            for (X_HR_LeaveTypeCombination leaveTypeCombination : leaveTypeCombinationList) {
                if (leaveType.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)leaveTypeCombination);
                packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
                packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
                packOut.createGenericPO(document, (PO)leaveTypeCombination, true, this.parentsToExclude);
            }
            List leaveTypeEmployeeTypeList = new Query(ctx, "HR_LeaveTypeEmployeeType", "HR_LeaveType_ID = ?", null).setParameters(new Object[]{leaveType.get_ID()}).setOnlyActiveRecords(true).setClient_ID().list();
            for (X_HR_LeaveTypeEmployeeType leaveTypeEmployeeType : leaveTypeEmployeeTypeList) {
                if (leaveType.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)leaveTypeEmployeeType);
                packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
                packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
                packOut.createGenericPO(document, (PO)leaveTypeEmployeeType, true, this.parentsToExclude);
            }
        }
        List leaveReasonList = new Query(ctx, "HR_LeaveReason", null, null).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (MHRLeaveReason leaveReason : leaveReasonList) {
            if (leaveReason.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)leaveReason);
            packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
            packOut.createGenericPO(document, (PO)leaveReason, true, this.parentsToExclude);
        }
        List leaveAssignList = new Query(ctx, "HR_LeaveAssign", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MHRLeaveAssign leaveAssign : leaveAssignList) {
            if (leaveAssign.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)leaveAssign);
            packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
            packOut.createGenericPO(document, (PO)leaveAssign, true, this.parentsToExclude);
        }
    }
}

