/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.I_M_Product;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductPrice;
import org.compiere.model.MTree;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class MaterialManagementExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private int defaultTreeId;
    private PackOut packOut;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.parentsToExclude = new ArrayList<String>();
        this.parentsToExclude.add("C_Currency");
        this.parentsToExclude.add("AD_Tree");
        this.defaultTreeId = MTree.getDefaultTreeIdFromTableId((int)Env.getAD_Client_ID((Properties)ctx), (int)I_M_Product.Table_ID);
        List productList = new Query(ctx, "M_Product", "EXISTS(SELECT 1 \t\t\tFROM AD_TreeNodePR tnm \t\t\tWHERE tnm.Node_ID = M_Product.M_Product_ID \t\t\tAND tnm.AD_Tree_ID = ? \t\t\tAND tnm.Parent_ID = 0)", null).setParameters(new Object[]{this.defaultTreeId}).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
        for (MProduct product : productList) {
            if (product.getM_Product_ID() < 999999) continue;
            this.cleanOfficialReference((PO)product);
            this.exportMenuProduct(product, document);
        }
        List warehouseList = new Query(ctx, "M_Warehouse", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MWarehouse warehouse : warehouseList) {
            if (warehouse.getM_Warehouse_ID() < 999999) continue;
            this.packOut.createGenericPO(document, (PO)warehouse, true, this.parentsToExclude);
            List locatorList = new Query(ctx, "M_Locator", "M_Warehouse_ID = ?", null).setParameters(new Object[]{warehouse.getM_Warehouse_ID()}).setOnlyActiveRecords(true).setClient_ID().list();
            for (MLocator locator : locatorList) {
                this.packOut.createGenericPO(document, (PO)locator, true, this.parentsToExclude);
            }
        }
        this.createProductsForeign(ctx, document, this.parentsToExclude);
    }

    private void createProductsForeign(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List productClassList = new Query(ctx, "M_Product_Class", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (Object productClass : productClassList) {
            if (productClass.get_ID() < 999999) continue;
            this.packOut.createGenericPO(document, (PO)productClass, true, parentsToExclude);
        }
        List productClassificationList = new Query(ctx, "M_Product_Classification", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (Object productClassification : productClassificationList) {
            if (productClassification.get_ID() < 999999) continue;
            this.packOut.createGenericPO(document, (PO)productClassification, true, parentsToExclude);
        }
        List productGroupList = new Query(ctx, "M_Product_Group", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (Object productGroup : productGroupList) {
            if (productGroup.get_ID() < 999999) continue;
            this.packOut.createGenericPO(document, (PO)productGroup, true, parentsToExclude);
        }
        List productCategoryList = new Query(ctx, "M_Product_Category", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MProductCategory productCategory : productCategoryList) {
            if (productCategory.get_ID() < 999999) continue;
            this.packOut.createGenericPO(document, (PO)productCategory, true, parentsToExclude);
        }
        List uomList = new Query(ctx, "C_UOM", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MUOM uom : uomList) {
            if (uom.get_ID() < 999999) continue;
            this.packOut.createGenericPO(document, (PO)uom, true, parentsToExclude);
        }
    }

    private void exportMenuProduct(MProduct product, TransformerHandler document) throws SAXException {
        this.packOut.createGenericPO(document, (PO)product, true, this.parentsToExclude);
        if (product.isSummary()) {
            List elementValueList = new Query(product.getCtx(), "M_Product", "EXISTS(SELECT 1 \t\t\tFROM AD_TreeNodePR tnm \t\t\tWHERE tnm.Node_ID = M_Product.M_Product_ID \t\t\tAND tnm.AD_Tree_ID = ? \t\t\tAND tnm.Parent_ID = ?)", null).setParameters(new Object[]{this.defaultTreeId, product.getM_Product_ID()}).setOnlyActiveRecords(true).setClient_ID().setOrderBy("Value").list();
            for (MProduct productChild : elementValueList) {
                if (productChild.getM_Product_ID() < 999999) continue;
                this.cleanOfficialReference((PO)productChild);
                this.exportMenuProduct(productChild, document);
            }
        }
        this.packOut.createGenericPO(document, (PO)product, true, this.parentsToExclude);
        List productPriceList = new Query(product.getCtx(), "M_ProductPrice", "M_Product_ID = ?", null).setParameters(new Object[]{product.getM_Product_ID()}).setOnlyActiveRecords(true).setClient_ID().list();
        for (MProductPrice productPrice : productPriceList) {
            this.packOut.createGenericPO(document, (PO)productPrice, true, this.parentsToExclude);
        }
        List productUomConversionList = new Query(product.getCtx(), "C_UOM_Conversion", "M_Product_ID = ? OR C_UOM_ID = ?", null).setParameters(new Object[]{product.getM_Product_ID(), product.getC_UOM_ID()}).setOnlyActiveRecords(true).setClient_ID().list();
        for (MUOMConversion productUomConversion : productUomConversionList) {
            this.packOut.createGenericPO(document, (PO)productUomConversion, true, this.parentsToExclude);
        }
    }
}

