/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.MIMPProcessor;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_IMP_ProcessorParameter;
import org.compiere.model.X_IMP_Processor_Type;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class ImportProcessorExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private PackOut packOut;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.parentsToExclude = new ArrayList<String>();
        this.createImportProcessor(ctx, document, this.parentsToExclude);
    }

    private void createImportProcessor(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List processorTypeList = new Query(ctx, "IMP_Processor_Type", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (X_IMP_Processor_Type exportProcessor : processorTypeList) {
            if (exportProcessor.getIMP_Processor_Type_ID() < 999999) continue;
            this.cleanOfficialReference((PO)exportProcessor);
            this.packOut.createGenericPO(document, (PO)exportProcessor, true, parentsToExclude);
        }
        List processorList = new Query(ctx, "IMP_Processor", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MIMPProcessor processor : processorList) {
            if (processor.getIMP_Processor_ID() < 999999) continue;
            this.cleanOfficialReference((PO)processor);
            this.packOut.createGenericPO(document, (PO)processor, true, parentsToExclude);
            List processorParameterList = new Query(ctx, "IMP_ProcessorParameter", "IMP_Processor_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{processor.getIMP_Processor_ID()}).list();
            for (X_IMP_ProcessorParameter parameter : processorParameterList) {
                if (parameter.getIMP_ProcessorParameter_ID() < 999999) continue;
                this.cleanOfficialReference((PO)parameter);
                this.packOut.createGenericPO(document, (PO)parameter, true, parentsToExclude);
            }
        }
    }
}

