/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.impexp.MImpFormat;
import org.compiere.impexp.MImpFormatRow;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class ImportFormatExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private PackOut packOut;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.parentsToExclude = new ArrayList<String>();
        this.parentsToExclude.add("AD_Table");
        this.parentsToExclude.add("AD_Column");
        this.createImportFormat(ctx, document, this.parentsToExclude);
    }

    private void createImportFormat(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List importFormatList = new Query(ctx, "AD_ImpFormat", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MImpFormat importFormat : importFormatList) {
            if (importFormat.getAD_ImpFormat_ID() < 999999) continue;
            this.cleanOfficialReference((PO)importFormat);
            this.packOut.createGenericPO(document, (PO)importFormat, true, parentsToExclude);
            List importFormatRowList = new Query(ctx, "AD_ImpFormat_Row", "AD_ImpFormat_ID = ?", null).setParameters(new Object[]{importFormat.getAD_ImpFormat_ID()}).setOnlyActiveRecords(true).setClient_ID().list();
            for (MImpFormatRow importFormatRow : importFormatRowList) {
                if (importFormatRow.getAD_ImpFormat_ID() < 999999) continue;
                this.cleanOfficialReference((PO)importFormatRow);
                this.packOut.createGenericPO(document, (PO)importFormatRow, true, parentsToExclude);
            }
        }
    }
}

