/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.eevolution.model.MDDVehicleType;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class FleetExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private PackOut packOut;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.parentsToExclude = new ArrayList<String>();
        this.createFleetManagement(ctx, document, this.parentsToExclude);
    }

    private void createFleetManagement(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List compatibilityGroupList = new Query(ctx, "DD_CompatibilityGroup", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (Object compatibilityGroup : compatibilityGroupList) {
            if (compatibilityGroup.getDD_CompatibilityGroup_ID() < 999999) continue;
            this.cleanOfficialReference((PO)compatibilityGroup);
            this.packOut.createGenericPO(document, (PO)compatibilityGroup, true, parentsToExclude);
        }
        List vehicleGroupList = new Query(ctx, "DD_VehicleGroup", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (PO vehicleGroup : vehicleGroupList) {
            if (vehicleGroup.get_ID() < 999999) continue;
            this.cleanOfficialReference(vehicleGroup);
            this.packOut.createGenericPO(document, vehicleGroup, true, parentsToExclude);
        }
        List vehicleTypeList = new Query(ctx, "DD_VehicleType", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MDDVehicleType vehicleType : vehicleTypeList) {
            if (vehicleType.getDD_VehicleType_ID() < 999999) continue;
            this.cleanOfficialReference((PO)vehicleType);
            this.packOut.createGenericPO(document, (PO)vehicleType, true, parentsToExclude);
        }
    }
}

