/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.report.MReport;
import org.compiere.report.MReportColumn;
import org.compiere.report.MReportColumnSet;
import org.compiere.report.MReportLine;
import org.compiere.report.MReportLineSet;
import org.compiere.report.MReportSource;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class FinancialReportExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private PackOut packOut;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.parentsToExclude = new ArrayList<String>();
        this.createReportLineSet(ctx, document, this.parentsToExclude);
        this.createReportColumnSet(ctx, document, this.parentsToExclude);
        this.createFinancialReport(ctx, document, this.parentsToExclude);
    }

    private void createFinancialReport(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List reportList = new Query(ctx, "PA_Report", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MReport report : reportList) {
            if (report.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)report);
            this.packOut.createGenericPO(document, (PO)report, true, parentsToExclude);
        }
    }

    private void createReportColumnSet(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List reportColumnSetList = new Query(ctx, "PA_ReportColumnSet", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MReportColumnSet reportColumnSet : reportColumnSetList) {
            if (reportColumnSet.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)reportColumnSet);
            this.packOut.createGenericPO(document, (PO)reportColumnSet, true, parentsToExclude);
            List reportColumnList = new Query(ctx, "PA_ReportColumn", "PA_ReportColumnSet_ID = ?", null).setParameters(new Object[]{reportColumnSet.getPA_ReportColumnSet_ID()}).setOnlyActiveRecords(true).setClient_ID().setOrderBy("SeqNo").list();
            for (MReportColumn reportColumn : reportColumnList) {
                if (reportColumn.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)reportColumn);
                this.packOut.createGenericPO(document, (PO)reportColumn, true, parentsToExclude);
                List reportSourceList = new Query(ctx, "PA_ReportSource", "PA_ReportColumn_ID = ?", null).setParameters(new Object[]{reportColumn.getPA_ReportColumn_ID()}).setOnlyActiveRecords(true).setClient_ID().list();
                for (MReportSource reportSource : reportSourceList) {
                    if (reportSource.get_ID() < 999999) continue;
                    this.cleanOfficialReference((PO)reportColumn);
                    this.packOut.createGenericPO(document, (PO)reportSource, true, parentsToExclude);
                }
            }
        }
    }

    private void createReportLineSet(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List reportLineSetList = new Query(ctx, "PA_ReportLineSet", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MReportLineSet reportLineSet : reportLineSetList) {
            if (reportLineSet.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)reportLineSet);
            this.packOut.createGenericPO(document, (PO)reportLineSet, true, parentsToExclude);
            List reportLineList = new Query(ctx, "PA_ReportLine", "PA_ReportLineSet_ID = ?", null).setParameters(new Object[]{reportLineSet.getPA_ReportLineSet_ID()}).setOnlyActiveRecords(true).setClient_ID().setOrderBy("SeqNo").list();
            for (MReportLine reportLine : reportLineList) {
                if (reportLine.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)reportLine);
                this.packOut.createGenericPO(document, (PO)reportLine, true, parentsToExclude);
                List reportSourceList = new Query(ctx, "PA_ReportSource", "PA_ReportLine_ID = ?", null).setParameters(new Object[]{reportLine.getPA_ReportLine_ID()}).setOnlyActiveRecords(true).setClient_ID().list();
                for (MReportSource reportSource : reportSourceList) {
                    if (reportSource.get_ID() < 999999) continue;
                    this.cleanOfficialReference((PO)reportLine);
                    this.packOut.createGenericPO(document, (PO)reportSource, true, parentsToExclude);
                }
            }
        }
    }
}

