/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.MEXPProcessor;
import org.compiere.model.MEXPProcessorParameter;
import org.compiere.model.MEXPProcessorType;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class ExportProcessorExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private PackOut packOut;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.parentsToExclude = new ArrayList<String>();
        this.createExportProcessor(ctx, document, this.parentsToExclude);
    }

    private void createExportProcessor(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List processorTypeList = new Query(ctx, "EXP_Processor_Type", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MEXPProcessorType exportProcessor : processorTypeList) {
            if (exportProcessor.getEXP_Processor_Type_ID() < 999999) continue;
            this.cleanOfficialReference((PO)exportProcessor);
            this.packOut.createGenericPO(document, (PO)exportProcessor, true, parentsToExclude);
        }
        List processorList = new Query(ctx, "EXP_Processor", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MEXPProcessor processor : processorList) {
            if (processor.getEXP_Processor_ID() < 999999) continue;
            this.cleanOfficialReference((PO)processor);
            this.packOut.createGenericPO(document, (PO)processor, true, parentsToExclude);
            List processorParameterList = new Query(ctx, "EXP_ProcessorParameter", "EXP_Processor_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{processor.getEXP_Processor_ID()}).list();
            for (MEXPProcessorParameter parameter : processorParameterList) {
                if (parameter.getEXP_ProcessorParameter_ID() < 999999) continue;
                this.cleanOfficialReference((PO)parameter);
                this.packOut.createGenericPO(document, (PO)parameter, true, parentsToExclude);
            }
        }
    }
}

