/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.MEXPFormat;
import org.compiere.model.MEXPFormatLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class ExportFormatExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private PackOut packOut;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.parentsToExclude = new ArrayList<String>();
        this.createExportFormat(ctx, document, this.parentsToExclude, 0);
    }

    private void createExportFormat(Properties ctx, TransformerHandler document, List<String> parentsToExclude, int exportFormatId) throws SAXException {
        String whereClause = "EXP_Format_ID = " + exportFormatId;
        List exportFormatList = new Query(ctx, "EXP_Format", exportFormatId != 0 ? whereClause : null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MEXPFormat exportFormat : exportFormatList) {
            if (exportFormat.getEXP_Format_ID() < 999999) continue;
            this.cleanOfficialReference((PO)exportFormat);
            this.packOut.createGenericPO(document, (PO)exportFormat, true, parentsToExclude);
            List formatLineList = new Query(ctx, "EXP_FormatLine", "EXP_Format_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{exportFormat.getEXP_Format_ID()}).list();
            for (MEXPFormatLine formatLine : formatLineList) {
                if (formatLine.getEXP_FormatLine_ID() < 999999) continue;
                this.cleanOfficialReference((PO)formatLine);
                if ((formatLine.getType().equals("M") || formatLine.getType().equals("R")) && formatLine.getEXP_EmbeddedFormat_ID() != 0) {
                    this.createExportFormat(ctx, document, parentsToExclude, formatLine.getEXP_EmbeddedFormat_ID());
                }
                this.packOut.createGenericPO(document, (PO)formatLine, true, parentsToExclude);
            }
        }
    }
}

