/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.MCity;
import org.compiere.model.MCountry;
import org.compiere.model.MRegion;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class CountryExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private PackOut packOut;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.parentsToExclude = new ArrayList<String>();
        this.createCountry(ctx, document, this.parentsToExclude);
    }

    private void createCountry(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List countryList = new Query(ctx, "C_Country", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MCountry country : countryList) {
            if (country.get_ID() < 999999) continue;
            this.cleanOfficialReference((PO)country);
            this.packOut.createGenericPO(document, (PO)country, true, parentsToExclude);
            List regionList = new Query(ctx, "C_Region", "C_Country_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{country.get_ID()}).list();
            for (MRegion region : regionList) {
                if (region.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)region);
                this.packOut.createGenericPO(document, (PO)region, true, parentsToExclude);
            }
            List cityList = new Query(ctx, "C_City", "C_Country_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{country.get_ID()}).list();
            for (MCity city : cityList) {
                if (city.get_ID() < 999999) continue;
                this.cleanOfficialReference((PO)city);
                this.packOut.createGenericPO(document, (PO)city, true, parentsToExclude);
            }
        }
    }
}

