/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class CleanDefinitionExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private PackOut packOut;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.parentsToExclude = new ArrayList<String>();
        this.createCleanDefinition(ctx, document, this.parentsToExclude);
    }

    private void createCleanDefinition(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List cleanDefinitionList = new Query(ctx, "AD_CleanDefinition", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (PO cleanDefinition : cleanDefinitionList) {
            if (cleanDefinition.get_ID() < 999999) continue;
            this.cleanOfficialReference(cleanDefinition);
            this.packOut.createGenericPO(document, cleanDefinition, true, parentsToExclude);
            List cleanDefinitionTableList = new Query(ctx, "AD_CleanDefinitionTable", "AD_CleanDefinition_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{cleanDefinition.get_ID()}).list();
            for (PO cleanDefinitionTable : cleanDefinitionTableList) {
                if (cleanDefinitionTable.get_ID() < 999999) continue;
                this.cleanOfficialReference(cleanDefinitionTable);
                this.packOut.createGenericPO(document, cleanDefinitionTable, true, parentsToExclude);
            }
        }
    }
}

