/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.MGoal;
import org.compiere.model.MGoalRestriction;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class Charts
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private PackOut packOut;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.parentsToExclude = new ArrayList<String>();
        this.createCharts(ctx, document, this.parentsToExclude);
    }

    private void createCharts(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List measures = new Query(ctx, "PA_Measure", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (Object measure : measures) {
            if (measure.getPA_Measure_ID() < 999999) continue;
            this.cleanOfficialReference((PO)measure);
            this.packOut.createGenericPO(document, (PO)measure, true, parentsToExclude);
        }
        List measuresCalculation = new Query(ctx, "PA_MeasureCalc", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (Object measureCalculation : measuresCalculation) {
            if (measureCalculation.getPA_MeasureCalc_ID() < 999999) continue;
            this.cleanOfficialReference((PO)measureCalculation);
            this.packOut.createGenericPO(document, (PO)measureCalculation, true, parentsToExclude);
        }
        List ratios = new Query(ctx, "PA_Ratio", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (Object ratio : ratios) {
            if (ratio.getPA_Ratio_ID() < 999999) continue;
            this.cleanOfficialReference((PO)ratio);
            this.packOut.createGenericPO(document, (PO)ratio, true, parentsToExclude);
        }
        List goals = new Query(ctx, "PA_Goal", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MGoal goal : goals) {
            if (goal.getPA_Goal_ID() < 999999) continue;
            this.cleanOfficialReference((PO)goal);
            this.packOut.createGenericPO(document, (PO)goal, true, parentsToExclude);
        }
        List restrictions = new Query(ctx, "PA_GoalRestriction", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MGoalRestriction restriction : restrictions) {
            if (restriction.getPA_Goal_ID() < 999999) continue;
            this.cleanOfficialReference((PO)restriction);
            this.packOut.createGenericPO(document, (PO)restriction, true, parentsToExclude);
        }
    }
}

